/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.impl;

import de.ikv.emf.qvt.EMFQvtProcessorImpl;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.Domain;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtTransformationInvocation;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtinvocationFactory;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtinvocationPackage;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.impl.DomainImpl;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.impl.QvtTransformationInvocationImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.oslo.ocl20.syntax.ast.qvt.ModelDeclarationAS;
import org.oslo.ocl20.syntax.ast.qvt.TopLevelAS;
import org.oslo.ocl20.syntax.ast.qvt.TransformationAS;
import uk.ac.kent.cs.kmf.util.ConsoleLog;
import uk.ac.kent.cs.kmf.util.ILog;

public class QvtinvocationFactoryImpl
extends EFactoryImpl
implements QvtinvocationFactory {
    public static QvtinvocationFactory init() {
        try {
            QvtinvocationFactory theQvtinvocationFactory = (QvtinvocationFactory)EPackage.Registry.INSTANCE.getEFactory("http://es.upv.dsic.issi/qvt/invocation");
            if (theQvtinvocationFactory != null) {
                return theQvtinvocationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new QvtinvocationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createQvtTransformationInvocation();
            }
            case 1: {
                return this.createDomain();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createIPathFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertIPathToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public QvtTransformationInvocation createQvtTransformationInvocation() {
        QvtTransformationInvocationImpl qvtTransformationInvocation = new QvtTransformationInvocationImpl();
        return qvtTransformationInvocation;
    }

    public QvtTransformationInvocation createQvtTransformationInvocation(IFile file) {
        QvtTransformationInvocation invocation = null;
        EMFQvtProcessorImpl emfQvtProcessorImpl = new EMFQvtProcessorImpl((ILog)new ConsoleLog());
        try {
            TopLevelAS topLevelAS = emfQvtProcessorImpl.parseQvt((Reader)new InputStreamReader(file.getContents()));
            EList list = topLevelAS.getTransformations();
            if (list != null) {
                if (list.size() > 0) {
                    if (list.size() > 1) {
                        emfQvtProcessorImpl.getLog().printMessage("The file contains more than one transformation!");
                    }
                    if (list.get(0) instanceof TransformationAS) {
                        EList models = ((TransformationAS)list.get(0)).getModelDeclarations();
                        invocation = QvtinvocationFactory.eINSTANCE.createQvtTransformationInvocation();
                        invocation.setName(((TransformationAS)list.get(0)).getName());
                        invocation.setPath(file.getFullPath());
                        Domain domain = null;
                        for (ModelDeclarationAS model : models) {
                            domain = QvtinvocationFactory.eINSTANCE.createDomain();
                            domain.setName(model.getModelId());
                            domain.setNsPrefix((String)model.getMetaModelIds().get(0));
                            invocation.getDomains().add((Object)domain);
                        }
                        invocation.setDirection(domain);
                    }
                }
            } else {
                emfQvtProcessorImpl.getLog().printMessage("Invalid QVT transformation");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            emfQvtProcessorImpl.getLog().printMessage("Unable to retrieve file contents");
        }
        return invocation;
    }

    public QvtTransformationInvocation createQvtTransformationInvocation(String XMI) throws IOException {
        Resource res = new ResourceSetImpl().createResource(URI.createURI((String)"In memory resource"));
        res.load((InputStream)new ByteArrayInputStream(XMI.getBytes()), null);
        if (!res.getContents().isEmpty()) {
            return (QvtTransformationInvocation)res.getContents().get(0);
        }
        return null;
    }

    public Domain createDomain() {
        DomainImpl domain = new DomainImpl();
        return domain;
    }

    public IPath createIPathFromString(EDataType eDataType, String initialValue) {
        return new Path(initialValue);
    }

    public String convertIPathToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public QvtinvocationPackage getQvtinvocationPackage() {
        return (QvtinvocationPackage)this.getEPackage();
    }

    @Deprecated
    public static QvtinvocationPackage getPackage() {
        return QvtinvocationPackage.eINSTANCE;
    }
}

