/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.ocl.validator.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConvertToTextAction
implements IObjectActionDelegate {
    private Shell shell;
    private static String annotationURI = "http://www.eclipse.org/ocl/examples/OCL";
    private IFile file;
    private MessageConsole console = new MessageConsole("OCL Validator", null);
    private MessageConsoleStream messageStream = this.console.newMessageStream();
    private MessageConsoleStream errorStream = this.console.newMessageStream();

    public ConvertToTextAction() {
        this.errorStream.setColor(Display.getCurrent().getSystemColor(3));
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    protected void finalize() throws Throwable {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
        super.finalize();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Resource model = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        model = resourceSet.getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)false), true);
        try {
            model.load(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile(this.file.getFullPath().removeFileExtension().addFileExtension("ocl"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EPackage pkg = (EPackage)model.getContents().get(0);
        try {
            outputStream.write("package ".getBytes());
            outputStream.write(pkg.getName().getBytes());
            outputStream.write("\n\n".getBytes());
            for (EObject eObject : pkg.eContents()) {
                if (!(eObject instanceof EClass)) continue;
                EClass eClass = (EClass)eObject;
                for (EAnnotation eAnnotation : eClass.getEAnnotations()) {
                    if (!eAnnotation.getSource().equals("http://www.eclipse.org/ocl/examples/OCL") || eAnnotation.getDetails().isEmpty()) continue;
                    outputStream.write("\tcontext ".getBytes());
                    outputStream.write(eClass.getName().getBytes());
                    outputStream.write("\n\n".getBytes());
                    for (Map.Entry constraint : eAnnotation.getDetails()) {
                        outputStream.write("\t\tinv ".getBytes());
                        outputStream.write(((String)constraint.getKey()).getBytes());
                        outputStream.write(" : ".getBytes());
                        outputStream.write(((String)constraint.getValue()).getBytes());
                        outputStream.write("\n\n".getBytes());
                    }
                    outputStream.write("\n".getBytes());
                }
            }
            outputStream.write("endpackage\n".getBytes());
            if (!result.exists()) {
                result.create((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), 2, null);
            } else {
                result.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), 2, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)obj;
        }
    }
}

