/*
 * Decompiled with CFR 0.152.
 */
package features.diagram.edit.commands;

import features.Feature;
import features.FeatureModel;
import features.RelatableElement;
import features.StructuralRelationship;
import features.diagram.edit.policies.FeaturesBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class StructuralRelationshipReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public StructuralRelationshipReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof StructuralRelationship)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof RelatableElement) || !(this.newEnd instanceof RelatableElement)) {
            return false;
        }
        Feature target = this.getLink().getTo();
        if (!(this.getLink().eContainer() instanceof FeatureModel)) {
            return false;
        }
        FeatureModel container = (FeatureModel)this.getLink().eContainer();
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistStructuralRelationship_3001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Feature) || !(this.newEnd instanceof Feature)) {
            return false;
        }
        RelatableElement source = this.getLink().getFrom();
        if (!(this.getLink().eContainer() instanceof FeatureModel)) {
            return false;
        }
        FeatureModel container = (FeatureModel)this.getLink().eContainer();
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistStructuralRelationship_3001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setFrom(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTo(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected StructuralRelationship getLink() {
        return (StructuralRelationship)this.getElementToEdit();
    }

    protected RelatableElement getOldSource() {
        return (RelatableElement)this.oldEnd;
    }

    protected RelatableElement getNewSource() {
        return (RelatableElement)this.newEnd;
    }

    protected Feature getOldTarget() {
        return (Feature)this.oldEnd;
    }

    protected Feature getNewTarget() {
        return (Feature)this.newEnd;
    }
}

