/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.moment.ui.registeredmodels.views;

import es.upv.dsic.issi.moment.registeremf.RegisterEMFPlugin;
import es.upv.dsic.issi.moment.registeremf.utils.EPackageRegistryObserver;
import es.upv.dsic.issi.moment.ui.registeredmodels.editor.EPackageEditorInput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class MetaModelsView
extends ViewPart {
    private TableViewer viewer;
    private IAction actionOpen;
    private IAction actionAdd;
    private IAction actionSave;
    private IAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MetaModelsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.actionOpen);
        manager.add(this.actionRefresh);
        manager.add(this.actionSave);
        manager.add(this.actionAdd);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.actionRefresh);
        manager.add(this.actionOpen);
        manager.add(this.actionSave);
        manager.add(this.actionAdd);
        manager.add((IAction)new PropertyDialogAction(this.getSite().getShell(), (ISelectionProvider)this.viewer));
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.actionRefresh);
        manager.add(this.actionSave);
        manager.add(this.actionAdd);
        manager.add(this.actionOpen);
    }

    private void makeActions() {
        this.actionOpen = new Action(){

            public void run() {
                EPackage pkg = null;
                Object selection = MetaModelsView.this.viewer.getSelection() instanceof IStructuredSelection ? ((IStructuredSelection)MetaModelsView.this.viewer.getSelection()).getFirstElement() : MetaModelsView.this.viewer.getSelection();
                if (selection instanceof EPackage) {
                    pkg = (EPackage)selection;
                } else if (selection instanceof EPackage.Descriptor) {
                    pkg = ((EPackage.Descriptor)selection).getEPackage();
                }
                EPackageEditorInput model = new EPackageEditorInput(pkg);
                try {
                    IWorkbenchPage page = MetaModelsView.this.getSite().getWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)model, (String)"moment.reflectivePackageEditor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.actionOpen.setText("Ver");
        this.actionOpen.setToolTipText("Ver");
        this.actionOpen.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionAdd = new Action(){

            public void run() {
                MetaModelsView.this.showMessage("Not implemented yet");
            }
        };
        this.actionAdd.setText("Register..");
        this.actionAdd.setToolTipText("Register a model");
        this.actionAdd.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.actionSave = new Action(){

            public void run() {
                IFile file;
                SaveAsDialog saveAsDialog = new SaveAsDialog(MetaModelsView.this.getSite().getShell());
                saveAsDialog.open();
                IPath path = saveAsDialog.getResult();
                if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
                    String targetPath = file.getFullPath().toString();
                    EPackage pkg = null;
                    Object selection = MetaModelsView.this.viewer.getSelection() instanceof IStructuredSelection ? ((IStructuredSelection)MetaModelsView.this.viewer.getSelection()).getFirstElement() : MetaModelsView.this.viewer.getSelection();
                    if (selection instanceof EPackage) {
                        pkg = (EPackage)selection;
                    } else if (selection instanceof EPackage.Descriptor) {
                        pkg = ((EPackage.Descriptor)selection).getEPackage();
                    }
                    ResourceSetImpl rs = new ResourceSetImpl();
                    URI targetURI = URI.createFileURI((String)targetPath);
                    Resource r = rs.createResource(targetURI);
                    pkg.eResource();
                    r.getContents().add((Object)pkg);
                    try {
                        r.save(null);
                    }
                    catch (IOException iOException) {
                        MessageBox m = new MessageBox(MetaModelsView.this.getSite().getShell(), 33);
                        m.setMessage("I/O Error");
                        m.open();
                    }
                }
            }
        };
        this.actionSave.setText("Save as..");
        this.actionSave.setToolTipText("Save as..");
        this.actionSave.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.actionRefresh = new Action(){

            public void run() {
                MetaModelsView.this.showMessage("Not implemented yet");
            }
        };
        this.actionRefresh.setText("Actualizar");
        this.actionRefresh.setToolTipText("Actualizar");
        try {
            this.actionRefresh.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.jdt.ui/icons/full/dlcl16/refresh_nav.gif")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.actionRefresh);
        this.actionRefresh = this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.REFRESH.getId());
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MetaModelsView.this.actionOpen.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)new Shell(), (String)"Moment", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements EPackageRegistryObserver,
    IStructuredContentProvider {
        ViewContentProvider() {
            RegisterEMFPlugin.getDefault().addRegistryObserver((EPackageRegistryObserver)this);
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            ArrayList<EPackage> elements = new ArrayList<EPackage>();
            Object[] objectArray = registry.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                try {
                    elements.add(registry.getEPackage((String)key));
                }
                catch (Throwable throwable) {}
                ++n2;
            }
            return elements.toArray();
        }

        public void packageAdded(EPackage pkg) {
            MetaModelsView.this.viewer.add((Object)pkg);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public String getText(Object obj) {
            block4: {
                try {
                    if (obj != null) break block4;
                    return "";
                }
                catch (Throwable throwable) {
                    return "???";
                }
            }
            if (obj instanceof EPackage) {
                return String.valueOf(((EPackage)obj).getNsPrefix()) + " (" + ((EPackage)obj).getNsURI() + ")";
            }
            return obj.toString();
        }
    }
}

