/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.qvt.launcher.ui.internal;

import de.ikv.emf.qvt.EMFQvtProcessorImpl;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtTransformationInvocation;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtinvocationFactory;
import es.upv.dsic.issi.qvt.launcher.ui.QvtLauncherUiPlugin;
import es.upv.dsic.issi.qvt.launcher.ui.internal.ExtensionFilter;
import es.upv.dsic.issi.qvt.launcher.ui.internal.ParamsCellModifier;
import es.upv.dsic.issi.qvt.launcher.ui.internal.ParamsContentProvider;
import es.upv.dsic.issi.qvt.launcher.ui.internal.ParamsLabelProvider;
import es.upv.dsic.issi.qvt.launcher.ui.internal.ResourcesTreeSelectionDialog;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.oslo.ocl20.syntax.ast.qvt.ModelDeclarationAS;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class QvtMainTab
extends AbstractLaunchConfigurationTab {
    private static final String QVT_EXTENSION = "qvt";
    private Text transformationName;
    private Button browseFileButton;
    private TableViewer inputsTableViewer;
    private EList<ModelDeclarationAS> models;
    private QvtTransformationInvocation invocation = null;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout(1, true);
        comp.setLayout((Layout)topLayout);
        Group groupFilename = new Group(comp, 0);
        groupFilename.setLayoutData((Object)new GridData(768));
        groupFilename.setText("QVT Transformation");
        GridLayout twoColumns = new GridLayout(2, false);
        groupFilename.setLayout((Layout)twoColumns);
        this.transformationName = new Text((Composite)groupFilename, 2052);
        this.transformationName.setLayoutData((Object)new GridData(768));
        this.transformationName.setEditable(false);
        this.browseFileButton = new Button((Composite)groupFilename, 8);
        this.browseFileButton.setText("Browse...");
        this.browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                QvtMainTab.this.handleBrowseButton(QvtMainTab.this.getShell());
            }
        });
        Group groupInputs = new Group(comp, 0);
        groupInputs.setLayoutData((Object)new GridData(1808));
        groupInputs.setLayout((Layout)new FillLayout());
        groupInputs.setText("Input Parameters");
        this.inputsTableViewer = this.createTable(groupInputs);
    }

    public String getName() {
        return "Arguments";
    }

    public Image getImage() {
        return QvtLauncherUiPlugin.getImageDescriptor("icons/transf_arguments.png").createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String XMI = configuration.getAttribute("invocation_xmi", "");
            this.invocation = QvtinvocationFactory.eINSTANCE.createQvtTransformationInvocation(XMI);
            this.transformationName.setText(String.valueOf(this.invocation.getName()) + " (" + URI.createPlatformResourceURI((String)this.invocation.getPath().toString(), (boolean)true) + ")");
            this.inputsTableViewer.setInput((Object)this.invocation);
            this.inputsTableViewer.refresh();
        }
        catch (IOException iOException) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.invocation != null) {
            try {
                configuration.setAttribute("invocation_xmi", this.invocation.toXMI());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.invocation = null;
    }

    protected void setDirty(boolean dirty) {
        if (dirty && this.getLaunchConfigurationDialog() != null) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isValid = true;
        if (this.invocation == null) {
            this.setErrorMessage("Please select a QVT transformation file");
            isValid = false;
        } else {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)this.invocation);
            if (diagnostic.getSeverity() == 4) {
                isValid = false;
                this.setErrorMessage(((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
            }
        }
        if (isValid) {
            this.setErrorMessage(null);
        }
        this.getLaunchConfigurationDialog().updateMessage();
        return isValid;
    }

    protected void handleBrowseButton(Shell shell) {
        IFile transformationFile = QvtMainTab.openIFileDialog(shell, QvtMainTab.getSelectedResource(), QVT_EXTENSION);
        if (transformationFile != null) {
            OutputStreamLog log = new OutputStreamLog((OutputStream)System.err);
            new EMFQvtProcessorImpl((ILog)log);
            this.invocation = QvtinvocationFactory.eINSTANCE.createQvtTransformationInvocation(transformationFile);
            if (this.invocation != null) {
                this.transformationName.setText(String.valueOf(this.invocation.getName()) + " (" + URI.createPlatformResourceURI((String)this.invocation.getPath().toString(), (boolean)false) + ")");
                this.inputsTableViewer.setInput((Object)this.invocation);
                this.getLaunchConfigurationDialog().setName(this.getLaunchConfigurationDialog().generateName(this.invocation.getName()));
                this.updateLaunchConfigurationDialog();
            } else {
                this.setErrorMessage("The selected file does not contain a valid QVT transformation");
            }
            this.setDirty(true);
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    public static IFile openIFileDialog(Shell shell, IResource initialSelection, String ... extensionsAllowed) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (extensionsAllowed.length > 0) {
            dialog.addFilter((ViewerFilter)new ExtensionFilter(extensionsAllowed));
        }
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource && ((IResource)element).getName().charAt(0) == '.') {
                    return false;
                }
                return !(element instanceof IContainer) || ((IContainer)element).isAccessible();
            }
        });
        dialog.setComparator((ViewerComparator)new ViewerSorter(){

            public int category(Object element) {
                return element instanceof IFile ? 1 : 0;
            }
        });
        dialog.setTitle("Select transformation file");
        if (initialSelection != null) {
            if (initialSelection instanceof IFile && !initialSelection.getFileExtension().equals(QVT_EXTENSION)) {
                dialog.setInitialSelections(new Object[]{((IFile)initialSelection).getParent()});
            } else {
                dialog.setInitialSelections(new Object[]{initialSelection});
            }
        }
        dialog.open();
        Object[] selected = dialog.getResult();
        return (IFile)(selected != null && selected[0] instanceof IFile ? selected[0] : null);
    }

    private TableViewer createTable(Group parent) {
        TableViewer tableViewer = new TableViewer((Composite)parent, 68352);
        Table tableControl = (Table)tableViewer.getControl();
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        String[] names = new String[]{"", "Target", "Domain name", "Metamodel", "File"};
        int[] nArray = new int[5];
        nArray[1] = 50;
        nArray[2] = 140;
        nArray[3] = 140;
        nArray[4] = 340;
        int[] widths = nArray;
        int[] alignments = new int[]{0x1000000, 0x1000000, 0x1000000, 0x1000000, 16384};
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        boolean[] resizable = blArray;
        int i = 0;
        while (i < names.length) {
            TableColumn tc = new TableColumn(tableControl, alignments[i]);
            tc.setText(names[i]);
            tc.setWidth(widths[i]);
            tc.setResizable(resizable[i]);
            tc.setMoveable(false);
            ++i;
        }
        tableViewer.setColumnProperties(new String[]{"dummy", "target", "domain", "metamodel", "file"});
        tableViewer.setContentProvider((IContentProvider)new ParamsContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ParamsLabelProvider((Viewer)tableViewer));
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[1] = new CheckboxCellEditor((Composite)tableControl);
        cellEditorArray[2] = new TextCellEditor((Composite)tableControl);
        cellEditorArray[3] = new TextCellEditor((Composite)tableControl);
        cellEditorArray[4] = new DialogCellEditor((Composite)tableControl){

            protected Object openDialogBox(Control cellEditorWindow) {
                ResourcesTreeSelectionDialog dialog = new ResourcesTreeSelectionDialog(cellEditorWindow.getShell());
                dialog.setInitialSelection(QvtMainTab.getSelectedResource());
                dialog.setTitle("Select input model");
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IFile) {
                    return ((IFile)dialog.getFirstResult()).getFullPath();
                }
                return null;
            }
        };
        tableViewer.setCellEditors(cellEditorArray);
        tableViewer.setCellModifier((ICellModifier)new ParamsCellModifier(this, (Viewer)tableViewer));
        return tableViewer;
    }

    public void setDirty() {
        this.setDirty(true);
    }

    public void refreshAll() {
        this.inputsTableViewer.refresh();
    }

    public static IResource getSelectedResource() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IResource selResource = QvtMainTab.getSelectedResource(page);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page) {
        IResource selResource = null;
        ISelection sel = page.getSelection();
        selResource = QvtMainTab.getSelectedResource(page, sel);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page, ISelection sel) {
        IEditorPart editor;
        IEditorInput input;
        IResource selResource = null;
        if (sel instanceof StructuredSelection) {
            IAdaptable adaptable;
            StructuredSelection ssel = (StructuredSelection)sel;
            Object element = ssel.getFirstElement();
            if (element instanceof IResource) {
                selResource = (IResource)element;
            } else if (element instanceof IAdaptable && (selResource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && page.getActiveEditor() != null) {
                selResource = (IResource)page.getActiveEditor().getAdapter(IResource.class);
            }
        } else if (sel instanceof TextSelection && (input = (editor = page.getActiveEditor()).getEditorInput()) instanceof IFileEditorInput) {
            selResource = ((IFileEditorInput)input).getFile();
        }
        return selResource;
    }
}

