/*
 * Decompiled with CFR 0.152.
 */
package features_diagram.diagram.edit.parts.helpers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class FoldedRectangle
extends Shape {
    private int foldSize = 20;

    protected void outlineShape(Graphics graphics) {
        Rectangle r = this.getBounds();
        PointList points = new PointList();
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + this.lineWidth / 2 + this.foldSize);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + r.height - Math.max(1, this.lineWidth));
        points.addPoint(r.x + this.lineWidth / 2, r.y + r.height - Math.max(1, this.lineWidth));
        points.addPoint(r.x + this.lineWidth / 2, r.y + this.lineWidth / 2);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2 + this.foldSize);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + this.lineWidth / 2 + this.foldSize);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2);
        graphics.drawPolyline(points);
    }

    protected void fillShape(Graphics graphics) {
        Color bgColor = this.getBackgroundColor();
        Rectangle r = this.getBounds();
        PointList points = new PointList();
        points.addPoint(r.x + this.lineWidth / 2, r.y + this.lineWidth / 2);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + this.lineWidth / 2 + this.foldSize);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + r.height - Math.max(1, this.lineWidth));
        points.addPoint(r.x + this.lineWidth / 2, r.y + r.height - Math.max(1, this.lineWidth));
        graphics.fillPolygon(points);
        Color foldColor = new Color((Device)Display.getCurrent(), Math.min(bgColor.getRed() - 32, 255), Math.min(bgColor.getGreen() - 32, 255), Math.min(bgColor.getBlue() - 32, 255));
        graphics.setBackgroundColor(foldColor);
        points.removeAllPoints();
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth) - this.foldSize, r.y + this.lineWidth / 2 + this.foldSize);
        points.addPoint(r.x + r.width - Math.max(1, this.lineWidth), r.y + this.lineWidth / 2 + this.foldSize);
        graphics.fillPolygon(points);
        graphics.setBackgroundColor(bgColor);
    }

    public void setFoldSize(int foldSize) {
        this.foldSize = foldSize;
    }
}

