/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.ocl.validator.popup.actions;

import es.upv.dsic.issi.ocl.validator.popup.actions.OclDiagnostic;
import es.upv.dsic.issi.ocl.validator.popup.actions.OclDiagnosticChain;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ValidateAction
implements IObjectActionDelegate {
    private Shell shell;
    private static String annotationURI = "http://www.eclipse.org/ocl/examples/OCL";
    private IFile file;
    private MessageConsole console = new MessageConsole("OCL Validator", null);
    private MessageConsoleStream messageStream = this.console.newMessageStream();
    private MessageConsoleStream errorStream = this.console.newMessageStream();

    public ValidateAction() {
        this.errorStream.setColor(Display.getCurrent().getSystemColor(3));
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    protected void finalize() throws Throwable {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
        super.finalize();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Resource model = null;
        EPackage metamodelPackage = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        model = resourceSet.getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)false), true);
        try {
            model.load(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            this.showError(e1.getLocalizedMessage());
            e1.printStackTrace();
        }
        metamodelPackage = (EPackage)((EObject)model.getContents().get(0)).eClass().eContainer();
        Diagnostic res = Diagnostician.INSTANCE.validate((EObject)model.getContents().get(0));
        if (res.getSeverity() == 4) {
            this.showError(res.toString());
            return;
        }
        try {
            OclDiagnosticChain oclDiagnosticChain = ValidateAction.evaluateModel(metamodelPackage, model);
            this.showMessage(oclDiagnosticChain.toString(false));
            this.showMessage("Global result: " + oclDiagnosticChain.getResult());
            MessageDialog.openInformation((Shell)this.shell, (String)"Validation result", (String)("Global result: " + oclDiagnosticChain.getResult()));
        }
        catch (ParserException e) {
            this.showError(e.getLocalizedMessage());
        }
    }

    private void showMessage(String localizedMessage) {
        try {
            this.messageStream.write(String.valueOf(localizedMessage) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showError(String localizedMessage) {
        try {
            this.errorStream.write(String.valueOf(localizedMessage) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)obj;
        }
    }

    private static OclDiagnosticChain evaluateModel(EPackage metamodelPackage, Resource model) throws ParserException {
        OclDiagnosticChain oclDiagnosticChain = new OclDiagnosticChain();
        TreeIterator metamodelElementIterator = metamodelPackage.eAllContents();
        EAnnotation eAnnotation = metamodelPackage.getEAnnotation(annotationURI);
        if (eAnnotation != null) {
            for (String oclKey : eAnnotation.getDetails().keySet()) {
                String oclConstraint = EcoreUtil.getAnnotation((EModelElement)metamodelPackage, (String)annotationURI, (String)oclKey);
                if (oclConstraint == null) {
                    throw new ParserException("Unable to find an OCL expression with the key \"" + oclKey + "\" in the EPackage \"" + metamodelPackage.getName() + "\"");
                }
                oclDiagnosticChain.add(new OclDiagnostic((EObject)model.getContents().get(0), oclKey, oclConstraint, ValidateAction.evaluateOclBooleanExpression(model.getContents().get(0), oclConstraint)));
            }
        }
        while (metamodelElementIterator.hasNext()) {
            EObject eObject = (EObject)metamodelElementIterator.next();
            if (!(eObject instanceof EClass)) continue;
            EClass eModelElement = (EClass)eObject;
            oclDiagnosticChain.addAll(ValidateAction.evaluateInstancesOfEClass(model, eModelElement));
        }
        return oclDiagnosticChain;
    }

    private static OclDiagnosticChain evaluateInstancesOfEClass(Resource model, EClass eClass) throws ParserException {
        String oclConstraint;
        OclDiagnosticChain diagnosticChain = new OclDiagnosticChain();
        TreeMap<String, String> constraints = new TreeMap<String, String>();
        EAnnotation eAnnotation = eClass.getEAnnotation(annotationURI);
        if (eAnnotation != null) {
            for (String oclKey : eAnnotation.getDetails().keySet()) {
                oclConstraint = EcoreUtil.getAnnotation((EModelElement)eClass, (String)annotationURI, (String)oclKey);
                if (oclConstraint == null) {
                    throw new ParserException("Unable to find an OCL expression with the key \"" + oclKey + "\" in the class \"" + eClass.getName() + "\"");
                }
                constraints.put(oclKey, oclConstraint);
            }
        }
        for (EClass eSuperType : eClass.getEAllSuperTypes()) {
            eAnnotation = eSuperType.getEAnnotation(annotationURI);
            if (eAnnotation == null) continue;
            for (String oclKey : eAnnotation.getDetails().keySet()) {
                String oclConstraint2 = EcoreUtil.getAnnotation((EModelElement)eSuperType, (String)annotationURI, (String)oclKey);
                if (oclConstraint2 == null) {
                    throw new ParserException("Unable to find an OCL expression with the key \"" + oclKey + "\" in the class \"" + eSuperType.getName() + "\"");
                }
                constraints.put(oclKey, oclConstraint2);
            }
        }
        if (!constraints.isEmpty()) {
            for (String oclKey : constraints.keySet()) {
                oclConstraint = (String)constraints.get(oclKey);
                TreeIterator modelContentsIterator = model.getAllContents();
                while (modelContentsIterator.hasNext()) {
                    EObject modelElement = (EObject)modelContentsIterator.next();
                    if (!eClass.isSuperTypeOf(modelElement.eClass())) continue;
                    diagnosticChain.add(new OclDiagnostic(modelElement, oclKey, oclConstraint, ValidateAction.evaluateOclBooleanExpression(modelElement, oclConstraint)));
                }
            }
        }
        return diagnosticChain;
    }

    static boolean evaluateOclBooleanExpression(Object context, String expression) throws ParserException {
        boolean result = true;
        if (context == null) {
            result = false;
        } else {
            OCL oclEnvironment = OCL.newInstance();
            OCL.Helper helper = oclEnvironment.createOCLHelper();
            helper.setInstanceContext(context);
            Constraint constraint = (Constraint)helper.createInvariant(expression);
            OCL.Query query = oclEnvironment.createQuery(constraint);
            result = query.check(context);
        }
        return result;
    }
}

