/*
 * Decompiled with CFR 0.152.
 */
package features.diagram.edit.commands;

import features.ConstrainableElement;
import features.ConstraintsSet;
import features.diagram.edit.policies.FeaturesBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;

public class ConstrainableElementConstraintsSetReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConstrainableElementConstraintsSetReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof ConstrainableElement)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ConstraintsSet) || !(this.newEnd instanceof ConstrainableElement)) {
            return false;
        }
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistConstrainableElementConstraintsSet_3007(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ConstraintsSet) || !(this.newEnd instanceof ConstraintsSet)) {
            return false;
        }
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistConstrainableElementConstraintsSet_3007(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().setConstraintsSet(null);
        this.getNewSource().setConstraintsSet(this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().setConstraintsSet(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected ConstrainableElement getOldSource() {
        return (ConstrainableElement)this.referenceOwner;
    }

    protected ConstrainableElement getNewSource() {
        return (ConstrainableElement)this.newEnd;
    }

    protected ConstraintsSet getOldTarget() {
        return (ConstraintsSet)this.oldEnd;
    }

    protected ConstraintsSet getNewTarget() {
        return (ConstraintsSet)this.newEnd;
    }
}

