/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.multiple.famabridge.popup.actions;

import features.Biconditional;
import features.Excludes;
import features.Feature;
import features.FeatureModel;
import features.Group;
import features.Implies;
import features.Relationship;
import features.StructuralRelationship;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToFamaFeatureModelAction
implements IObjectActionDelegate {
    private Shell shell;
    private IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)this.file.getLocation().toString()));
        final IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile(this.file.getFullPath().removeFileExtension().addFileExtension("fm"));
        try {
            resource.load(Collections.EMPTY_MAP);
            final FeatureModel featureModel = (FeatureModel)resource.getContents().get(0);
            Job convertJob = new Job("Convert to FAMA"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Convert to FAMA...", -1);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("%Relationships\n");
                    for (Feature f : featureModel.getFeatures()) {
                        if ((f.getChilds() == null || f.getChilds().isEmpty()) && f.getGroup() == null) continue;
                        buffer.append(f.getName());
                        buffer.append(": ");
                        for (StructuralRelationship sr : f.getChilds()) {
                            Feature cf = sr.getTo();
                            if (sr.getLowerBound() == 0) {
                                buffer.append("[" + cf.getName() + "] ");
                                continue;
                            }
                            buffer.append(String.valueOf(cf.getName()) + " ");
                        }
                        Group g = f.getGroup();
                        if (g != null) {
                            buffer.append("[" + g.getLowerBound() + "," + g.getUpperBound() + "] { ");
                            for (StructuralRelationship sr : g.getChilds()) {
                                Feature cf = sr.getTo();
                                buffer.append(String.valueOf(cf.getName()) + " ");
                            }
                            buffer.append("}");
                        }
                        buffer.append(";\n");
                    }
                    buffer.append("\n%Constraints\n");
                    for (Relationship r : featureModel.getRelationships()) {
                        Implies rr;
                        if (r instanceof Implies) {
                            rr = (Implies)r;
                            buffer.append(String.valueOf(rr.getFrom().getName()) + " REQUIRES " + rr.getTo().getName() + ";\n");
                            continue;
                        }
                        if (r instanceof Biconditional) {
                            rr = (Biconditional)r;
                            buffer.append(String.valueOf(rr.getFrom().getName()) + " REQUIRES " + rr.getTo().getName() + ";\n");
                            buffer.append(String.valueOf(rr.getTo().getName()) + " REQUIRES " + rr.getFrom().getName() + ";\n");
                            continue;
                        }
                        if (!(r instanceof Excludes)) continue;
                        rr = (Excludes)r;
                        buffer.append(String.valueOf(rr.getFrom().getName()) + " EXCLUDES " + rr.getTo().getName() + ";\n");
                    }
                    BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(buffer.toString().getBytes()));
                    try {
                        if (result.exists()) {
                            result.setContents((InputStream)stream, 0, monitor);
                        } else {
                            result.create((InputStream)stream, 0, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            convertJob.schedule();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }
}

