/*
 * Decompiled with CFR 0.152.
 */
package features.diagram.edit.commands;

import features.Feature;
import features.FeatureModel;
import features.FeaturesFactory;
import features.FeaturesPackage;
import features.RelatableElement;
import features.StructuralRelationship;
import features.diagram.edit.policies.FeaturesBaseItemSemanticEditPolicy;
import features.diagram.providers.FeaturesElementTypes;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;

public class StructuralRelationship2CreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private FeatureModel container;

    public StructuralRelationship2CreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(FeaturesPackage.eINSTANCE.getFeatureModel_Relationships());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof FeatureModel) {
                this.container = (FeatureModel)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof RelatableElement)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Feature)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canCreateStructuralRelationship_3002(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreation() {
        StructuralRelationship newElement = FeaturesFactory.eINSTANCE.createStructuralRelationship();
        this.getContainer().getRelationships().add((Object)newElement);
        newElement.setFrom(this.getSource());
        newElement.setTo(this.getTarget());
        FeaturesElementTypes.init_StructuralRelationship_3002(newElement);
        return newElement;
    }

    protected EClass getEClassToEdit() {
        return FeaturesPackage.eINSTANCE.getFeatureModel();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected RelatableElement getSource() {
        return (RelatableElement)this.source;
    }

    protected Feature getTarget() {
        return (Feature)this.target;
    }

    public FeatureModel getContainer() {
        return this.container;
    }
}

