/*
 * Decompiled with CFR 0.152.
 */
package features_diagram.diagram.edit.parts.helpers;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CircleDecoration
extends Ellipse
implements RotatableDecoration {
    private int myRadius = 5;
    private Point myCenter = new Point();
    private double myAngle = 0.0;

    public void setRadius(int radius) {
        this.myRadius = Math.abs(radius);
        this.repaint();
    }

    public void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            int diameter = this.myRadius * 2;
            Point center = this.myCenter;
            center.x -= (int)((double)this.myRadius * Math.sin(this.myAngle));
            center.y -= (int)((double)this.myRadius * Math.cos(this.myAngle));
            this.bounds = new Rectangle(center.x - this.myRadius, center.y - this.myRadius, diameter, diameter);
            this.bounds.expand(this.lineWidth / 2, this.lineWidth / 2);
        }
        return this.bounds;
    }

    public void setLocation(Point p) {
        if (this.myCenter.equals((Object)p)) {
            return;
        }
        this.myCenter.setLocation(p);
        this.bounds = null;
    }

    public void setReferencePoint(Point p) {
        this.myAngle = Math.atan2(this.myCenter.x - p.x, this.myCenter.y - p.y);
    }
}

