/*
 * Decompiled with CFR 0.152.
 */
package features.diagram.edit.commands;

import features.Biconditional;
import features.Feature;
import features.FeatureModel;
import features.diagram.edit.policies.FeaturesBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class BiconditionalReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public BiconditionalReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Biconditional)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Feature) || !(this.newEnd instanceof Feature)) {
            return false;
        }
        Feature target = this.getLink().getTo();
        if (!(this.getLink().eContainer() instanceof FeatureModel)) {
            return false;
        }
        FeatureModel container = (FeatureModel)this.getLink().eContainer();
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistBiconditional_3004(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Feature) || !(this.newEnd instanceof Feature)) {
            return false;
        }
        Feature source = this.getLink().getFrom();
        if (!(this.getLink().eContainer() instanceof FeatureModel)) {
            return false;
        }
        FeatureModel container = (FeatureModel)this.getLink().eContainer();
        return FeaturesBaseItemSemanticEditPolicy.LinkConstraints.canExistBiconditional_3004(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setFrom(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTo(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Biconditional getLink() {
        return (Biconditional)this.getElementToEdit();
    }

    protected Feature getOldSource() {
        return (Feature)this.oldEnd;
    }

    protected Feature getNewSource() {
        return (Feature)this.newEnd;
    }

    protected Feature getOldTarget() {
        return (Feature)this.oldEnd;
    }

    protected Feature getNewTarget() {
        return (Feature)this.newEnd;
    }
}

