/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.moment.intergenomics.transpath.parser;

import es.upv.dsic.issi.moment.intergenomics.bridges.IntergenomicsBridgesPlugin;
import es.upv.dsic.issi.moment.intergenomics.transpath.parser.InitialiseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.CoreException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import transpath.Chain;
import transpath.EnzymesCoefficient;
import transpath.Molecule;
import transpath.MoleculeType;
import transpath.Network;
import transpath.Pathway;
import transpath.Reaction;
import transpath.ReactionEffects;
import transpath.ReactionType;
import transpath.TranspathFactory;

public class TranspathParser {
    static Logger logger = Logger.getLogger((String)"transpath.Pathway");
    ArrayList<Chain> chains = new ArrayList();
    ArrayList<Molecule> molecules = new ArrayList();
    ArrayList<Reaction> reactions = new ArrayList();

    public Network createNetwork(InputStream stream) throws InitialiseException, CoreException {
        logger.setLevel(Level.DEBUG);
        Pathway pathway = TranspathFactory.eINSTANCE.createPathway();
        Network network = TranspathFactory.eINSTANCE.createNetwork();
        this.molecules.clear();
        this.reactions.clear();
        this.chains.clear();
        network.getPathway().add((Object)pathway);
        try {
            SimpleLayout layout = new SimpleLayout();
            FileAppender fileAppender = new FileAppender((Layout)layout, IntergenomicsBridgesPlugin.getDefault().getStateLocation().append("transpath_parser.log").toOSString(), false);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        try {
            String currentId;
            Chain currentChain;
            Element e;
            SAXBuilder builder = new SAXBuilder();
            Document doc = null;
            doc = builder.build(stream);
            Element root = doc.getRootElement();
            boolean onlyOnePathway = true;
            List chainList = root.getChildren("Pathway");
            List reactionList = root.getChildren("Reaction");
            List moleculeList = root.getChildren("Molecule");
            for (Object clo : chainList) {
                e = (Element)clo;
                if (e.getChildText("type").equals("pathway")) {
                    if (onlyOnePathway) {
                        if (e.getChildText("description") != null) {
                            pathway.setDescription(e.getChildText("description"));
                        }
                        pathway.setName(e.getChildText("name"));
                        pathway.setId(e.getAttributeValue("id"));
                        if (e.getChildText("synonyms") != null) {
                            pathway.getSynonyms().add((Object)e.getChildText("synonyms"));
                        }
                        logger.info((Object)("Creating pathway object with name " + pathway.getName() + " and id " + pathway.getId()));
                        onlyOnePathway = false;
                        continue;
                    }
                    logger.warn((Object)"In the xml-file are more than one pathway. Only the first one is considered.");
                    continue;
                }
                if (e.getChildText("type").equals("chain")) continue;
                logger.warn((Object)("Found a pathway object (ID: " + e.getAttributeValue("id") + " with type unlike pathway or chain. Object will be ignored."));
            }
            if (pathway.getId().equals("") || chainList.isEmpty() || reactionList.isEmpty() || moleculeList.isEmpty()) {
                logger.error((Object)"The informations in the xml-file are not complete.");
                throw new InitialiseException("The informations in the xml-file are not complete.");
            }
            block6: for (Object clo : chainList) {
                e = (Element)clo;
                if (!e.getChildText("type").equals("chain")) continue;
                currentChain = TranspathFactory.eINSTANCE.createChain();
                if (e.getChildText("description") != null) {
                    currentChain.setDescription(e.getChildText("description"));
                }
                currentChain.setName(e.getChildText("name"));
                currentChain.setId(e.getAttributeValue("id"));
                if (e.getChildText("synonyms") != null) {
                    currentChain.getSynonyms().add((Object)e.getChildText("synonyms"));
                }
                if (e.getChildText("pathways") == null) continue;
                if (e.getChild("pathways").getChildren("PathwayReference").isEmpty()) {
                    currentChain.setPathway(pathway);
                    pathway.getChains().add((Object)currentChain);
                    continue;
                }
                for (Object o : e.getChild("pathways").getChildren("PathwayReference")) {
                    if (!((Element)o).getAttributeValue("id").equals(pathway.getId())) continue;
                    currentChain.setPathway(pathway);
                    pathway.getChains().add((Object)currentChain);
                    continue block6;
                }
            }
            for (Object rlo : reactionList) {
                e = (Element)rlo;
                Reaction currentReaction = TranspathFactory.eINSTANCE.createReaction();
                if (e.getChildText("direct") != null && e.getChildText("direct").equals("direct")) {
                    currentReaction.setDirect(true);
                } else if (e.getChildText("direct").equals("indirect")) {
                    currentReaction.setDirect(false);
                } else {
                    currentReaction.setDirect(true);
                    logger.warn((Object)("Found a pathway object (ID: " + e.getAttributeValue("id") + " with direct unlike direct or indirect. Value was set to true."));
                }
                currentReaction.setId(e.getAttributeValue("id"));
                currentReaction.setName(e.getChildText("name"));
                if (e.getChildText("effect") != null) {
                    currentReaction.getEffects().add((Object)ReactionEffects.get((String)e.getChildText("effect")));
                }
                if (e.getChildText("reversible") != null && e.getChildText("reversible").equals("true")) {
                    currentReaction.setReversible(true);
                } else if (e.getChildText("reversible") != null && e.getChildText("reversible").equals("false")) {
                    currentReaction.setReversible(false);
                } else {
                    currentReaction.setReversible(false);
                    logger.warn((Object)("Found a pathway object (ID: " + e.getAttributeValue("id") + " with reversible unlike true or false. Value was set to false."));
                }
                if (e.getChildText("type") != null) {
                    currentReaction.getReactionType().add((Object)ReactionType.get((String)e.getChildText("type")));
                }
                this.reactions.add(currentReaction);
                network.getReactions().add((Object)currentReaction);
            }
            for (Object mlo : moleculeList) {
                e = (Element)mlo;
                Molecule currentMolecule = TranspathFactory.eINSTANCE.createMolecule();
                currentMolecule.setId(e.getAttributeValue("id"));
                currentMolecule.setName(e.getChildText("name"));
                if (e.getChildText("type") != null) {
                    currentMolecule.getMoleculeType().add((Object)MoleculeType.get((String)e.getChildText("type")));
                }
                if (e.getChildText("klass") != null) {
                    currentMolecule.getKlass().addAll((Collection)Arrays.asList(e.getChildText("klass").split("\\s*[;|]+\\s*")));
                }
                if (e.getChildText("synonyms") != null) {
                    currentMolecule.getSynonyms().add((Object)e.getChildText("synonyms"));
                }
                this.molecules.add(currentMolecule);
                network.getMolecules().add((Object)currentMolecule);
            }
            for (Object clo : chainList) {
                e = (Element)clo;
                if (e.getChildText("type") == null || !e.getChildText("type").equals("chain")) continue;
                currentChain = null;
                Reaction currentReaction = null;
                currentId = "";
                for (Chain c : this.chains) {
                    if (!c.getId().equals(e.getAttributeValue("id"))) continue;
                    currentChain = c;
                    break;
                }
                if (e.getChild("reaction_involved") == null) continue;
                for (Object o : e.getChild("reactions_involved").getChildren("ReactionReference")) {
                    currentReaction = null;
                    currentId = ((Element)o).getAttributeValue("id");
                    for (Reaction r : this.reactions) {
                        if (!r.getId().equals(currentId)) continue;
                        currentReaction = r;
                        break;
                    }
                    if (currentReaction != null) {
                        currentChain.getReactionsInvolved().add(currentReaction);
                        currentReaction.getChains().add((Object)currentChain);
                        continue;
                    }
                    logger.error((Object)("The chain " + currentId + "could not be found in the xml-file."));
                }
            }
            this.setReactionMoleculeAssocs(reactionList, "enzymes");
            this.setReactionMoleculeAssocs(reactionList, "produces");
            this.setReactionMoleculeAssocs(reactionList, "reactants");
            this.setReactionMoleculeAssocs(reactionList, "inhibitors");
            for (Object oml : moleculeList) {
                e = (Element)oml;
                Molecule m1 = null;
                Molecule m2 = null;
                currentId = "";
                for (Molecule m : this.molecules) {
                    if (!m.getId().equals(e.getAttributeValue("id").trim())) continue;
                    m1 = m;
                    break;
                }
                if (e.getChild("stateofs") == null) continue;
                for (Object o : e.getChild("stateofs").getChildren("MoleculeReference")) {
                    m2 = null;
                    currentId = ((Element)o).getAttributeValue("id").trim();
                    for (Molecule m : this.molecules) {
                        if (!m.getId().equals(currentId)) continue;
                        m2 = m;
                        break;
                    }
                    if (m2 != null) {
                        m1.getStatesOf().add(m2);
                        continue;
                    }
                    logger.warn((Object)("The molecule " + currentId + " that is a stateof " + m1.getId() + " could not be found in the xml-file."));
                }
            }
        }
        catch (JDOMException jDOMException) {
            logger.error((Object)"Could not create jdom from xml file.");
            throw new InitialiseException("Could not create jdom from xml file.");
        }
        catch (IOException iOException) {
            logger.error((Object)"Could not read file");
            throw new InitialiseException("Could not read file");
        }
        return network;
    }

    private void setReactionMoleculeAssocs(List reactionList, String molAssoc) {
        for (Object rlo : reactionList) {
            Element e = (Element)rlo;
            Reaction currentReaction = null;
            Molecule currentMolecule = null;
            String currentId = "";
            int coef = 0;
            logger.debug((Object)("Setting molecule associations " + molAssoc + " for reaction " + e.getAttributeValue("id")));
            for (Reaction r : this.reactions) {
                if (!r.getId().equals(e.getAttributeValue("id").trim())) continue;
                currentReaction = r;
                break;
            }
            if (e.getChild(molAssoc) == null || e.getChild(molAssoc).getChildren("MoleculeReference").isEmpty()) continue;
            for (Object o : e.getChild(molAssoc).getChildren("MoleculeReference")) {
                currentMolecule = null;
                currentId = ((Element)o).getAttributeValue("id").trim();
                logger.debug((Object)("currentId:" + currentId));
                for (Molecule m : this.molecules) {
                    logger.debug((Object)m.getId());
                    if (!m.getId().equals(currentId)) continue;
                    currentMolecule = m;
                    break;
                }
                if (currentMolecule != null) {
                    EnzymesCoefficient coeff;
                    coef = this.findCoefficient(currentReaction.getName(), currentMolecule.getName());
                    if (coef == -1) {
                        logger.error((Object)("Couldn't find the coefficient for the molecule " + currentMolecule.getName() + " in the reation " + currentReaction.getName() + "\n using -1 as coefficient."));
                    }
                    if (molAssoc.equals("enzymes")) {
                        coeff = TranspathFactory.eINSTANCE.createEnzymesCoefficient();
                        coeff.setCoefficient(coef);
                        coeff.setCatalyzes(currentReaction);
                        coeff.setEnzymes(currentMolecule);
                        currentReaction.getEnzymesCoefficient().add((Object)coeff);
                        continue;
                    }
                    if (molAssoc.equals("produces")) {
                        coeff = TranspathFactory.eINSTANCE.createProductsCoefficient();
                        coeff.setCoefficient(coef);
                        coeff.setRkins(currentReaction);
                        coeff.setProduces(currentMolecule);
                        currentReaction.getProducesCoefficient().add((Object)coeff);
                        continue;
                    }
                    if (molAssoc.equals("reactants")) {
                        coeff = TranspathFactory.eINSTANCE.createReactantsCoefficient();
                        coeff.setCoefficient(coef);
                        coeff.setRkouts(currentReaction);
                        coeff.setReactants(currentMolecule);
                        currentReaction.getReactantsCoefficient().add((Object)coeff);
                        continue;
                    }
                    if (!molAssoc.equals("inhibitors")) continue;
                    coeff = TranspathFactory.eINSTANCE.createInhibitorsCoefficient();
                    coeff.setCoefficient(coef);
                    coeff.setInhibits(currentReaction);
                    coeff.setInhibitors(currentMolecule);
                    currentReaction.getInhibitorsCoefficient().add((Object)coeff);
                    continue;
                }
                logger.error((Object)("The molecule " + currentId + " in the reaction " + currentReaction.getId() + " indicated as " + molAssoc + " is missing in the xml-file."));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int findCoefficient(String reaction, String molecule) {
        TranspathParser.logger.debug((Object)("Suche nach " + molecule));
        coef = 0;
        pos = reaction.indexOf(molecule);
        rightSiteOk = false;
        leftSiteOk = false;
        numberLength = 0;
        while (!leftSiteOk || !rightSiteOk) {
            block13: {
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                rightSiteOk = false;
                                leftSiteOk = false;
                                numberLength = 0;
                                if (pos == -1) {
                                    coef = -1;
                                    TranspathParser.logger.error((Object)("No coefficient found, because the molecule " + molecule + " has not been found in the reaction name " + reaction));
                                    return coef;
                                }
                                if (pos + molecule.length() + 1 < reaction.length() && (reaction.charAt(pos + molecule.length()) == '-' && reaction.charAt(pos + molecule.length() + 1) == '>' || reaction.charAt(pos + molecule.length()) == ',' && reaction.charAt(pos + molecule.length() + 1) == ' ')) {
                                    rightSiteOk = true;
                                    TranspathParser.logger.debug((Object)"rightSiteOk1");
                                }
                                if (pos + molecule.length() < reaction.length()) {
                                    if (reaction.charAt(pos + molecule.length()) == ' ' || reaction.charAt(pos + molecule.length()) == ')' && reaction.charAt(pos + molecule.length() + 1) == ' ') {
                                        rightSiteOk = true;
                                        TranspathParser.logger.debug((Object)"rightSiteOk2");
                                    }
                                } else {
                                    rightSiteOk = true;
                                    TranspathParser.logger.debug((Object)"rightSiteOk3");
                                }
                                if (pos != 0) break block12;
                                TranspathParser.logger.debug((Object)"leftSiteOk1");
                                leftSiteOk = true;
                                coef = 1;
                                break block13;
                            }
                            if (pos != 1 || reaction.charAt(0) != '(') break block14;
                            TranspathParser.logger.debug((Object)"leftSiteOk2");
                            leftSiteOk = true;
                            coef = 1;
                            break block13;
                        }
                        if (reaction.charAt(pos - 1) != ' ') break block15;
                        TranspathParser.logger.debug((Object)"leftSiteOk2b");
                        leftSiteOk = true;
                        coef = 1;
                        break block13;
                    }
                    if (pos <= 1 || reaction.charAt(pos - 1) != '(' || reaction.charAt(pos - 2) != ' ') break block16;
                    TranspathParser.logger.debug((Object)"leftSiteOk2c");
                    leftSiteOk = true;
                    coef = 1;
                    break block13;
                }
                if (pos <= 1 || reaction.charAt(pos - 1) != '-' || reaction.charAt(pos - 2) != ' ') ** GOTO lbl62
                coef = 1;
                TranspathParser.logger.debug((Object)"leftSiteOk5");
                leftSiteOk = true;
                break block13;
lbl-1000:
                // 1 sources

                {
                    TranspathParser.logger.debug((Object)("'" + reaction.charAt(pos - numberLength - 1) + "'"));
                    if (pos - numberLength - 1 == 0 || reaction.charAt(pos - numberLength - 2) == ' ' || pos - numberLength > 2 && reaction.charAt(pos - numberLength - 2) == '-' && reaction.charAt(pos - numberLength - 3) == ' ') {
                        TranspathParser.logger.debug((Object)"leftSiteOk3");
                        leftSiteOk = true;
                        coef = Integer.parseInt(reaction.substring(pos - numberLength - 1, pos));
                        TranspathParser.logger.debug((Object)("coef=" + coef));
                        break;
                    }
                    ++numberLength;
lbl62:
                    // 2 sources

                    ** while (reaction.substring((int)(pos - numberLength - 1), (int)(pos - numberLength)).matches((String)"\\d"))
                }
lbl63:
                // 2 sources

                if (pos > 1 && reaction.charAt(pos - 1) == '(') {
                    while (reaction.substring(pos - numberLength - 2, pos - numberLength - 1).matches("\\d")) {
                        if (pos - numberLength - 2 == 0 || reaction.charAt(pos - numberLength - 3) == ' ' || pos - numberLength > 3 && reaction.charAt(pos - numberLength - 3) == '-' && reaction.charAt(pos - numberLength - 4) == ' ') {
                            TranspathParser.logger.debug((Object)"leftSiteOk4");
                            leftSiteOk = true;
                            coef = Integer.parseInt(reaction.substring(pos - numberLength - 2, pos - 1));
                            break;
                        }
                        ++numberLength;
                    }
                }
            }
            pos = reaction.indexOf(molecule, pos + 1);
        }
        if (rightSiteOk && leftSiteOk) {
            return coef;
        }
        return -1;
    }
}

