/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.internal.beans.ListenerSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaBeanObservableValue
extends AbstractObservableValue
implements IBeanObservable {
    private final Object object;
    private boolean updating = false;
    private final PropertyDescriptor propertyDescriptor;
    private final Class overrideType;
    private ListenerSupport listenerSupport;
    static /* synthetic */ Class class$0;

    public JavaBeanObservableValue(Realm realm, Object object, PropertyDescriptor descriptor, Class overrideType) {
        super(realm);
        this.object = object;
        this.propertyDescriptor = descriptor;
        this.overrideType = overrideType;
    }

    protected void firstListenerAdded() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!JavaBeanObservableValue.this.updating) {
                    ValueDiff diff = Diffs.createValueDiff((Object)event.getOldValue(), (Object)event.getNewValue());
                    JavaBeanObservableValue.this.getRealm().exec(new Runnable(this, diff){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ValueDiff val$diff;
                        {
                            this.this$1 = var1_1;
                            this.val$diff = valueDiff;
                        }

                        public void run() {
                            JavaBeanObservableValue.access$1(1.access$0(this.this$1), this.val$diff);
                        }
                    });
                }
            }

            static /* synthetic */ JavaBeanObservableValue access$0(1 var0) {
                return var0.JavaBeanObservableValue.this;
            }
        };
        if (this.listenerSupport == null) {
            this.listenerSupport = new ListenerSupport(listener, this.propertyDescriptor.getName());
        }
        this.listenerSupport.hookListener(this.object);
    }

    public void doSetValue(Object value) {
        this.updating = true;
        try {
            try {
                Object oldValue = this.doGetValue();
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                if (!writeMethod.isAccessible()) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(this.object, value);
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.doGetValue()));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", 0, "Could not change value of " + this.object + "." + this.propertyDescriptor.getName(), (Throwable)e));
                this.updating = false;
            }
        }
        finally {
            this.updating = false;
        }
    }

    public Object doGetValue() {
        try {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new BindingException(String.valueOf(this.propertyDescriptor.getName()) + " property does not have a read method.");
            }
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, null);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", 0, "Could not read value of " + this.object + "." + this.propertyDescriptor.getName(), (Throwable)e));
            return null;
        }
    }

    protected void lastListenerRemoved() {
        this.unhookListener();
    }

    private void unhookListener() {
        if (this.listenerSupport != null) {
            this.listenerSupport.dispose();
            this.listenerSupport = null;
        }
    }

    public Object getValueType() {
        Class type = this.propertyDescriptor.getPropertyType();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz && this.overrideType != null) {
            type = this.overrideType;
        }
        return type;
    }

    public Object getObserved() {
        return this.object;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public synchronized void dispose() {
        this.unhookListener();
        super.dispose();
    }

    static /* synthetic */ void access$1(JavaBeanObservableValue javaBeanObservableValue, ValueDiff valueDiff) {
        javaBeanObservableValue.fireValueChange(valueDiff);
    }
}

