/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

class HasChildrenUpdate
extends ViewerUpdateMonitor
implements IHasChildrenUpdate {
    private boolean fHasChildren = false;
    private List fBatchedRequests = null;

    public HasChildrenUpdate(ModelContentProvider contentProvider, TreePath elementPath, Object element, IElementContentProvider elementContentProvider, IPresentationContext context) {
        super(contentProvider, elementPath, element, elementContentProvider, context);
    }

    protected void performUpdate() {
        ModelContentProvider contentProvider = this.getContentProvider();
        TreePath elementPath = this.getElementPath();
        if (!this.fHasChildren) {
            contentProvider.clearFilters(elementPath);
        }
        if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
            System.out.println("setHasChildren(" + this.getElement() + " >> " + this.fHasChildren);
        }
        ((TreeViewer)contentProvider.getViewer()).setHasChildren((Object)elementPath, this.fHasChildren);
        if (elementPath.getSegmentCount() > 0) {
            contentProvider.doRestore(elementPath);
        }
    }

    public void setHasChilren(boolean hasChildren) {
        this.fHasChildren = hasChildren;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IHasChildrenUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }

    boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof HasChildrenUpdate) {
            if (this.getElementPath().equals((Object)request.getElementPath())) {
                return true;
            }
            if (this.getElementContentProvider().equals(request.getElementContentProvider())) {
                if (this.fBatchedRequests == null) {
                    this.fBatchedRequests = new ArrayList();
                    this.fBatchedRequests.add(this);
                }
                this.fBatchedRequests.add(request);
                return true;
            }
        }
        return false;
    }

    void startRequest() {
        if (this.fBatchedRequests == null) {
            this.getElementContentProvider().update(new IHasChildrenUpdate[]{this});
        } else {
            IHasChildrenUpdate[] updates = this.fBatchedRequests.toArray(new IHasChildrenUpdate[this.fBatchedRequests.size()]);
            int i = 1;
            while (i < updates.length) {
                this.getContentProvider().updateStarted((ViewerUpdateMonitor)((Object)updates[i]));
                ++i;
            }
            this.getElementContentProvider().update(updates);
        }
    }

    int getPriority() {
        return 1;
    }

    TreePath getSchedulingPath() {
        TreePath path = this.getElementPath();
        if (path.getSegmentCount() > 0) {
            return path.getParentPath();
        }
        return path;
    }
}

