/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FolderSourceContainerDialog
extends ElementTreeSelectionDialog {
    private static final String LAST_SUBDIR_SETTING = "EXT_FOLDER_SOURCE_LAST_SUBDIR_SETTING";
    private Button fSubfoldersButton;
    private boolean fSearchSubfolders = false;

    protected Control createDialogArea(Composite parent) {
        Composite parentc = (Composite)super.createDialogArea(parent);
        this.fSubfoldersButton = new Button(parentc, 32);
        this.fSubfoldersButton.setText(SourceLookupUIMessages.DirectorySourceContainerDialog_6);
        this.fSubfoldersButton.setSelection(this.fSearchSubfolders);
        return parentc;
    }

    public FolderSourceContainerDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(SourceLookupUIMessages.folderSelection_title);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IFolder)) {
                        return new Status(4, DebugUIPlugin.getUniqueIdentifier(), -1, SourceLookupUIMessages.sourceSearch_folderSelectionError, null);
                    }
                    ++i;
                }
                return new Status(0, DebugUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        this.setValidator(validator);
        this.setDoubleClickSelects(true);
        this.setAllowMultiple(true);
        this.setMessage(SourceLookupUIMessages.folderSelection_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.folder_source_container_dialog");
        this.setSearchSubfolders(DebugUIPlugin.getDefault().getDialogSettings().getBoolean(LAST_SUBDIR_SETTING));
    }

    public boolean isSearchSubfolders() {
        return this.fSearchSubfolders;
    }

    public void setSearchSubfolders(boolean subfolders) {
        this.fSearchSubfolders = subfolders;
    }

    protected void okPressed() {
        this.fSearchSubfolders = this.fSubfoldersButton.getSelection();
        DebugUIPlugin.getDefault().getDialogSettings().put(LAST_SUBDIR_SETTING, this.fSearchSubfolders);
        super.okPressed();
    }
}

