/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.syntax.parser;

import java.util.List;
import java_cup.runtime.Symbol;
import org.oslo.ocl20.semantics.analyser.OclSemanticAnalyserVisitorImpl;
import org.oslo.ocl20.syntax.parser.StructuredErrorDescription;
import uk.ac.kent.cs.kmf.util.ILog;

public class ErrorManager {
    public static List recordMessages;
    public static String source;

    static {
        source = null;
    }

    public static StringBuffer getMessage(String message, Object info) {
        StringBuffer buffer = new StringBuffer();
        if (info instanceof Symbol) {
            Symbol symb = (Symbol)info;
            if (OclSemanticAnalyserVisitorImpl.getBeginLine(symb) >= 1) {
                buffer.append(String.valueOf(OclSemanticAnalyserVisitorImpl.getBeginLine(symb)) + ":");
                buffer.append(OclSemanticAnalyserVisitorImpl.getBeginColumn(symb));
                buffer.append(" ");
            }
            buffer.append(message);
            if (symb.value instanceof String && symb.value != null && ((String)symb.value).length() != 0) {
                buffer.append(" near '" + symb.value + "'");
            }
        } else {
            buffer.append(message);
        }
        return buffer;
    }

    public static void reportInfo(ILog log, Object info, String message) {
        String s = new String(ErrorManager.getMessage(message, info));
        if (recordMessages != null) {
            recordMessages.add(new StructuredErrorDescription(false, false, message, (Symbol)info, source));
        }
        log.reportMessage(s);
    }

    public static void reportWarning(ILog log, Object info, String message) {
        String s = new String(ErrorManager.getMessage(message, info));
        if (recordMessages != null) {
            recordMessages.add(new StructuredErrorDescription(false, true, message, (Symbol)info, source));
        }
        log.reportWarning(s);
    }

    public static void reportError(ILog log, Object info, String message) {
        String s = new String(ErrorManager.getMessage(message, info));
        if (recordMessages != null) {
            recordMessages.add(new StructuredErrorDescription(true, false, message, (Symbol)info, source));
        }
        log.reportError(s);
    }

    public static void reportFatalError(ILog log, Object info, String message) {
        String s = new String(ErrorManager.getMessage(message, info));
        if (recordMessages != null) {
            recordMessages.add(new StructuredErrorDescription(true, false, message, (Symbol)info, source));
        }
        log.reportError(s);
    }
}

