/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.HashMap;
import java.util.Map;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.factories.TypeFactory;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OclMessageType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.TypeType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.types.BagTypeImpl;
import org.oslo.ocl20.standard.types.BooleanTypeImpl;
import org.oslo.ocl20.standard.types.CollectionTypeImpl;
import org.oslo.ocl20.standard.types.IntegerTypeImpl;
import org.oslo.ocl20.standard.types.OclAnyTypeImpl;
import org.oslo.ocl20.standard.types.OrderedSetTypeImpl;
import org.oslo.ocl20.standard.types.RealTypeImpl;
import org.oslo.ocl20.standard.types.SequenceTypeImpl;
import org.oslo.ocl20.standard.types.SetTypeImpl;
import org.oslo.ocl20.standard.types.StringTypeImpl;
import org.oslo.ocl20.standard.types.TupleTypeImpl;
import org.oslo.ocl20.standard.types.TypeTypeImpl;
import org.oslo.ocl20.standard.types.VoidTypeImpl;
import org.oslo.ocl20.synthesis.CreationHelper;

public class TypeFactoryImpl
implements TypeFactory {
    protected OclProcessor processor;
    Map _collectionTypes = new HashMap();
    Map _bagTypes = new HashMap();
    Map _orderedSetTypes = new HashMap();
    Map _sequenceTypes = new HashMap();
    Map _setTypes = new HashMap();
    public OclAnyType OCLANY_TYPE = null;
    public TypeType TYPE_TYPE = null;
    public OclMessageType OCLMESSAGE_TYPE = null;
    public VoidType VOID_TYPE = null;
    public BooleanType BOOLEAN_TYPE = null;
    public IntegerType INTEGER_TYPE = null;
    public RealType REAL_TYPE = null;
    public StringType STRING_TYPE = null;
    public Classifier[] NONE = null;
    public Classifier CLASSIFIER_TYPE = null;

    public TypeFactoryImpl(OclProcessor proc) {
        this.processor = proc;
        this.init();
    }

    public Classifier buildClassifier() {
        return this.CLASSIFIER_TYPE;
    }

    public BooleanType buildBooleanType() {
        return this.BOOLEAN_TYPE;
    }

    public RealType buildRealType() {
        return this.REAL_TYPE;
    }

    public IntegerType buildIntegerType() {
        return this.INTEGER_TYPE;
    }

    public StringType buildStringType() {
        return this.STRING_TYPE;
    }

    public VoidType buildVoidType() {
        return this.VOID_TYPE;
    }

    public OclAnyType buildOclAnyType() {
        return this.OCLANY_TYPE;
    }

    public TypeType buildTypeType(Classifier type) {
        return new TypeTypeImpl(this.processor, type);
    }

    public OclMessageType buildOclMessageType() {
        return null;
    }

    public TupleType buildTupleType(String[] names, Classifier[] types) {
        TupleTypeImpl tt = new TupleTypeImpl(this.processor);
        tt.createOperations(this);
        int i = 0;
        while (i < names.length) {
            VariableDeclaration vd = CreationHelper.createVariableDeclaration();
            vd.setName(names[i]);
            vd.setType(types[i]);
            tt.getPartType().add((Object)vd);
            ++i;
        }
        return tt;
    }

    public CollectionType buildCollectionType(Classifier elementType) {
        CollectionType collectionType = (CollectionType)this._collectionTypes.get(elementType);
        if (collectionType == null) {
            collectionType = new CollectionTypeImpl(elementType, this.processor);
            this._collectionTypes.put(elementType, collectionType);
            ((CollectionTypeImpl)collectionType).createOperations(this);
        }
        return collectionType;
    }

    public BagType buildBagType(Classifier elementType) {
        BagType bagType = (BagType)this._bagTypes.get(elementType);
        if (bagType == null) {
            bagType = new BagTypeImpl(elementType, this.processor);
            this._bagTypes.put(elementType, bagType);
            ((BagTypeImpl)bagType).createOperations(this);
        }
        return bagType;
    }

    public OrderedSetType buildOrderedSetType(Classifier elementType) {
        OrderedSetType orderedSetType = (OrderedSetType)this._orderedSetTypes.get(elementType);
        if (orderedSetType == null) {
            orderedSetType = new OrderedSetTypeImpl(elementType, this.processor);
            this._orderedSetTypes.put(elementType, orderedSetType);
            ((OrderedSetTypeImpl)orderedSetType).createOperations(this);
        }
        return orderedSetType;
    }

    public SequenceType buildSequenceType(Classifier elementType) {
        SequenceType sequenceType = (SequenceType)this._sequenceTypes.get(elementType);
        if (sequenceType == null) {
            sequenceType = new SequenceTypeImpl(elementType, this.processor);
            this._sequenceTypes.put(elementType, sequenceType);
            ((SequenceTypeImpl)sequenceType).createOperations(this);
        }
        return sequenceType;
    }

    public SetType buildSetType(Classifier elementType) {
        SetType setType = (SetType)this._setTypes.get(elementType);
        if (setType == null) {
            setType = new SetTypeImpl(elementType, this.processor);
            this._setTypes.put(elementType, setType);
            ((SetTypeImpl)setType).createOperations(this);
        }
        return setType;
    }

    protected void init() {
        this.OCLANY_TYPE = new OclAnyTypeImpl(this.processor);
        this.VOID_TYPE = new VoidTypeImpl(this.processor);
        this.BOOLEAN_TYPE = new BooleanTypeImpl(this.processor);
        this.INTEGER_TYPE = new IntegerTypeImpl(this.processor);
        this.REAL_TYPE = new RealTypeImpl(this.processor);
        this.STRING_TYPE = new StringTypeImpl(this.processor);
        this.CLASSIFIER_TYPE = CreationHelper.createClassifier(this.processor);
        this.CLASSIFIER_TYPE.createOperations(this);
        this.OCLANY_TYPE.createOperations(this);
        this.REAL_TYPE.createOperations(this);
        this.INTEGER_TYPE.createOperations(this);
        this.STRING_TYPE.createOperations(this);
        this.BOOLEAN_TYPE.createOperations(this);
        this.VOID_TYPE.createOperations(this);
    }

    protected Operation buildOperation(Classifier ret, String op_name, Classifier[] params) {
        return this.processor.getBridgeFactory().buildOperation(ret, op_name, params);
    }

    public Classifier getFlatType(Classifier type) {
        while (type instanceof CollectionType && !(type instanceof VoidType)) {
            type = ((CollectionType)type).getElementType();
        }
        return type;
    }
}

