/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.types;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.factories.TypeFactory;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.types.SetTypeImpl;
import org.oslo.ocl20.standard.types.TypeConformance;

public class OrderedSetTypeImpl
extends SetTypeImpl
implements OrderedSetType {
    public OrderedSetTypeImpl(Classifier elementType, OclProcessor proc) {
        super(elementType, proc);
        this.setName("OrderedSet");
    }

    public void createOperations(TypeFactory tf) {
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "=", new Classifier[]{this}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildBooleanType(), "<>", new Classifier[]{this}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "union", new Classifier[]{this}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildBagType(this.getElementType()), "union", new Classifier[]{tf.buildBagType(this.getElementType())}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "union", new Classifier[]{tf.buildSetType(this.getElementType())}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "intersection", new Classifier[]{this}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "intersection", new Classifier[]{tf.buildBagType(this.getElementType())}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "intersection", new Classifier[]{tf.buildSetType(this.getElementType())}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "append", new Classifier[]{this.getElementType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "prepend", new Classifier[]{this.getElementType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "insertAt", new Classifier[]{tf.buildIntegerType(), this.getElementType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "subOrderedSet", new Classifier[]{tf.buildIntegerType(), tf.buildIntegerType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this.getElementType(), "at", new Classifier[]{tf.buildIntegerType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildIntegerType(), "indexOf", new Classifier[]{this.getElementType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this.getElementType(), "first", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this.getElementType(), "last", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildIntegerType(), "count", new Classifier[]{this.getElementType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSetType(tf.getFlatType(this)), "flatten", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildBagType(this.getElementType()), "asBag", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSequenceType(this.getElementType()), "asSequence", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(tf.buildSetType(this.getElementType()), "asSet", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "asOrderedSet", new Classifier[0]));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "select", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "select", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "reject", new Classifier[]{tf.buildBooleanType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "reject", new Classifier[]{this.getElementType(), tf.buildBooleanType()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "sortedBy", new Classifier[]{tf.buildClassifier()}));
        this.getOperations().add((Object)this.processor.getBridgeFactory().buildOperation(this, "sortedBy", new Classifier[]{this.getElementType(), tf.buildClassifier()}));
        super.createOperations(tf);
    }

    public Operation lookupOperation(String name, List types) {
        Operation op = super.lookupOperation(name, types);
        if (name.equals("collect")) {
            Classifier bodyType = (Classifier)types.get(types.size() - 1);
            Classifier baseType = this.baseElementType(bodyType);
            SequenceType seqT = this.processor.getTypeFactory().buildSequenceType(baseType);
            return this.processor.getBridgeFactory().buildOperation(seqT, "collect", null);
        }
        if (name.equals("collectNested")) {
            SequenceType seqT = this.processor.getTypeFactory().buildSequenceType((Classifier)types.get(types.size() - 1));
            return this.processor.getBridgeFactory().buildOperation(seqT, "collectNested", null);
        }
        return op;
    }

    public Boolean conformsTo(Classifier t2) {
        if (t2 instanceof VoidType) {
            return Boolean.TRUE;
        }
        if (t2 instanceof OrderedSetType) {
            return this.getElementType().conformsTo(((OrderedSetType)t2).getElementType());
        }
        if (t2 instanceof CollectionType && !(t2 instanceof SetType) && !(t2 instanceof BagType) && !(t2 instanceof SequenceType)) {
            return this.getElementType().conformsTo(((CollectionType)t2).getElementType());
        }
        return TypeConformance.isAssignableTo(this, t2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return "OrderedSet(" + this.getElementType() + ")";
    }

    public Object getDelegate() {
        return EList.class;
    }

    public Class getImplClass() {
        return OclOrderedSet.class;
    }
}

