/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.regex.PatternSyntaxException;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclIntegerImpl;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclStringImpl
extends OclAnyImpl
implements OclString {
    String _implementation;

    public OclStringImpl(String s, StdLibAdapter adapter) {
        super(adapter);
        this._implementation = s;
    }

    public OclType oclType() {
        StringType type = this.adapter.getProcessor().getTypeFactory().buildStringType();
        return this.adapter.Type(type);
    }

    public String implementation() {
        return this._implementation;
    }

    public Object asJavaObject() {
        return this.implementation();
    }

    public OclBoolean equalTo(OclString string2) {
        return string2 instanceof OclStringImpl ? this.adapter.Boolean(this.implementation().equals(((OclStringImpl)string2).implementation())) : this.adapter.Boolean(false);
    }

    public OclInteger size() {
        return this.adapter.Integer(this.implementation().length());
    }

    public OclString concat(OclString string2) {
        if (string2 instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.String(String.valueOf(this.implementation()) + ((OclStringImpl)string2).implementation());
    }

    public OclString substring(OclInteger lower, OclInteger upper) {
        try {
            return this.adapter.String(this.implementation().substring(((OclIntegerImpl)lower).int_impl() - 1, ((OclIntegerImpl)upper).int_impl()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return this.adapter.Undefined();
        }
    }

    public OclInteger toInteger() {
        try {
            return this.adapter.Integer(Integer.parseInt(this.implementation()));
        }
        catch (NumberFormatException numberFormatException) {
            return this.adapter.Undefined();
        }
    }

    public OclReal toReal() {
        try {
            return this.adapter.Real(Double.parseDouble(this.implementation()));
        }
        catch (NumberFormatException numberFormatException) {
            return this.adapter.Undefined();
        }
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return "'" + this._implementation + "'";
    }

    public boolean equals(Object o) {
        return o instanceof OclString ? (OclBooleanImpl)this.equalTo((OclString)o) == OclBooleanImpl.TRUE : false;
    }

    public int hashCode() {
        return this.implementation().hashCode();
    }

    public Object clone() {
        return this.adapter.String(this._implementation);
    }

    public OclString toLower() {
        return this.adapter.String(this.implementation().toLowerCase());
    }

    public OclString toUpper() {
        return this.adapter.String(this.implementation().toUpperCase());
    }

    public OclString firstToUpper() {
        if (this.implementation().length() <= 0) {
            return this;
        }
        return this.adapter.String(String.valueOf(this.implementation().substring(0, 1).toUpperCase()) + this.implementation().substring(1));
    }

    public OclBoolean toBoolean() {
        if (this.implementation().equalsIgnoreCase("true") || this.implementation().equals("1")) {
            return this.adapter.Boolean(true);
        }
        if (this.implementation().equalsIgnoreCase("false") || this.implementation().equals("0")) {
            return this.adapter.Boolean(false);
        }
        return this.adapter.Undefined();
    }

    public OclString firstToLower() {
        if (this.implementation().length() <= 0) {
            return this;
        }
        return this.adapter.String(String.valueOf(this.implementation().substring(0, 1).toLowerCase()) + this.implementation().substring(1));
    }

    public OclInteger indexOf(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.implementation().indexOf(((OclStringImpl)match).implementation()));
    }

    public OclInteger indexOf(OclString match, OclInteger from) {
        if (match instanceof OclUndefined || from instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.implementation().indexOf(((OclStringImpl)match).implementation(), ((OclIntegerImpl)from).int_impl()));
    }

    public OclInteger lastIndexOf(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.implementation().lastIndexOf(((OclStringImpl)match).implementation()));
    }

    public OclInteger lastIndexOf(OclString match, OclInteger from) {
        if (match instanceof OclUndefined || from instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.implementation().lastIndexOf(((OclStringImpl)match).implementation(), ((OclIntegerImpl)from).int_impl()));
    }

    public OclBoolean endsWith(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Boolean(this.implementation().endsWith(((OclStringImpl)match).implementation()));
    }

    public OclBoolean startsWith(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        return this.adapter.Boolean(this.implementation().startsWith(((OclStringImpl)match).implementation()));
    }

    public OclString trim() {
        return this.adapter.String(this.implementation().trim());
    }

    public OclBoolean equalsIgnoreCase(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(this.implementation().equalsIgnoreCase(((OclStringImpl)match).implementation()));
    }

    public OclString substringBefore(OclString match) {
        String matchString;
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        String value = this.implementation();
        int index = value.indexOf(matchString = ((OclStringImpl)match).implementation());
        if (index < 0) {
            return this.adapter.Undefined();
        }
        return this.adapter.String(this.implementation().substring(0, index));
    }

    public OclString substringAfter(OclString match) {
        String matchString;
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        String value = this.implementation();
        int index = value.indexOf(matchString = ((OclStringImpl)match).implementation());
        if (index < 0) {
            return this.adapter.Undefined();
        }
        return this.adapter.String(this.implementation().substring(index + matchString.length(), this.implementation().length()));
    }

    public OclBoolean containsOnlyLetters() {
        char[] value = this.implementation().toCharArray();
        int i = 0;
        while (i < value.length) {
            char currentChar = value[i];
            if (!Character.isLetter(currentChar)) {
                return this.adapter.Boolean(false);
            }
            ++i;
        }
        return this.adapter.Boolean(true);
    }

    public OclBoolean containsOnlyDigits() {
        char[] value = this.implementation().toCharArray();
        int i = 0;
        while (i < value.length) {
            char currentChar = value[i];
            if (!Character.isDigit(currentChar)) {
                return this.adapter.Boolean(false);
            }
            ++i;
        }
        return this.adapter.Boolean(true);
    }

    public OclBoolean containsOnlyDigitsAndLetters() {
        char[] value = this.implementation().toCharArray();
        int i = 0;
        while (i < value.length) {
            char currentChar = value[i];
            if (!Character.isLetterOrDigit(currentChar)) {
                return this.adapter.Boolean(false);
            }
            ++i;
        }
        return this.adapter.Boolean(true);
    }

    public OclString replace(OclString match, OclString replacement) {
        if (match instanceof OclUndefined || replacement instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        try {
            return this.adapter.String(this.implementation().replaceAll(((OclStringImpl)match).implementation(), ((OclStringImpl)replacement).implementation()));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return this.adapter.Undefined();
        }
    }

    public OclString replaceFirst(OclString match, OclString replacement) {
        if (match instanceof OclUndefined || replacement instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        try {
            return this.adapter.String(this.implementation().replaceFirst(((OclStringImpl)match).implementation(), ((OclStringImpl)replacement).implementation()));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return this.adapter.Undefined();
        }
    }

    public OclSequence split(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Sequence(this.adapter.getProcessor().getTypeFactory().buildVoidType());
        }
        try {
            return this.adapter.Sequence((Classifier)this.adapter.getProcessor().getTypeFactory().buildStringType(), this.implementation().split(((OclStringImpl)match).implementation()));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return this.adapter.Sequence(this.adapter.getProcessor().getTypeFactory().buildVoidType());
        }
    }

    public OclSequence split(OclString match, OclInteger limit) {
        if (match instanceof OclUndefined || limit instanceof OclUndefined) {
            return this.adapter.Sequence(this.adapter.getProcessor().getTypeFactory().buildVoidType());
        }
        try {
            return this.adapter.Sequence((Classifier)this.adapter.getProcessor().getTypeFactory().buildStringType(), this.implementation().split(((OclStringImpl)match).implementation(), ((OclIntegerImpl)limit).int_impl()));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return this.adapter.Sequence(this.adapter.getProcessor().getTypeFactory().buildVoidType());
        }
    }

    public OclBoolean matches(OclString match) {
        if (match instanceof OclUndefined) {
            return this.adapter.Undefined();
        }
        try {
            return this.adapter.Boolean(this.implementation().matches(((OclStringImpl)match).implementation()));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return this.adapter.Undefined();
        }
    }

    public OclString add(OclString s2) {
        return this.concat(s2);
    }

    public OclBoolean lessThan(OclString s2) {
        return this.adapter.Boolean(this.implementation().compareTo(((OclStringImpl)s2).implementation()) < 0);
    }

    public OclBoolean greaterThan(OclString s2) {
        return this.adapter.Boolean(this.implementation().compareTo(((OclStringImpl)s2).implementation()) > 0);
    }
}

