/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBagImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclSetImpl
extends OclCollectionImpl
implements OclSet {
    Set _implementation;

    public OclSetImpl(Classifier eT, Set array, StdLibAdapter adapter) {
        super(eT, adapter);
        this._implementation = new LinkedHashSet(array);
    }

    public OclSetImpl(Classifier eT, Object[] array, StdLibAdapter adapter) {
        super(eT, adapter);
        this._implementation = new LinkedHashSet();
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && (OclBooleanImpl)this.includes(array[i]) != OclBooleanImpl.TRUE) {
                this._implementation.add(array[i]);
            }
            ++i;
        }
    }

    public OclType oclType() {
        SetType type = this.adapter.getProcessor().getTypeFactory().buildSetType(super.getElementType());
        return this.adapter.Type(type);
    }

    protected Collection implementation() {
        return this._implementation;
    }

    protected Set set_impl() {
        return this._implementation;
    }

    public OclBoolean equalTo(OclSet set2) {
        if (!this.size().equals(set2.size())) {
            return this.adapter.Boolean(false);
        }
        Collection b = this.implementation();
        for (OclAny ob : b) {
            if ((OclBooleanImpl)this.count(ob).equalTo(set2.count(ob)) == OclBooleanImpl.TRUE) continue;
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(true);
    }

    public OclBoolean notEqualTo(OclSet set2) {
        return this.equalTo(set2).not();
    }

    public OclSet union(OclSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    public OclBag union(OclBag bag) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.set_impl());
        b.implementation().addAll(((OclBagImpl)bag).implementation());
        return b;
    }

    public OclSet union(OclOrderedSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    public OclSet intersection(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if ((OclBooleanImpl)set2.includes(o) != OclBooleanImpl.TRUE) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if ((OclBooleanImpl)this.includes(o) != OclBooleanImpl.TRUE) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclSet intersection(OclBag bag) {
        return this.intersection(bag.asSet());
    }

    public OclSet intersection(OclOrderedSet set2) {
        return this.intersection(set2.asSet());
    }

    public OclSet subtract(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclSet including(OclAny object) {
        OclSetImpl s = (OclSetImpl)this.adapter.Set(this.getElementType(), this.set_impl());
        if (object instanceof OclUndefined) {
            return s;
        }
        if ((OclBooleanImpl)this.includes(object) != OclBooleanImpl.TRUE) {
            s.set_impl().add(object);
        }
        return s;
    }

    public OclSet excluding(OclAny object) {
        OclSetImpl s = (OclSetImpl)this.adapter.Set(this.getElementType(), this.set_impl());
        s.set_impl().remove(object);
        return s;
    }

    public OclSet symmetricDifference(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        Set s1 = (Set)this.getImplementation();
        Set s2 = (Set)set2.getImplementation();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (s1.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclInteger count(OclAny object) {
        return super.count(object);
    }

    public OclSet flatten() {
        OclSet flat = (OclSetImpl)this.adapter.Set(this.getElementType());
        for (OclAny elem : this._implementation) {
            flat = elem instanceof OclBag ? flat.union((OclBag)elem).asSet() : (elem instanceof OclSet ? flat.union((OclSet)elem).asSet() : (elem instanceof OclSequence ? flat.union(((OclSequence)elem).asSet()).asSet() : flat.including(elem)));
        }
        return flat;
    }

    public String toString() {
        String str = "Set { ";
        Iterator i = this._implementation.iterator();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    public Object clone() {
        return this.adapter.Set(this.getElementType(), this.set_impl());
    }

    public boolean equals(Object o) {
        return o instanceof OclSet ? (OclBooleanImpl)this.equalTo((OclSet)o) == OclBooleanImpl.TRUE : false;
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public Object asJavaObject() {
        LinkedHashSet jObj = new LinkedHashSet();
        for (Object o : this._implementation) {
            if (o instanceof OclAny) {
                o = ((OclAny)o).asJavaObject();
            }
            jObj.add(o);
        }
        return Collections.unmodifiableSet(jObj);
    }
}

