/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.standard.lib.OclAnyImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclRealImpl
extends OclAnyImpl
implements OclReal {
    double _implementation;

    public OclRealImpl(double r, StdLibAdapter adapter) {
        super(adapter);
        this._implementation = r;
    }

    public OclType oclType() {
        RealType type = this.adapter.getProcessor().getTypeFactory().buildRealType();
        return this.adapter.Type(type);
    }

    public double implementation() {
        return this._implementation;
    }

    public strictfp OclBoolean equalTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() == ((OclRealImpl)r2).implementation());
    }

    public strictfp OclBoolean notEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() != ((OclRealImpl)r2).implementation());
    }

    public Object asJavaObject() {
        return new Double(this.implementation());
    }

    public OclReal add(OclReal r2) {
        return this.adapter.Real(this.implementation() + ((OclRealImpl)r2).implementation());
    }

    public OclReal subtract(OclReal r2) {
        return this.adapter.Real(this.implementation() - ((OclRealImpl)r2).implementation());
    }

    public OclReal multiply(OclReal r2) {
        return this.adapter.Real(this.implementation() * ((OclRealImpl)r2).implementation());
    }

    public OclReal negate() {
        return this.adapter.Real(this.implementation() * -1.0);
    }

    public OclReal divide(OclReal r2) {
        if (((OclRealImpl)r2)._implementation == 0.0) {
            return this.adapter.Undefined();
        }
        return this.adapter.Real(this.implementation() / ((OclRealImpl)r2).implementation());
    }

    public OclReal abs() {
        return this.adapter.Real(Math.abs(this.implementation()));
    }

    public OclInteger floor() {
        return this.adapter.Integer((int)Math.floor(this.implementation()));
    }

    public OclInteger round() {
        return this.adapter.Integer((int)Math.round(this.implementation()));
    }

    public OclReal max(OclReal r2) {
        return this.adapter.Real(Math.max(this.implementation(), ((OclRealImpl)r2).implementation()));
    }

    public OclReal min(OclReal r2) {
        return this.adapter.Real(Math.min(this.implementation(), ((OclRealImpl)r2).implementation()));
    }

    public OclBoolean lessThan(OclReal r2) {
        return this.adapter.Boolean(this.implementation() < ((OclRealImpl)r2).implementation());
    }

    public OclBoolean greaterThan(OclReal r2) {
        return this.adapter.Boolean(this.implementation() > ((OclRealImpl)r2).implementation());
    }

    public OclBoolean lessThanOrEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() <= ((OclRealImpl)r2).implementation());
    }

    public OclBoolean greaterThanOrEqualTo(OclReal r2) {
        return this.adapter.Boolean(this.implementation() >= ((OclRealImpl)r2).implementation());
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return String.valueOf(this.implementation());
    }

    public boolean equals(Object r) {
        if (r instanceof OclRealImpl) {
            return (OclBooleanImpl)this.equalTo((OclRealImpl)r) == OclBooleanImpl.TRUE;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.implementation();
    }

    public Object clone() {
        return new OclRealImpl(this.implementation(), this.adapter);
    }
}

