/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBagImpl;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclIntegerImpl;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclSetImpl;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclOrderedSetImpl
extends OclCollectionImpl
implements OclOrderedSet {
    List _implementation = new Vector();

    public OclOrderedSetImpl(Classifier eT, Object[] array, StdLibAdapter adapter) {
        super(eT, adapter);
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && (OclBooleanImpl)this.includes(array[i]) != OclBooleanImpl.TRUE) {
                this._implementation.add(array[i]);
            }
            ++i;
        }
    }

    public OclType oclType() {
        OrderedSetType type = this.adapter.getProcessor().getTypeFactory().buildOrderedSetType(super.getElementType());
        return this.adapter.Type(type);
    }

    protected Collection implementation() {
        return this._implementation;
    }

    protected List orderedset_impl() {
        return this._implementation;
    }

    public OclBoolean equalTo(OclOrderedSet set2) {
        if ((OclBooleanImpl)this.size().notEqualTo(set2.size()) == OclBooleanImpl.TRUE) {
            return this.adapter.Boolean(false);
        }
        Collection b = this.implementation();
        b.iterator();
        List t = this.orderedset_impl();
        List s = (List)set2.getImplementation();
        int i = 0;
        while (i < t.size()) {
            if (!t.get(i).equals(s.get(i))) {
                return this.adapter.Boolean(false);
            }
            ++i;
        }
        return this.adapter.Boolean(true);
    }

    public OclBoolean notEqualTo(OclOrderedSet set2) {
        return this.equalTo(set2).not();
    }

    public OclBoolean equalTo(OclSet set2) {
        return this.asSet().equalTo(set2);
    }

    public OclBoolean notEqualTo(OclSet set2) {
        if (set2 instanceof OclOrderedSet) {
            return this.notEqualTo((OclOrderedSet)set2);
        }
        return this.adapter.Boolean(true);
    }

    public OclSet union(OclOrderedSet set2) {
        OclOrderedSet s = this.union(set2.asBag()).asOrderedSet();
        return s;
    }

    public OclSet union(OclSet set2) {
        OclSet s = this.union(set2.asBag()).asSet();
        return s;
    }

    public OclBag union(OclBag bag) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.orderedset_impl());
        b.implementation().addAll(((OclBagImpl)bag).implementation());
        return b;
    }

    public OclSet intersection(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List s1 = (List)this.implementation();
        Collection s2 = set2 instanceof OclOrderedSetImpl ? ((OclOrderedSetImpl)set2).implementation() : ((OclSetImpl)set2).implementation();
        for (OclAny o : s1) {
            if ((OclBooleanImpl)set2.includes(o) != OclBooleanImpl.TRUE) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if ((OclBooleanImpl)this.includes(o) != OclBooleanImpl.TRUE) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclSet intersection(OclBag bag) {
        return this.intersection(bag.asSet());
    }

    public OclSet intersection(OclOrderedSet set2) {
        return this.intersection(set2.asSet()).asOrderedSet();
    }

    public OclSet subtract(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List set = (List)this.implementation();
        Collection s2 = null;
        s2 = set2 instanceof OclSetImpl ? ((OclSetImpl)set2).implementation() : ((OclOrderedSetImpl)set2).implementation();
        for (OclAny o : set) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclSet symmetricDifference(OclSet set2) {
        OclSet s = this.adapter.Set(this.getElementType());
        List s1 = (List)this.implementation();
        Collection s2 = null;
        s2 = set2 instanceof OclSetImpl ? ((OclSetImpl)set2).implementation() : ((OclOrderedSetImpl)set2).implementation();
        for (OclAny o : s1) {
            if (s2.contains(o)) continue;
            s = s.including(o);
        }
        for (OclAny o : s2) {
            if (s1.contains(o)) continue;
            s = s.including(o);
        }
        return s;
    }

    public OclOrderedSet append(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        if ((OclBooleanImpl)this.includes(object) != OclBooleanImpl.TRUE) {
            seq._implementation.add(object);
        }
        return seq;
    }

    public OclOrderedSet prepend(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        if ((OclBooleanImpl)this.includes(object) != OclBooleanImpl.TRUE) {
            seq._implementation.add(0, object);
        }
        return seq;
    }

    public OclSet including(OclAny object) {
        return this.append(object);
    }

    public OclSet excluding(OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        ArrayList<OclAny> col = new ArrayList<OclAny>();
        col.add(object);
        seq._implementation.removeAll(col);
        return seq;
    }

    public OclOrderedSet insertAt(OclInteger index, OclAny object) {
        OclOrderedSetImpl seq = (OclOrderedSetImpl)this.clone();
        if (object instanceof OclUndefined) {
            return seq;
        }
        int i = ((OclIntegerImpl)index).int_impl();
        if ((OclBooleanImpl)this.includes(object) != OclBooleanImpl.TRUE) {
            seq._implementation.add(i - 1, object);
        }
        return seq;
    }

    public OclOrderedSet subOrderedSet(OclInteger lower, OclInteger upper) {
        if (((OclIntegerImpl)lower).int_impl() < 1) {
            return null;
        }
        if (((OclIntegerImpl)upper).int_impl() > ((OclIntegerImpl)this.size()).int_impl()) {
            return null;
        }
        int l = ((OclIntegerImpl)lower).int_impl() - 1;
        int u = ((OclIntegerImpl)upper).int_impl() - 1 + 1;
        return this.adapter.OrderedSet(this.getElementType(), this.orderedset_impl().subList(l, u));
    }

    public OclAny at(OclInteger i) {
        return (OclAny)this.orderedset_impl().get(((OclIntegerImpl)i).int_impl() - 1);
    }

    public OclInteger indexOf(OclAny object) {
        Iterator i = this._implementation.iterator();
        int j = 1;
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj.equals(object)) {
                return this.adapter.Integer(j);
            }
            ++j;
        }
        return this.adapter.Integer(0);
    }

    public OclAny first() {
        if (this.orderedset_impl().size() < 1) {
            return this.adapter.Undefined();
        }
        return (OclAny)this.orderedset_impl().get(0);
    }

    public OclAny last() {
        if (this.orderedset_impl().size() < 1) {
            return this.adapter.Undefined();
        }
        return (OclAny)this.orderedset_impl().get(this.orderedset_impl().size() - 1);
    }

    public OclSet flatten() {
        OclOrderedSet flat = (OclOrderedSet)this.clone();
        ((Collection)flat.getImplementation()).clear();
        for (Object elem : this._implementation) {
            if (elem instanceof OclCollection) {
                Iterator j = null;
                if (elem instanceof OclBag) {
                    j = ((Collection)((OclBag)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclOrderedSet) {
                    j = ((Collection)((OclOrderedSet)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclSet) {
                    j = ((Collection)((OclSet)elem).flatten().getImplementation()).iterator();
                } else if (elem instanceof OclSequence) {
                    j = ((Collection)((OclSequence)elem).flatten().getImplementation()).iterator();
                }
                while (j.hasNext()) {
                    OclAny x = (OclAny)j.next();
                    if (x == null || (OclBooleanImpl)flat.excludes(x) != OclBooleanImpl.TRUE) continue;
                    flat = (OclOrderedSet)flat.including(x);
                }
                continue;
            }
            ((Collection)flat.getImplementation()).add(elem);
        }
        return flat;
    }

    public String toString() {
        String str = "OrderedSet { ";
        Iterator i = this._implementation.iterator();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    public boolean equals(Object o) {
        return o instanceof OclSet ? (OclBooleanImpl)this.equalTo((OclOrderedSet)o) == OclBooleanImpl.TRUE : false;
    }

    public Object clone() {
        return this.adapter.OrderedSet(this.getElementType(), this._implementation);
    }

    public Object asJavaObject() {
        BasicEList jObj = new BasicEList();
        for (Object o : this._implementation) {
            if (o instanceof OclAny) {
                o = ((OclAny)o).asJavaObject();
            }
            jObj.add(o);
        }
        return ECollections.unmodifiableEList((EList)jObj);
    }
}

