/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class CollectionKind
extends AbstractEnumerator {
    public static final int COLLECTION = 0;
    public static final int SET = 1;
    public static final int SEQUENCE = 2;
    public static final int BAG = 3;
    public static final int ORDERED_SET = 4;
    public static final CollectionKind COLLECTION_LITERAL = new CollectionKind(0, "COLLECTION", "COLLECTION");
    public static final CollectionKind SET_LITERAL = new CollectionKind(1, "SET", "SET");
    public static final CollectionKind SEQUENCE_LITERAL = new CollectionKind(2, "SEQUENCE", "SEQUENCE");
    public static final CollectionKind BAG_LITERAL = new CollectionKind(3, "BAG", "BAG");
    public static final CollectionKind ORDERED_SET_LITERAL = new CollectionKind(4, "ORDERED_SET", "ORDERED_SET");
    private static final CollectionKind[] VALUES_ARRAY = new CollectionKind[]{COLLECTION_LITERAL, SET_LITERAL, SEQUENCE_LITERAL, BAG_LITERAL, ORDERED_SET_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 0: {
                return COLLECTION_LITERAL;
            }
            case 1: {
                return SET_LITERAL;
            }
            case 2: {
                return SEQUENCE_LITERAL;
            }
            case 3: {
                return BAG_LITERAL;
            }
            case 4: {
                return ORDERED_SET_LITERAL;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

