/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.bridge.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.bridge.BridgePackage;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.factories.BridgeFactory;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.synthesis.CreationHelper;

public class EnvironmentImpl
extends EObjectImpl
implements Environment {
    protected static final BridgeFactory BRIDGE_FACTORY_EDEFAULT = null;
    protected BridgeFactory bridgeFactory = BRIDGE_FACTORY_EDEFAULT;
    protected static final Map NAMED_ELEMENT_ENTRYS_EDEFAULT = null;
    protected Map namedElementEntrys = new HashMap();
    protected EList namespaces;
    protected Environment parent;

    protected EnvironmentImpl() {
    }

    protected EClass eStaticClass() {
        return BridgePackage.Literals.ENVIRONMENT;
    }

    public BridgeFactory getBridgeFactory() {
        return this.bridgeFactory;
    }

    public void setBridgeFactory(BridgeFactory newBridgeFactory) {
        BridgeFactory oldBridgeFactory = this.bridgeFactory;
        this.bridgeFactory = newBridgeFactory;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldBridgeFactory, (Object)this.bridgeFactory));
        }
    }

    public Map getNamedElementEntrys() {
        return this.namedElementEntrys;
    }

    public void setNamedElementEntrys(Map newNamedElementEntrys) {
        Map oldNamedElementEntrys = this.namedElementEntrys;
        this.namedElementEntrys = newNamedElementEntrys;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldNamedElementEntrys, (Object)this.namedElementEntrys));
        }
    }

    public EList getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new EObjectResolvingEList(Namespace.class, (InternalEObject)this, 2);
        }
        return this.namespaces;
    }

    public Environment getParent() {
        if (this.parent != null && this.parent.eIsProxy()) {
            InternalEObject oldParent = (InternalEObject)this.parent;
            this.parent = (Environment)this.eResolveProxy(oldParent);
            if (this.parent != oldParent && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldParent, (Object)this.parent));
            }
        }
        return this.parent;
    }

    public Environment basicGetParent() {
        return this.parent;
    }

    public void setParent(Environment newParent) {
        Environment oldParent = this.parent;
        this.parent = newParent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldParent, (Object)this.parent));
        }
    }

    public NamedElement lookupLocal(String name) {
        NamedElement nel = (NamedElement)this.getNamedElementEntrys().get(name);
        if (nel == null) {
            Iterator i = this.getNamespaces().iterator();
            while (i.hasNext() && nel == null) {
                Namespace ns = (Namespace)i.next();
                ModelElement me = ns.lookupOwnedElement(name);
                if (me == null || (nel = this.bridgeFactory.buildNamedElement(name, me, Boolean.FALSE)) == null) continue;
                this.getNamedElementEntrys().put(name, nel);
            }
        }
        return nel;
    }

    public ModelElement lookup(String name) {
        NamedElement ne = this.lookupLocal(name);
        if (ne != null) {
            return ne.getReferredElement();
        }
        if (this.getParent() != null) {
            return this.getParent().lookup(name);
        }
        return null;
    }

    public ModelElement lookupPathName(List names) {
        if (names.size() == 1) {
            return this.lookup((String)names.get(0));
        }
        NamedElement nel = this.lookupLocal((String)names.get(0));
        if (nel != null && nel.getReferredElement() instanceof Namespace) {
            return this.nestedEnvironment().addNamespace((Namespace)nel.getReferredElement()).lookupPathName(names.subList(1, names.size()));
        }
        if (this.getParent() != null) {
            return this.getParent().lookupPathName(names);
        }
        return null;
    }

    public Environment addElement(String name, ModelElement elem, Boolean imp) {
        if (name == null) {
            return this;
        }
        if (this.getNamedElementEntrys().get(name) != null) {
            return this;
        }
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.getNamedElementEntrys().put(name, CreationHelper.createNamedElement(name, elem, imp));
        return result;
    }

    public Environment addEnvironment(Environment env) {
        for (String s : ((EnvironmentImpl)env).getNamedElementEntrys().keySet()) {
            if (!this.getNamedElementEntrys().containsKey(s)) continue;
            throw new RuntimeException("In Environment.addEnvironment: Name already exists in environemnt - " + s);
        }
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.getNamespaces().addAll((Collection)((EnvironmentImpl)env).getNamespaces());
        result.getNamedElementEntrys().putAll(((EnvironmentImpl)env).getNamedElementEntrys());
        return result;
    }

    public Environment addNamespace(Namespace ns) {
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.namespaces.add((Object)ns);
        return result.addElement(ns.getName(), ns, Boolean.FALSE);
    }

    public Property lookupImplicitProperty(String name) {
        NamedElement entry = this.lookupImplicitSourceForProperty(name);
        if (entry != null) {
            ModelElement source = entry.getReferredElement();
            if (source != null && source instanceof VariableDeclaration) {
                source = ((VariableDeclaration)source).getType();
            }
            if (source != null && source instanceof Classifier) {
                Property result = ((Classifier)source).lookupProperty(name);
                return result;
            }
        }
        return null;
    }

    public NamedElement lookupImplicitSourceForProperty(String name) {
        NamedElement foundElement = null;
        for (NamedElement entry : this.getNamedElements()) {
            Property foundProperty;
            Classifier type;
            if (entry == null || entry.getMayBeImplicit() == null || !entry.getMayBeImplicit().booleanValue() || (type = entry.getType()) == null || (foundProperty = type.lookupProperty(name)) == null) continue;
            foundElement = entry;
        }
        if (foundElement == null) {
            Environment parent = this.getParent();
            if (parent != null) {
                return parent.lookupImplicitSourceForProperty(name);
            }
            return null;
        }
        return foundElement;
    }

    public Operation lookupImplicitOperation(String name, List types) {
        NamedElement ne = this.lookupImplicitSourceForOperation(name, types);
        if (ne == null) {
            this.bridgeFactory.buildClassifier(this);
        } else {
            ModelElement source = ne.getReferredElement();
            if (source instanceof VariableDeclaration) {
                source = ((VariableDeclaration)source).getType();
            }
            if (source instanceof Classifier) {
                Operation result = ((Classifier)source).lookupOperation(name, types);
                return result;
            }
        }
        return null;
    }

    public Environment nestedEnvironment() {
        EnvironmentImpl result = new EnvironmentImpl();
        result.setBridgeFactory(this.bridgeFactory);
        result.setParent(this);
        return result;
    }

    public Operation lookupPathName(List names, List types) {
        if (names.size() == 2) {
            Classifier cl = (Classifier)this.lookup((String)names.get(0));
            String op_name = (String)names.get(1);
            return cl.lookupOperation(op_name, types);
        }
        ModelElement firstNamespace = this.lookupLocal((String)names.get(0)).getReferredElement();
        if (firstNamespace instanceof Namespace) {
            return this.nestedEnvironment().addNamespace((Namespace)firstNamespace).lookupPathName(names.subList(1, names.size()), types);
        }
        return this.getParent().lookupPathName(names, types);
    }

    public NamedElement lookupImplicitSourceForOperation(String name, List types) {
        NamedElement foundElement = null;
        for (NamedElement entry : this.getNamedElements()) {
            Operation foundOperation;
            if (!entry.getMayBeImplicit().booleanValue() || (foundOperation = entry.getType().lookupOperation(name, types)) == null) continue;
            foundElement = entry;
        }
        if (foundElement == null) {
            Environment parent = this.getParent();
            if (parent != null) {
                return parent.lookupImplicitSourceForOperation(name, types);
            }
            return null;
        }
        return foundElement;
    }

    public Environment addVariableDeclaration(String name, Classifier type, Boolean clash) {
        if (name == null) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (this.getNamedElementEntrys().get(name) != null) {
            return this;
        }
        VariableDeclaration vd = CreationHelper.createVariableDeclaration(name);
        vd.setType(type);
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.getNamedElementEntrys().put(name, CreationHelper.createNamedElement(name, vd, clash));
        return result;
    }

    public Object clone() {
        EnvironmentImpl copy = new EnvironmentImpl();
        copy.setBridgeFactory(this.bridgeFactory);
        copy.getNamedElementEntrys().putAll(this.getNamedElementEntrys());
        copy.getNamespaces().addAll((Collection)this.getNamespaces());
        copy.parent = this.parent;
        return copy;
    }

    public OclProcessor getProcessor() {
        return this.bridgeFactory.getProcessor();
    }

    public Environment getEMPTY_ENV() {
        EnvironmentImpl newEnvironment = new EnvironmentImpl();
        newEnvironment.setBridgeFactory(this.bridgeFactory);
        return newEnvironment;
    }

    public Set getNamedElements() {
        return new LinkedHashSet(this.getNamedElementEntrys().values());
    }

    public void setNamedElements(Set namedElements) {
        this.getNamedElementEntrys().clear();
        for (NamedElement ne : namedElements) {
            this.getNamedElementEntrys().put(ne.getName(), ne);
        }
    }

    public Environment addVariableDeclaration(VariableDeclaration variableDeclaration, Boolean clash) {
        if (variableDeclaration == null) {
            return this;
        }
        if (variableDeclaration.getName() == null) {
            return this;
        }
        if (this.getNamedElementEntrys().get(variableDeclaration.getName()) != null) {
            return this;
        }
        EnvironmentImpl result = (EnvironmentImpl)this.clone();
        result.getNamedElementEntrys().put(variableDeclaration.getName(), CreationHelper.createNamedElement(variableDeclaration.getName(), variableDeclaration, clash));
        return result;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getBridgeFactory();
            }
            case 1: {
                return this.getNamedElementEntrys();
            }
            case 2: {
                return this.getNamespaces();
            }
            case 3: {
                if (resolve) {
                    return this.getParent();
                }
                return this.basicGetParent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setBridgeFactory((BridgeFactory)newValue);
                return;
            }
            case 1: {
                this.setNamedElementEntrys((Map)newValue);
                return;
            }
            case 2: {
                this.getNamespaces().clear();
                this.getNamespaces().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setParent((Environment)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setBridgeFactory(BRIDGE_FACTORY_EDEFAULT);
                return;
            }
            case 1: {
                this.setNamedElementEntrys(NAMED_ELEMENT_ENTRYS_EDEFAULT);
                return;
            }
            case 2: {
                this.getNamespaces().clear();
                return;
            }
            case 3: {
                this.setParent(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return BRIDGE_FACTORY_EDEFAULT == null ? this.bridgeFactory != null : !BRIDGE_FACTORY_EDEFAULT.equals(this.bridgeFactory);
            }
            case 1: {
                return NAMED_ELEMENT_ENTRYS_EDEFAULT == null ? this.namedElementEntrys != null : !NAMED_ELEMENT_ENTRYS_EDEFAULT.equals(this.namedElementEntrys);
            }
            case 2: {
                return this.namespaces != null && !this.namespaces.isEmpty();
            }
            case 3: {
                return this.parent != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (bridgeFactory: ");
        result.append(this.bridgeFactory);
        result.append(", namedElementEntrys: ");
        result.append(this.namedElementEntrys);
        result.append(')');
        return result.toString();
    }
}

