/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.analyser;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Symbol;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitable;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.analyser.OclSemanticAnalyser;
import org.oslo.ocl20.semantics.analyser.OclSemanticAnalyserVisitorImpl;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.syntax.ast.Visitor;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class OclSemanticAnalyserImpl
implements OclSemanticAnalyser {
    protected OclProcessor processor;
    protected Visitor semanticAnalyzerVisitor;
    protected SemanticsVisitor debugVisitor = null;
    protected ILog log;
    protected boolean hasErrors;

    public OclSemanticAnalyserImpl(OclProcessor proc, Visitor semanticAnalyzerVisitor, SemanticsVisitor debugVisitor, ILog log) {
        this.processor = proc;
        this.semanticAnalyzerVisitor = semanticAnalyzerVisitor;
        this.debugVisitor = debugVisitor;
        this.log = log;
    }

    public List analyse(PackageDeclarationAS decl) {
        Environment env = this.processor.getBridgeFactory().buildEnvironment();
        new OutputStreamLog((OutputStream)System.out);
        return this.analyse(decl, env);
    }

    public List analyse(PackageDeclarationAS decl, Environment env) {
        OutputStreamLog log = new OutputStreamLog((OutputStream)System.out);
        return this.analyse(decl, env, (ILog)log);
    }

    public List analyse(PackageDeclarationAS decl, Environment env, ILog log) {
        return this.analyse(decl, env, log, false);
    }

    public List analyse(PackageDeclarationAS decl, Environment env, ILog log, boolean debugFlag) {
        ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).clearAstMap();
        int errNo = log.getErrors();
        HashMap<String, Environment> context = new HashMap<String, Environment>();
        context.put("env", env);
        context.put("log", (Environment)log);
        List l = (List)decl.accept(this.semanticAnalyzerVisitor, context);
        this.hasErrors = log.getErrors() > errNo && !log.tooManyViolations();
        return l;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public String getMessage(String message, SemanticsVisitable ast) {
        return new String(ErrorManager.getMessage(message, ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getSymbol(ast)));
    }

    public int getBeginColumn(SemanticsVisitable host) {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getBeginColumn(host);
    }

    public int getBeginLine(SemanticsVisitable host) {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getBeginLine(host);
    }

    public int getEndColumn(SemanticsVisitable host) {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getEndColumn(host);
    }

    public int getEndLine(SemanticsVisitable host) {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getEndLine(host);
    }

    public Symbol getSymbol(SemanticsVisitable object) {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getSymbol(object);
    }

    public Map getAstMap() {
        return ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).getAstMap();
    }

    public void setAstMap(Map value) {
        ((OclSemanticAnalyserVisitorImpl)this.semanticAnalyzerVisitor).setAstMap(value);
    }
}

