/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.bridge4emf;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.bridge4emf.EmfBridgeFactory;
import org.oslo.ocl20.semantics.SemanticsVisitor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.Enumeration;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.Property;

public class EnumerationImpl
extends org.oslo.ocl20.semantics.bridge.impl.EnumerationImpl
implements Enumeration {
    protected EEnum _eenum;
    String name = null;

    public EnumerationImpl(EEnum eenum, OclProcessor proc) {
        this._eenum = eenum;
        this.processor = proc;
        super.createOperations(this.processor.getTypeFactory());
        super.getOperations().add((Object)proc.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "=", new Classifier[]{this}));
        super.getOperations().add((Object)proc.getBridgeFactory().buildOperation(this.processor.getTypeFactory().buildBooleanType(), "<>", new Classifier[]{this}));
    }

    public String getName() {
        if (this._eenum != null) {
            this.name = "";
            EPackage pkg = this._eenum.getEPackage();
            while (pkg != null) {
                if (!this.name.equals("")) {
                    this.name = "." + this.name;
                }
                this.name = String.valueOf(pkg.getName()) + this.name;
                pkg = pkg.getESuperPackage();
            }
            if (!this.name.equals("")) {
                this.name = String.valueOf(this.name) + ".";
            }
            this.name = String.valueOf(this.name) + this._eenum.getName();
        }
        return this.name;
    }

    public Boolean conformsTo(Classifier t2) {
        if (t2 instanceof Enumeration) {
            return this.getName().equals(t2.getName()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public EnumLiteral lookupEnumLiteral(String name) {
        return ((EmfBridgeFactory)this.processor.getBridgeFactory()).buildEnumLiteral(this._eenum.getEEnumLiteral(name), this);
    }

    public Property lookupProperty(String name) {
        return this.lookupEnumLiteral(name);
    }

    public ModelElement lookupOwnedElement(String name) {
        return this.lookupEnumLiteral(name);
    }

    public EList getLiteral() {
        if (this._eenum != null && super.getLiteral().size() == 0) {
            for (EEnumLiteral lit : this._eenum.getELiterals()) {
                super.getLiteral().add((Object)((EmfBridgeFactory)this.processor.getBridgeFactory()).buildEnumLiteral(lit, this));
            }
        }
        return super.getLiteral();
    }

    public void setLiteral(List literals) {
    }

    public Object accept(SemanticsVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return this._eenum.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof Enumeration) {
            Enumeration enumerationType = (Enumeration)o;
            return this.getName().equals(enumerationType.getName());
        }
        return false;
    }

    public Object getDelegate() {
        return this._eenum.getInstanceClass();
    }
}

