/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;
import uk.ac.kent.cs.kmf.util.ILog;

public abstract class OclProcessorImpl
implements OclProcessor {
    public static int lineDelta = 0;
    public RuntimeEnvironment renv_ = null;
    protected Boolean debug = Boolean.FALSE;
    protected ILog log = null;
    protected List models = new ArrayList();
    protected List modelSet = new ArrayList();

    public OclProcessorImpl(ILog log) {
        this.log = log;
    }

    public void setDebug(Boolean d) {
        this.debug = d;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public ILog getLog() {
        return this.log;
    }

    public void setLog(ILog l) {
        this.log = l;
    }

    public List getModels() {
        return Collections.unmodifiableList(this.modelSet);
    }

    protected abstract Object validateModel(Object var1);

    public void setModels(Collection models) {
        this.modelSet = new ArrayList();
        this.models = new ArrayList();
        for (Object element : models) {
            ArrayList<Object> nestedModels = new ArrayList<Object>();
            if (element instanceof Collection) {
                Collection modelCollection = (Collection)element;
                for (Object nestedElement : modelCollection) {
                    Object mdl = this.validateModel(nestedElement);
                    if (mdl == null) continue;
                    nestedModels.add(mdl);
                    if (this.modelSet.contains(mdl)) continue;
                    this.modelSet.add(mdl);
                }
            } else {
                Object mdl = this.validateModel(element);
                if (mdl != null) {
                    nestedModels.add(mdl);
                    if (!this.modelSet.contains(mdl)) {
                        this.modelSet.add(mdl);
                    }
                }
            }
            this.models.add(nestedModels);
        }
    }

    public PackageDeclarationAS parse(String str) {
        return this.parse(str, this.getLog());
    }

    public PackageDeclarationAS parse(String str, ILog log) {
        log.resetErrors();
        PackageDeclarationAS pd = this.getParser().parse(new StringReader(str), log, false);
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    public PackageDeclarationAS parse(String str, ILog log, boolean debug) {
        PackageDeclarationAS pd = this.getParser().parse(new StringReader(str), log, debug);
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    public PackageDeclarationAS parse(Reader input) {
        return this.parse(input, this.getLog());
    }

    public PackageDeclarationAS parse(Reader input, ILog log) {
        PackageDeclarationAS pd = this.getParser().parse(input, log, this.getDebug());
        return pd;
    }

    public List analyse(PackageDeclarationAS pd) {
        return this.analyse(pd, this.getLog());
    }

    public List analyse(PackageDeclarationAS pd, ILog log) {
        Environment env = this.environment();
        return this.analyse(pd, env, log);
    }

    public List analyse(PackageDeclarationAS pd, Environment env, ILog log) {
        if (pd == null) {
            return null;
        }
        if (env == null) {
            env = this.environment();
        }
        List contextDecls = this.getAnalyser().analyse(pd, env, log, this.getDebug());
        return contextDecls;
    }

    public List analyse(String str) {
        return this.analyse(str, this.getLog());
    }

    public List analyse(String str, ILog log) {
        PackageDeclarationAS pd = this.parse(str, log);
        return this.analyse(pd, log);
    }

    public List analyse(Reader reader) {
        return this.analyse(reader, this.getLog());
    }

    public List analyse(Reader reader, ILog log) {
        PackageDeclarationAS pd = this.parse(reader, log);
        return this.analyse(pd, log);
    }

    public List analyse(String str, Environment env, ILog log) {
        PackageDeclarationAS pd = this.parse(str, log);
        return this.analyse(pd, env, log);
    }

    public List analyse(Reader reader, Environment env, ILog log) {
        PackageDeclarationAS pd = this.parse(reader, log);
        return this.analyse(pd, env, log);
    }

    public List evaluate(String str) {
        List cs;
        ILog log = this.getLog();
        if (!str.startsWith("context") && !str.contains("context OclVoid inv:")) {
            str = "context OclVoid inv: " + str;
        }
        if ((cs = this.analyse(str)) == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            this.renv_ = this.runtimeEnvironment("self", this.getStdLibAdapter().Undefined());
            Map declRes = this.getEvaluator().evaluate(decl, this.renv_, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public List evaluate(String str, Object self) {
        ILog log = this.getLog();
        return this.evaluate(str, self, log);
    }

    public List evaluate(String str, Object self, ILog log) {
        List cs = this.analyse(str, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            this.renv_ = this.runtimeEnvironment("self", self);
            Map declRes = this.getEvaluator().evaluate(decl, this.renv_, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public List evaluate(List cs, RuntimeEnvironment renv, ILog log) {
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, renv, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public List evaluate(Reader reader, Object self, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            this.renv_ = this.runtimeEnvironment("self", self);
            Map declRes = this.getEvaluator().evaluate(decl, this.renv_, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public Map evaluateAll(Reader reader, Object self, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (ContextDeclaration decl : cs) {
            this.renv_ = this.runtimeEnvironment("self", self);
            Map declRes = this.getEvaluator().evaluate(decl, this.renv_, log);
            result.putAll(declRes);
        }
        return result;
    }

    public List evaluate(Reader reader, Object self) {
        ILog log = this.getLog();
        return this.evaluate(reader, (Object)log);
    }

    public List evaluate(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        this.renv_ = renv;
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, renv, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public List evaluate_2(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        return null;
    }

    public List evaluate(Reader reader, Environment env, RuntimeEnvironment renv, ILog log) {
        this.renv_ = renv;
        List cs = this.analyse(reader, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            Map declRes = this.getEvaluator().evaluate(decl, renv, log);
            result.addAll(declRes.values());
        }
        return result;
    }

    public OclAny evaluateAsOCL(String str, Environment env, RuntimeEnvironment renv, ILog log) {
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector<OclAny> results = new Vector<OclAny>();
        for (ContextDeclaration decl : cs) {
            for (Constraint constraint : decl.getConstraint()) {
                if (((Object)((Object)ConstraintKind.DEF_LITERAL)).equals((Object)constraint.getKind())) continue;
                OclAny x = this.getEvaluator().evaluateAsOCL(decl, renv, log);
                results.add(x);
            }
        }
        return (OclAny)results.get(0);
    }

    public List generate(String str, String indent) {
        this.getLog();
        List cs = this.analyse(str);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    public List generate(String str, String indent, ILog log) {
        List cs = this.analyse(str, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    public List generate(Reader reader, String indent) {
        ILog log = this.getLog();
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    public List generate(Reader reader, String indent, ILog log) {
        List cs = this.analyse(reader, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    public List generate(String str, String indent, Environment env, ILog log) {
        List cs = this.analyse(str, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    public List generate(Reader reader, String indent, Environment env, ILog log) {
        List cs = this.analyse(reader, env, log);
        if (cs == null) {
            return null;
        }
        Vector result = new Vector();
        for (ContextDeclaration decl : cs) {
            List declRes = this.getGenerator().generate(decl, indent, (OclProcessor)this);
            result.addAll(declRes);
        }
        return result;
    }

    String defsMethod() {
        String s = "static public Object def(String propertyName, Object[] args) {\njava.lang.reflect.Method m = null;\nObject res = null;\nClass[] types = uk.ac.kent.cs.kmf.util.reflection.BetterMethodFinder.getParameterTypesFrom(args);\ntry {\n\tm = new uk.ac.kent.cs.kmf.util.reflection.BetterMethodFinder(Invariants.class).findMethod(propertyName, types);\n} catch (NoSuchMethodException e) {\n\t//e.printStackTrace();\n\tSystem.err.println(\"Error: No property \"+propertyName+\" defined for \"+args[0].getClass());\n}\nif (m != null) {\n\ttry {\n\t\tres = m.invoke(null, args);\n\t} catch (IllegalArgumentException e1) {\n\t\t//e1.printStackTrace();\n\t} catch (IllegalAccessException e1) {\n\t\t//e1.printStackTrace();\n\t} catch (java.lang.reflect.InvocationTargetException e1) {\n\t\t//e1.printStackTrace();\n\t}\n}\nreturn res;\n}\n";
        return s;
    }

    public Environment environment(String name, Object obj) {
        Classifier type = this.getBridgeFactory().buildClassifier(obj);
        Environment env = this.environment();
        return env.addVariableDeclaration(name, type, Boolean.TRUE);
    }

    public Environment environment() {
        Environment env = this.getBridgeFactory().buildEnvironment();
        env = env.addElement("OclType", this.getTypeFactory().buildTypeType(null), Boolean.FALSE);
        env = env.addElement("OclAny", this.getTypeFactory().buildOclAnyType(), Boolean.FALSE);
        env = env.addElement("OclVoid", this.getTypeFactory().buildVoidType(), Boolean.FALSE);
        env = env.addElement("Real", this.getTypeFactory().buildRealType(), Boolean.FALSE);
        env = env.addElement("Integer", this.getTypeFactory().buildIntegerType(), Boolean.FALSE);
        env = env.addElement("String", this.getTypeFactory().buildStringType(), Boolean.FALSE);
        env = env.addElement("Boolean", this.getTypeFactory().buildBooleanType(), Boolean.FALSE);
        Iterator i = this.getMetaModels().iterator();
        while (i.hasNext()) {
            Namespace ns = this.getBridgeFactory().buildNamespace(i.next());
            env = env.addNamespace(ns);
        }
        return env;
    }

    public RuntimeEnvironment runtimeEnvironment(String name, Object eobj) {
        RuntimeEnvironmentImpl renv = new RuntimeEnvironmentImpl();
        renv.setValue(name, eobj);
        return renv;
    }

    public RuntimeEnvironment runtimeEnvironment() {
        RuntimeEnvironmentImpl renv = new RuntimeEnvironmentImpl();
        return renv;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.renv_;
    }

    public Collection getModelsForAllInstances() {
        return this.modelSet;
    }

    public void setLineDelta(int value) {
        lineDelta = value;
    }
}

