/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution.debug.requests;

import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.execution.debug.IDebugAdapter;
import de.ikv.medini.qvt.execution.debug.replies.QVTDebugReplyFailure;
import de.ikv.medini.qvt.execution.debug.replies.QVTDebugReplyGetValue;
import de.ikv.medini.qvt.execution.debug.requests.QVTDebugRequest;
import de.ikv.medini.qvt.execution.debug.stackframe.QVTDebugStackFrame;
import de.ikv.medini.qvt.execution.debug.stackframe.QVTStackFrameEvaluable;
import de.ikv.medini.qvt.execution.debug.stackframe.QVTStackFrameVariable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

public class QVTDebugRequestGetValue
extends QVTDebugRequest {
    private QVTStackFrameEvaluable val;

    public QVTDebugRequestGetValue(QVTStackFrameEvaluable val) {
        this.val = val;
    }

    public String toString() {
        return "" + this.val;
    }

    public QVTStackFrameEvaluable getExpr() {
        return this.val;
    }

    public static OclAny evaluateOCL(IDebugAdapter debugAdapter, String expression, QVTDebugStackFrame stackFrame) {
        QvtProcessorImpl processor = debugAdapter.getQvtProcessor();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamLog logOcl = new OutputStreamLog((OutputStream)byteArrayOutputStream);
        Environment env = processor.environment();
        RuntimeEnvironmentImpl renv = new RuntimeEnvironmentImpl();
        if (stackFrame != null) {
            for (QVTStackFrameVariable var : stackFrame.getVariables()) {
                QVTDebugRequestGetValue varValueReply = new QVTDebugRequestGetValue(var);
                varValueReply.handleRequest(debugAdapter);
                if (!(varValueReply.getReply() instanceof QVTDebugReplyGetValue)) continue;
                OclAny oclValue = ((QVTDebugReplyGetValue)varValueReply.getReply()).getValue();
                if (oclValue == null) {
                    oclValue = processor.getStdLibAdapter().OclAny(null);
                }
                renv.setValue(var.getName(), oclValue);
                env = env.addVariableDeclaration(var.getName(), (Classifier)oclValue.oclType().asJavaObject(), Boolean.TRUE);
            }
        }
        Object stateInfo = processor.saveSemanticStateInformation();
        try {
            List result;
            processor.setLineDelta(-1);
            try {
                result = processor.evaluate("context OclVoid inv:\n" + expression, env, (RuntimeEnvironment)renv, (ILog)logOcl);
            }
            finally {
                processor.setLineDelta(0);
            }
            if (logOcl.hasErrors()) {
                throw new RuntimeException(new String(byteArrayOutputStream.toByteArray()));
            }
            if (result != null && result.size() >= 1) {
                OclAny oclValue;
                OclAny oclAny = oclValue = processor.getStdLibAdapter().OclAny(result.get(0));
                return oclAny;
            }
            throw new RuntimeException("Evaluation result is " + (result == null ? "null" : "empty"));
        }
        finally {
            processor.restoreSemanticStateInformation(stateInfo);
        }
    }

    public void handleRequest(IDebugAdapter debugAdapter) {
        try {
            OclAny oclValue = this.val.evaluate(debugAdapter);
            this.setReply(new QVTDebugReplyGetValue(oclValue));
        }
        catch (Throwable e) {
            this.setReply(new QVTDebugReplyFailure(e.getMessage()));
        }
    }
}

