/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution;

import de.ikv.medini.qvt.QvtEvaluatorVisitorImpl;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.execution.QvtSemanticTask;
import de.ikv.medini.qvt.execution.QvtSemanticTaskKey;
import de.ikv.medini.qvt.model.qvtbase.Rule;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationalTransformation;
import de.ikv.medini.qvt.util.QvtSemanticTaskDebugInfo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public class QvtSemanticAnalyserThreadPool {
    private static final boolean useOptimizedTaskList = true;
    private static PrintStream evaluationStream = null;
    private QvtSemanticTask currentComputedTask = null;
    private Set taskList = new HashSet();
    private Map taskListMap = new HashMap();
    private ListOrderedSet taskListWithWork = new ListOrderedSet();
    private QvtProcessorImpl processor;
    private List topLevelRelations;
    private Object data;
    private int oldTaskListWithWorkSize;
    private int randomTasks;
    private int randomTasksSinceLastCreation;
    private int randomTasksSinceLastModification;
    private int modificationCountSinceLastRandomTaskGeneration;
    private Relation randomRelationOfLastRandomTask;

    public static PrintStream getLogger() {
        if (evaluationStream != null) {
            return evaluationStream;
        }
        return System.out;
    }

    public static void setLogger(PrintStream stream) {
        evaluationStream = stream;
    }

    public QvtSemanticAnalyserThreadPool(QvtProcessorImpl processor, int threadCount, RelationalTransformation transformation, Object data) {
        this.data = data;
        if (processor.isRandomMode()) {
            this.topLevelRelations = new ArrayList();
            for (Rule rule : transformation.getRule()) {
                Relation relation = (Relation)rule;
                if (!relation.isIsTopLevel()) continue;
                this.topLevelRelations.add(relation);
            }
        }
        this.processor = processor;
    }

    public QvtSemanticTask addTask(QvtSemanticTask qvtSemanticTask, boolean[] promotedToBeExecuted) {
        Set set = this.taskList;
        synchronized (set) {
            Set candidateSet = this.getTaskSetWithEqualSourceDomains(qvtSemanticTask);
            if (!this.taskList.contains(qvtSemanticTask)) {
                QvtSemanticTask candidate = null;
                if (candidateSet.size() >= 2 && qvtSemanticTask.areTargetDomainValuesUndefined()) {
                    throw new RuntimeException("Found 2 or more relation tuples for relation call to " + qvtSemanticTask.getRelation().getName() + ". This is not allowed!");
                }
                if (candidateSet.size() >= 1) {
                    candidate = (QvtSemanticTask)candidateSet.iterator().next();
                    if (!candidate.areTargetDomainValuesUndefined() && !qvtSemanticTask.areTargetDomainValuesUndefined()) {
                        candidate = null;
                    } else if (candidate.areTargetDomainValuesUndefined() && !qvtSemanticTask.areTargetDomainValuesUndefined()) {
                        candidate.getTrace().repopulateArguments(qvtSemanticTask.getTrace().getArguments());
                    }
                }
                if (candidate != null) {
                    if (qvtSemanticTask.isShallBeExecuted() && !candidate.isShallBeExecuted()) {
                        promotedToBeExecuted[0] = true;
                        candidate.setShallBeExecuted(true);
                        this.checkForWork(candidate, false);
                    }
                    return candidate;
                }
                this.taskList.add(qvtSemanticTask);
                this.addToTaskSetWithEqualSourceDomains(qvtSemanticTask, candidateSet);
                this.checkForWork(qvtSemanticTask, false);
                return qvtSemanticTask;
            }
            for (QvtSemanticTask currentQvtSemanticTask : candidateSet) {
                if (!currentQvtSemanticTask.equals(qvtSemanticTask)) continue;
                if (qvtSemanticTask.isShallBeExecuted() && !currentQvtSemanticTask.isShallBeExecuted()) {
                    currentQvtSemanticTask.setShallBeExecuted(true);
                    this.checkForWork(currentQvtSemanticTask, false);
                    promotedToBeExecuted[0] = true;
                }
                return currentQvtSemanticTask;
            }
            throw new RuntimeException("not reachable");
        }
    }

    private Set getTaskSetWithEqualSourceDomains(QvtSemanticTask qvtSemanticTask) {
        Object result = this.taskListMap.get(new QvtSemanticTaskKey(qvtSemanticTask));
        if (result == null) {
            return new HashSet();
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        if (result instanceof QvtSemanticTask) {
            HashSet set = new HashSet();
            set.add(result);
            return set;
        }
        throw new RuntimeException("Error in getSet()");
    }

    private void addToTaskSetWithEqualSourceDomains(QvtSemanticTask qvtSemanticTask, Set candidateSet) {
        if (candidateSet.size() == 0) {
            this.taskListMap.put(new QvtSemanticTaskKey(qvtSemanticTask), qvtSemanticTask);
        } else if (candidateSet.size() == 1) {
            candidateSet.add(qvtSemanticTask);
            this.taskListMap.put(new QvtSemanticTaskKey(qvtSemanticTask), candidateSet);
        } else {
            candidateSet.add(qvtSemanticTask);
        }
    }

    private void removeFromTaskSetWithEqualSourceDomains(QvtSemanticTask qvtSemanticTask) {
        Set candidateSet = this.getTaskSetWithEqualSourceDomains(qvtSemanticTask);
        if (candidateSet.contains(qvtSemanticTask) && candidateSet.size() != 0) {
            if (candidateSet.size() == 1) {
                this.taskListMap.remove(new QvtSemanticTaskKey(qvtSemanticTask));
            } else {
                candidateSet.remove(candidateSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean hasThreadsToBeExecuted = true;
        QvtSemanticTaskDebugInfo.setOrAddValueForFeautureCount = 0;
        QvtSemanticTaskDebugInfo.createOclAnyModelElementCount = 0;
        if (this.processor.isDebugMode()) {
            QvtSemanticAnalyserThreadPool.getLogger().println("(start QVT evaluation)");
        }
        if (this.processor.isRandomMode()) {
            this.randomTasks = 0;
            this.randomTasksSinceLastCreation = 0;
            this.randomTasksSinceLastModification = 0;
        }
        if (this.processor.getDebugAdapter() != null) {
            this.processor.getDebugAdapter().doDebugWork();
        }
        Date startTimeMeasuring = new Date();
        try {
            while (hasThreadsToBeExecuted) {
                hasThreadsToBeExecuted = false;
                Set set = this.taskList;
                synchronized (set) {
                    if (this.processor.getDebugAdapter() != null) {
                        this.processor.getDebugAdapter().beforeComputingNextTask();
                    }
                    ArrayList tmp = this.getArrayFromItem(this.taskListWithWork);
                    for (QvtSemanticTask currentQvtSemanticTask : tmp) {
                        if (!currentQvtSemanticTask.hasWorkToDo()) continue;
                        Date startTupleMeasuring = null;
                        int totalCreatedElements = QvtSemanticTaskDebugInfo.createOclAnyModelElementCount;
                        int totalModifications = QvtSemanticTaskDebugInfo.getTotalModificationCount();
                        if (this.processor.logTasks()) {
                            QvtSemanticAnalyserThreadPool.getLogger().print(currentQvtSemanticTask.getRelation().getName());
                            startTupleMeasuring = new Date();
                        }
                        this.currentComputedTask = currentQvtSemanticTask;
                        try {
                            currentQvtSemanticTask.run();
                        }
                        finally {
                            this.currentComputedTask = null;
                        }
                        this.checkForWork(currentQvtSemanticTask, true);
                        this.checkWaitingTasksForWork(currentQvtSemanticTask, false);
                        if (this.processor.isRandomMode()) {
                            Relation relation;
                            if (!currentQvtSemanticTask.isComputing() && currentQvtSemanticTask.isExecuted() && this.modificationCountSinceLastRandomTaskGeneration < QvtSemanticTaskDebugInfo.getTotalModificationCount() && !this.processor.isRelationCalled(relation = currentQvtSemanticTask.getRelation())) {
                                this.taskList.remove(currentQvtSemanticTask);
                                this.removeFromTaskSetWithEqualSourceDomains(currentQvtSemanticTask);
                            }
                            if (currentQvtSemanticTask.isExecuted()) {
                                this.randomRelationOfLastRandomTask = null;
                            }
                            if (QvtSemanticTaskDebugInfo.createOclAnyModelElementCount > totalCreatedElements) {
                                this.randomTasksSinceLastCreation = this.randomTasks;
                            }
                            if (QvtSemanticTaskDebugInfo.getTotalModificationCount() > totalModifications) {
                                this.randomTasksSinceLastModification = this.randomTasks;
                            }
                        }
                        if (this.processor.logTasks()) {
                            long x;
                            if (currentQvtSemanticTask.isFailed()) {
                                if (currentQvtSemanticTask.getDebugInfo().failedClause != null) {
                                    QvtSemanticAnalyserThreadPool.getLogger().print("(failed at " + currentQvtSemanticTask.getQvtProcessor().getAnalyser().getMessage("", currentQvtSemanticTask.getDebugInfo().failedClause) + ")");
                                } else {
                                    QvtSemanticAnalyserThreadPool.getLogger().print("(failed)");
                                }
                            }
                            if (currentQvtSemanticTask.isExecuted()) {
                                QvtSemanticAnalyserThreadPool.getLogger().print("(done successfull bindings:" + currentQvtSemanticTask.getDebugInfo().succussfullBindings + " unsuccessfull bindings:" + currentQvtSemanticTask.getDebugInfo().unsuccussfullBindings + " wordToDo=" + currentQvtSemanticTask.hasWorkToDo() + " isExecutedForWaitingTasks:" + currentQvtSemanticTask.isExecutedForWaitingTasks() + " hasProcessedAllClauses:" + currentQvtSemanticTask.hasProcessedAllClauses() + ")");
                            }
                            if (currentQvtSemanticTask.getWaitingForTask() != null) {
                                QvtSemanticAnalyserThreadPool.getLogger().print("(waiting for " + currentQvtSemanticTask.getWaitingForTask().getRelation().getName() + ")");
                            }
                            if (currentQvtSemanticTask.hasWorkToDo()) {
                                QvtSemanticAnalyserThreadPool.getLogger().print("(hasWorkToDo)");
                            }
                            if ((x = new Date().getTime() - startTupleMeasuring.getTime()) >= 50L) {
                                QvtSemanticAnalyserThreadPool.getLogger().print("(took " + x + "ms)");
                            }
                            QvtSemanticAnalyserThreadPool.getLogger().println();
                        }
                        hasThreadsToBeExecuted = true;
                    }
                    if (!hasThreadsToBeExecuted) {
                        tmp = new ArrayList(this.taskList);
                        for (QvtSemanticTask currentQvtSemanticTask : tmp) {
                            if (currentQvtSemanticTask.isShallBeExecuted() || currentQvtSemanticTask.isFailed()) continue;
                            currentQvtSemanticTask.setFailed(true);
                            hasThreadsToBeExecuted = true;
                            if (!this.processor.logTasks()) continue;
                            QvtSemanticAnalyserThreadPool.getLogger().print(currentQvtSemanticTask.getRelation().getName());
                            QvtSemanticAnalyserThreadPool.getLogger().print("(failed by deadlock)");
                            QvtSemanticAnalyserThreadPool.getLogger().println();
                        }
                    }
                }
            }
        }
        finally {
            if (this.processor.isDebugMode()) {
                QvtSemanticAnalyserThreadPool.getLogger().println("(QVT evaluation done in " + (new Date().getTime() - startTimeMeasuring.getTime()) + " ms, created " + QvtSemanticTaskDebugInfo.createOclAnyModelElementCount + " new elements, set " + QvtSemanticTaskDebugInfo.setOrAddValueForFeautureCount + " features )");
            }
        }
    }

    private List getArrayFromItem(ListOrderedSet list) {
        if (this.processor.isRandomMode() && list.isEmpty() && this.processor.hasRandomResidual() && this.randomTasks - this.randomTasksSinceLastCreation <= 100) {
            TypedModel targetModel = (TypedModel)((Map)this.data).get("qvtDirection");
            this.oldTaskListWithWorkSize = this.taskListWithWork.size();
            if (this.randomRelationOfLastRandomTask != null) {
                this.processor.getQvtEvaluator().getQvtEvaluatorVisitor().executeToplevelRelation(this.randomRelationOfLastRandomTask, targetModel, this.data);
                if (this.hasCreatedRandomTask()) {
                    ++this.randomTasks;
                    this.modificationCountSinceLastRandomTaskGeneration = QvtSemanticTaskDebugInfo.getTotalModificationCount();
                }
            }
            if (list.isEmpty()) {
                List relations = QvtEvaluatorVisitorImpl.getRandomPermutation(this.topLevelRelations);
                for (Relation relation : relations) {
                    this.processor.getQvtEvaluator().getQvtEvaluatorVisitor().executeToplevelRelation(relation, targetModel, this.data);
                    if (!this.hasCreatedRandomTask()) continue;
                    ++this.randomTasks;
                    this.modificationCountSinceLastRandomTaskGeneration = QvtSemanticTaskDebugInfo.getTotalModificationCount();
                    this.randomRelationOfLastRandomTask = relation;
                    break;
                }
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (!list.isEmpty()) {
            result.add(list.get(0));
        }
        return result;
    }

    public void checkWaitingTasksForWork(QvtSemanticTask task, boolean expectToBeInList) {
        if (this.currentComputedTask != task) {
            Iterator it = task.getWaitingTasksIterator();
            while (it.hasNext()) {
                QvtSemanticTask waitingTask = (QvtSemanticTask)it.next();
                this.checkForWork(waitingTask, expectToBeInList);
            }
        }
    }

    public void checkForWork(QvtSemanticTask task, boolean expectToBeInList) {
        boolean isInList = this.taskListWithWork.contains((Object)task);
        if (expectToBeInList != isInList) {
            System.err.println("Task for relation " + task.getRelation().getName() + " was " + (expectToBeInList ? "" : "not ") + "expected to be in the taskListWithWork list!");
        }
        if (task.hasWorkToDo()) {
            if (!isInList) {
                this.taskListWithWork.add(0, (Object)task);
            }
        } else if (isInList) {
            this.taskListWithWork.remove((Object)task);
        }
    }

    public void bringToFront(QvtSemanticTask task) {
        if (this.taskListWithWork.remove((Object)task)) {
            this.taskListWithWork.add(0, (Object)task);
        } else if (task.getWaitingForTask() != null) {
            this.bringToFront(task.getWaitingForTask());
        }
    }

    public QvtSemanticTask getCurrentComputedTask() {
        return this.currentComputedTask;
    }

    public int getTaskCount() {
        return this.taskList.size();
    }

    public boolean hasCreatedRandomTask() {
        return this.taskListWithWork.size() > this.oldTaskListWithWorkSize;
    }
}

