/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution;

import de.ikv.medini.qvt.QVTDirectedValidation;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;

public class QvtOptimizedSemanticBindingIterator
implements Iterator {
    private ObjectTemplateExp[] objectTemplates;
    private Iterator[] allIterators;
    private Map currentObjects;
    private QvtProcessorImpl processor;
    private boolean hasNextBinding;
    private boolean hasNoBinding;

    public QvtOptimizedSemanticBindingIterator(List templatesToIterate, QvtProcessorImpl processor, Map rootValues) {
        this.processor = processor;
        this.objectTemplates = templatesToIterate.toArray(new ObjectTemplateExp[templatesToIterate.size()]);
        this.allIterators = new Iterator[templatesToIterate.size()];
        this.currentObjects = rootValues;
        this.hasNextBinding = this.initializeIterators(0);
        this.hasNoBinding = false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (this.hasNextBinding) {
            return true;
        }
        if (this.hasNoBinding) {
            return false;
        }
        i = this.allIterators.length - 1;
        ** GOTO lbl15
        {
            this.currentObjects.put(this.objectTemplates[i], this.allIterators[i].next());
            if (this.initializeIterators(i + 1)) {
                this.hasNextBinding = true;
                return true;
            }
            do {
                if (this.allIterators[i] != null && this.allIterators[i].hasNext()) continue block0;
                --i;
lbl15:
                // 2 sources

            } while (i >= 0);
        }
        this.hasNoBinding = true;
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            RuntimeEnvironmentImpl runtimeEnvironment = new RuntimeEnvironmentImpl();
            int i = 0;
            while (i < this.objectTemplates.length) {
                OclAny objectTemplateValue = (OclAny)this.currentObjects.get(this.objectTemplates[i]);
                if (objectTemplateValue == null) {
                    throw new RuntimeException("Internal error in QvtOptimizedSemanticBindingIterator: binding var is null");
                }
                runtimeEnvironment.setValue(this.objectTemplates[i].getBindsTo().getName(), objectTemplateValue);
                ++i;
            }
            this.hasNextBinding = false;
            return runtimeEnvironment;
        }
        throw new NoSuchElementException();
    }

    private boolean initializeIterators(int index) {
        if (index >= this.objectTemplates.length) {
            return true;
        }
        ObjectTemplateExp template = this.objectTemplates[index];
        if (this.allIterators[index] != null && this.allIterators[index].hasNext()) {
            throw new RuntimeException("Internal error in QvtOptimizedSemanticBindingIterator: child has still bindings");
        }
        if (template.eContainer() instanceof PropertyTemplateItem) {
            PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)template.eContainer();
            ObjectTemplateExp parentTemplate = propertyTemplateItem.getObjContainer();
            Object sourceValue = this.currentObjects.get(parentTemplate);
            List vals = QVTDirectedValidation.getValueList(sourceValue, propertyTemplateItem.getReferredProperty(), this.getQvtProcessor());
            ArrayList<OclAny> list = new ArrayList<OclAny>();
            for (Object obj : vals) {
                if (obj == null) continue;
                OclAny currentValue = this.processor.getStdLibAdapter().OclAny(obj);
                if (currentValue != null && !(currentValue instanceof OclUndefined) && currentValue.oclType().asJavaObject() == null) {
                    throw new RuntimeException("QvtOptimizedSemanticBindingIterator: cannot retrieve RTTI");
                }
                if (currentValue != null && !(currentValue instanceof OclUndefined) && currentValue.oclType().asJavaObject() != null && !((Classifier)currentValue.oclType().asJavaObject()).conformsTo(template.getType()).booleanValue()) continue;
                list.add(currentValue);
            }
            this.allIterators[index] = list.iterator();
            while (this.allIterators[index].hasNext()) {
                this.currentObjects.put(template, this.allIterators[index].next());
                if (index + 1 == this.objectTemplates.length) {
                    return true;
                }
                if (!this.initializeIterators(index + 1)) continue;
                return true;
            }
            int w = index;
            while (w < this.objectTemplates.length) {
                this.allIterators[w] = null;
                ++w;
            }
            return false;
        }
        throw new RuntimeException("Internal error in QvtOptimizedSemanticBindingIterator: Nested object template not part of a PropertyTemplateItem");
    }

    private int index(ObjectTemplateExp template) {
        int i = 0;
        while (i < this.objectTemplates.length) {
            if (this.objectTemplates[i] == template) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public QvtProcessorImpl getQvtProcessor() {
        return this.processor;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

