/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution;

import de.ikv.medini.qvt.execution.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.oslo.ocl20.OclProcessorImpl;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;

public class QueryImpl
implements Query {
    private OclProcessorImpl ev;
    private static final String SELF_VARIABLE_NAME = "self";
    private Map extentMap = null;
    private final ContextDeclaration expression;
    private final Environment environment;
    private RuntimeEnvironment evalEnv;

    public QueryImpl(Environment environment, ContextDeclaration declaration, Map extentMap, OclProcessorImpl ev) {
        this.environment = environment;
        this.expression = declaration;
        this.extentMap = extentMap;
        this.ev = ev;
    }

    public Map getExtentMap() {
        return this.extentMap;
    }

    public ContextDeclaration getExpression() {
        return this.expression;
    }

    public Object evaluate(Object obj) {
        EObject eobj;
        RuntimeEnvironment myEnv = this.getRuntimeEnvironment();
        myEnv.setValue(SELF_VARIABLE_NAME, obj);
        if (obj instanceof EObject && (eobj = (EObject)obj).eResource() != null) {
            ArrayList<Resource> models = new ArrayList<Resource>();
            models.add(eobj.eResource());
            this.ev.setModels(models);
        }
        Object result = null;
        try {
            result = this.evaluate(myEnv);
        }
        finally {
            myEnv.setValue(SELF_VARIABLE_NAME, null);
        }
        return result;
    }

    public Object evaluate() {
        return this.evaluate(this.getRuntimeEnvironment());
    }

    public Object evaluate(RuntimeEnvironment myEnv) {
        ArrayList<ContextDeclaration> expressions = new ArrayList<ContextDeclaration>();
        expressions.add(this.expression);
        List list = this.ev.evaluate(expressions, myEnv, this.ev.getLog());
        if (list instanceof List && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public boolean check(Object obj) {
        Object result = obj == null ? this.evaluate() : this.evaluate(obj);
        return Boolean.TRUE.equals(result);
    }

    public List evaluate(List objList) {
        BasicEList result = new BasicEList();
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            result.add(this.evaluate(iter.next()));
        }
        return result;
    }

    public boolean check(List objList) {
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            if (this.check(iter.next())) continue;
            return false;
        }
        return true;
    }

    public List select(List objList) {
        BasicEList result = new BasicEList();
        for (Object obj : objList) {
            if (!this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public List reject(List objList) {
        BasicEList result = new BasicEList();
        for (Object obj : objList) {
            if (this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public Object resultType() {
        return ((Constraint)this.expression.getConstraint().get(0)).getBodyExpression().getType();
    }

    public String queryText() {
        return this.expression.toString();
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = new RuntimeEnvironmentImpl();
        }
        return this.evalEnv;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Query[");
        result.append(this.queryText());
        result.append(']');
        return result.toString();
    }
}

