/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt;

import de.ikv.medini.qvt.QVTDirectedValidation;
import de.ikv.medini.qvt.QvtEvaluatorVisitorImpl;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.QvtTemplateExpressionFinderVisitorImpl;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationDomain;
import de.ikv.medini.qvt.model.qvttemplate.ColletionTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.TemplateExp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;

public class QVTEvaluatorHelper {
    private QvtEvaluatorVisitorImpl qvtEvaluatorVisitor;

    public QVTEvaluatorHelper(QvtEvaluatorVisitorImpl qvtEvaluatorVisitorImpl) {
        this.qvtEvaluatorVisitor = qvtEvaluatorVisitorImpl;
    }

    public static List collectAllTemplateVariablesOfRelation(Relation relation, Object data) {
        ArrayList result = new ArrayList();
        EList domains = relation.getDomain();
        for (RelationDomain currentRelationDomain : domains) {
            result.addAll(QVTEvaluatorHelper.collectAllTemplateVariablesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public List collectAllTemplateVariablesOfRelationExcludingTargetDomain(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        EList doamins = relation.getDomain();
        for (RelationDomain currentRelationDomain : doamins) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTEvaluatorHelper.collectAllTemplateVariablesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public List collectAllTemplateVariablesOfRelationInDirection(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        EList doamins = relation.getDomain();
        for (RelationDomain currentRelationDomain : doamins) {
            if (!direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTEvaluatorHelper.collectAllTemplateVariablesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public List collectAllDomainRootVariablesOfRelation(Relation relation) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        EList doamins = relation.getDomain();
        for (RelationDomain currentRelationDomain : doamins) {
            result.add(currentRelationDomain.getRootVariable());
        }
        return result;
    }

    public List collectAllDomainsOfRelationInDirection(Relation relation, TypedModel direction) {
        ArrayList<RelationDomain> result = new ArrayList<RelationDomain>();
        EList doamins = relation.getDomain();
        for (RelationDomain currentRelationDomain : doamins) {
            if (!direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.add(currentRelationDomain);
        }
        return result;
    }

    public List collectAllDomainRootVariablesOfRelationInDirection(Relation relation, TypedModel direction) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        for (RelationDomain currentRelationDomain : this.collectAllDomainsOfRelationInDirection(relation, direction)) {
            result.add(currentRelationDomain.getRootVariable());
        }
        return result;
    }

    public List collectAllDomainsOfRelationNotInDirection(Relation relation, TypedModel direction) {
        ArrayList<RelationDomain> result = new ArrayList<RelationDomain>();
        EList doamins = relation.getDomain();
        for (RelationDomain currentRelationDomain : doamins) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.add(currentRelationDomain);
        }
        return result;
    }

    public List collectAllDomainRootVariablesOfRelationNotInDirection(Relation relation, TypedModel direction) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        for (RelationDomain currentRelationDomain : this.collectAllDomainsOfRelationNotInDirection(relation, direction)) {
            result.add(currentRelationDomain.getRootVariable());
        }
        return result;
    }

    public List collectAllTemplateVariablesOfRelationExcludingRootVariableExcludingTargetDomain(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(this.collectAllTemplateVariablesOfRelationDomainExcludingRootVariable(currentRelationDomain, data));
        }
        return result;
    }

    public List collectAllTemplateVariablesOfRelationDomainExcludingRootVariable(RelationDomain relationDomain, Object data) {
        List result = QVTEvaluatorHelper.collectAllTemplateVariablesOfRelationDomain(relationDomain, data);
        result.remove(this.getRootVariableOfRelationDomain(relationDomain));
        return result;
    }

    public static List collectAllTemplateVariablesOfRelationDomain(RelationDomain relationDomain, Object data) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        QvtTemplateExpressionFinderVisitorImpl qvtTemplateExpressionFinderVisitor = new QvtTemplateExpressionFinderVisitorImpl();
        if (relationDomain.getPattern() == null) {
            result.add(relationDomain.getRootVariable());
            return result;
        }
        relationDomain.getPattern().getTemplateExpression().accept(qvtTemplateExpressionFinderVisitor, data);
        List templateExpressions = qvtTemplateExpressionFinderVisitor.getTemplateExpressions();
        for (TemplateExp currentTemplateExp : templateExpressions) {
            if (currentTemplateExp instanceof ObjectTemplateExp) {
                ObjectTemplateExp currentObjectTemplateExp = (ObjectTemplateExp)currentTemplateExp;
                VariableDeclaration bindsTo = currentObjectTemplateExp.getBindsTo();
                result.add(bindsTo);
                continue;
            }
            if (currentTemplateExp instanceof ColletionTemplateExp) {
                throw new RuntimeException("Collection Templates are not yet supported.");
            }
            throw new RuntimeException("Unsupported template kind: " + currentTemplateExp.getClass().getName());
        }
        return result;
    }

    public List collectAllNestedObjectTemplatesOfRelationExcludingTargetDomain(Relation relation, TypedModel direction, Object data) {
        return QVTDirectedValidation.collectAllNestedObjectTemplatesOfRelationExcludingTargetDomain(relation, direction, data);
    }

    public VariableDeclaration getRootVariableOfRelationDomain(RelationDomain relationDomain) {
        return relationDomain.getRootVariable();
    }

    public static List collectAllTemplateVariablesInDirection(Relation relation, TypedModel direction, Object data, QvtProcessorImpl processor) {
        return QVTDirectedValidation.collectAllTemplateVariablesInDirection(relation, direction, data);
    }

    public List collectAllNestedObjectTemplatesOfRelationOfTargetDomain(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            if (!direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllNestedObjectTemplatesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public ObjectTemplateExp getNestedObjectTemplateBindingToVariable(Relation relation, TypedModel direction, Object data, String variable) {
        List nestedObjectTemplatesOfTargetDomain = this.collectAllNestedObjectTemplatesOfRelationOfTargetDomain(relation, direction, data);
        for (ObjectTemplateExp currentTemplate : nestedObjectTemplatesOfTargetDomain) {
            if (!variable.equals(currentTemplate.getBindsTo().getName())) continue;
            return currentTemplate;
        }
        return null;
    }
}

