/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.URLCoder;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;

public class NewUpdateSiteDialog
extends StatusDialog {
    protected Text name;
    protected Text url;
    private Button okButton;
    private boolean enableOK = false;
    private SiteBookmark[] siteBookmarks;

    public NewUpdateSiteDialog(Shell parentShell) {
        super(parentShell);
        this.enableOK = false;
    }

    public NewUpdateSiteDialog(Shell parentShell, SiteBookmark[] siteBookmarks) {
        this(parentShell);
        this.siteBookmarks = siteBookmarks;
    }

    public NewUpdateSiteDialog(Shell parentShell, boolean enableOkButtons) {
        super(parentShell);
        this.enableOK = enableOkButtons;
    }

    public NewUpdateSiteDialog(Shell parentShell, boolean enableOkButtons, SiteBookmark[] siteBookmarks) {
        this(parentShell, enableOkButtons);
        this.siteBookmarks = siteBookmarks;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(this.enableOK);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 350;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(UpdateUIMessages.NewUpdateSiteDialog_name);
        this.name = new Text(composite, 2048);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewUpdateSiteDialog.this.verifyComplete();
            }
        });
        label = new Label(composite, 0);
        label.setText(UpdateUIMessages.NewUpdateSiteDialog_url);
        this.url = new Text(composite, 2048);
        this.url.setLayoutData((Object)new GridData(768));
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewUpdateSiteDialog.this.verifyComplete();
            }
        });
        this.initializeFields();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void initializeFields() {
        this.url.setText("http://");
    }

    protected void okPressed() {
        this.update();
        super.okPressed();
    }

    protected void update() {
        try {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark bookmark = new SiteBookmark(this.name.getText(), new URL(this.url.getText()), false);
            bookmark.setSelected(true);
            model.addBookmark(bookmark);
            model.saveBookmarks();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        if (this.name.getText().trim().length() == 0 || this.url.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, UpdateUI.getPluginId(), 0, UpdateUIMessages.NewUpdateSiteDialog_error_nameOrUrlNotSpecified, null));
            return;
        }
        try {
            URL newURL = new URL(URLCoder.decode(this.url.getText().trim()));
            if (this.url.getEditable()) {
                this.okButton.setEnabled(!newURL.getProtocol().equals("file"));
                if (newURL.getProtocol().equals("file")) {
                    this.okButton.setEnabled(false);
                    this.updateStatus((IStatus)new Status(4, UpdateUI.getPluginId(), 0, UpdateUIMessages.NewUpdateSiteDialog_error_incorrectUrl, null));
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, UpdateUI.getPluginId(), 0, UpdateUIMessages.NewUpdateSiteDialog_error_incorrectUrl, null));
            return;
        }
        if (this.isDuplicate()) {
            return;
        }
        this.okButton.setEnabled(true);
        this.updateStatus((IStatus)new Status(0, UpdateUI.getPluginId(), 0, "", null));
    }

    private boolean isDuplicate() {
        if (this.siteBookmarks == null) {
            return false;
        }
        int i = 0;
        while (i < this.siteBookmarks.length) {
            if (!this.isCurrentlyEditedSiteBookmark(i)) {
                if (this.siteBookmarks[i].getLabel().equals(this.name.getText().trim())) {
                    this.okButton.setEnabled(false);
                    this.updateStatus((IStatus)new Status(4, UpdateUI.getPluginId(), 0, UpdateUIMessages.NewUpdateSiteDialog_error_duplicateName, null));
                    return true;
                }
                if (this.siteBookmarks[i].getURL().toString().trim().equals(this.url.getText().trim())) {
                    this.okButton.setEnabled(false);
                    this.updateStatus((IStatus)new Status(4, UpdateUI.getPluginId(), 0, NLS.bind((String)UpdateUIMessages.NewUpdateSiteDialog_error_duplicateUrl, (Object)this.siteBookmarks[i].getLabel()), null));
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean isCurrentlyEditedSiteBookmark(int index) {
        return false;
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(!status.matches(4));
        }
    }
}

