/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.internal.ui.wizards.SitePage;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.IUpdateSearchCategory;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;

public class InstallWizard
extends Wizard
implements ISearchProvider {
    private ModeSelectionPage modePage;
    private SitePage sitePage;
    private int installCount = 0;
    private UpdateSearchRequest searchRequest;
    private boolean needsRestart;
    private static boolean isRunning;
    private UpdateJob job;
    private InstallWizardOperation operation;

    public InstallWizard(UpdateSearchRequest searchRequest) {
        isRunning = true;
        if (searchRequest == null) {
            searchRequest = new UpdateSearchRequest((IUpdateSearchCategory)new SiteSearchCategory(true), new UpdateSearchScope());
            searchRequest.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        }
        this.searchRequest = searchRequest;
        this.setDialogSettings(UpdateUI.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_UPDATE_WIZ);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUIMessages.InstallWizard_wtitle);
    }

    public InstallWizard(UpdateSearchRequest searchRequest, ArrayList jobs) {
        this(searchRequest);
    }

    public boolean isRestartNeeded() {
        return this.installCount > 0 && this.needsRestart;
    }

    public boolean performCancel() {
        isRunning = false;
        return super.performCancel();
    }

    public void addPages() {
        this.modePage = new ModeSelectionPage(this.searchRequest);
        this.addPage((IWizardPage)this.modePage);
        this.sitePage = new SitePage(this.searchRequest);
        this.addPage((IWizardPage)this.sitePage);
    }

    private void saveSettings() {
        if (this.modePage != null) {
            this.modePage.saveSettings();
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        boolean update;
        if (this.modePage != null && page.equals(this.modePage) && !(update = this.modePage.isUpdateMode())) {
            return this.sitePage;
        }
        return null;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public static synchronized boolean isRunning() {
        return isRunning || Job.getJobManager().find(UpdateJob.FAMILY).length > 0;
    }

    public boolean performFinish() {
        boolean proceed;
        this.saveSettings();
        if (Job.getJobManager().find(UpdateJob.FAMILY).length > 0 && !(proceed = MessageDialog.openQuestion((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUIMessages.InstallWizard_anotherJobTitle, (String)UpdateUIMessages.InstallWizard_anotherJob))) {
            return false;
        }
        UpdateCore.getPlugin().getUpdateSession().reset();
        this.launchInBackground();
        isRunning = false;
        return true;
    }

    private void launchInBackground() {
        this.job = this.isUpdate() ? new UpdateJob(UpdateUIMessages.InstallWizard_jobName, false, false) : new UpdateJob(UpdateUIMessages.InstallWizard_jobName, this.searchRequest);
        this.job.setUser(true);
        this.job.setPriority(10);
        this.getOperation().run(UpdateUI.getActiveWorkbenchShell(), this.job);
    }

    private InstallWizardOperation getOperation() {
        if (this.operation == null) {
            this.operation = new InstallWizardOperation();
        }
        return this.operation;
    }

    public boolean canFinish() {
        if (this.modePage.isCurrentPage()) {
            return this.isUpdate();
        }
        return this.sitePage.isPageComplete();
    }

    private boolean isUpdate() {
        return this.modePage != null && this.modePage.isUpdateMode();
    }
}

