/*
 * Decompiled with CFR 0.152.
 */
package traces.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import traces.presentation.TracesEditorPlugin;
import traces.presentation.TracesEditorPropertySource;
import traces.provider.TracesItemProviderAdapterFactory;

public class TracesEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain domainEditingDomain;
    protected AdapterFactoryEditingDomain mappingsEditingDomain;
    protected AdapterFactoryEditingDomain rangeEditingDomain;
    protected ComposedAdapterFactory domainAdapterFactory;
    protected ComposedAdapterFactory mappingsAdapterFactory;
    protected ComposedAdapterFactory rangeAdapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer domainViewer;
    protected TreeViewer mappingsViewer;
    protected TreeViewer rangeViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == TracesEditor.this.contentOutlinePage) {
                    TracesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)TracesEditor.this);
                    TracesEditor.this.setCurrentViewer((Viewer)TracesEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == TracesEditor.this.propertySheetPage) {
                    TracesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)TracesEditor.this);
                    TracesEditor.this.handleActivate();
                }
            } else if (p == TracesEditor.this) {
                TracesEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).TracesEditor.this.mappingsEditingDomain.getResourceSet();
                        this.changedResources = new ArrayList();
                        this.removedResources = new ArrayList();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    TracesEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!TracesEditor.this.isDirty()) {
                        TracesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TracesEditor.this.getSite().getPage().closeEditor((IEditorPart)TracesEditor.this, false);
                                TracesEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    TracesEditor.this.changedResources.addAll(visitor.getChangedResources());
                }
            }
            catch (CoreException exception) {
                TracesEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    private static final int INITIAL_EXPAND_LEVEL = 6;

    protected void handleActivate() {
        if (this.mappingsEditingDomain.getResourceToReadOnlyMap() != null) {
            this.mappingsEditingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.mappingsEditingDomain.getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    TracesEditorPlugin.INSTANCE.log(exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)TracesEditor.getString("_UI_FileConflict_label"), (String)TracesEditor.getString("_WARN_FileConflict"));
    }

    public TracesEditor() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new TracesItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.domainAdapterFactory = new ComposedAdapterFactory(factories);
        this.mappingsAdapterFactory = new ComposedAdapterFactory(factories);
        this.rangeAdapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                TracesEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TracesEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            TracesEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).TracesEditor.this.propertySheetPage != null) {
                            (this).TracesEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.domainEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.domainAdapterFactory, (CommandStack)commandStack, new HashMap());
        this.mappingsEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.mappingsAdapterFactory, (CommandStack)commandStack, new HashMap());
        this.rangeEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.rangeAdapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
        if (this.domainViewer != null) {
            this.domainViewer.refresh();
        }
        if (this.mappingsViewer != null) {
            this.mappingsViewer.refresh();
        }
        if (this.rangeViewer != null) {
            this.rangeViewer.refresh();
        }
        if (this.contentOutlineViewer != null) {
            this.contentOutlineViewer.refresh();
        }
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (TracesEditor.this.currentViewer != null) {
                        TracesEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), false);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.mappingsEditingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        TracesEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.mappingsEditingDomain, (Viewer)viewer));
    }

    public void createModel() {
        IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
        try {
            this.mappingsEditingDomain.loadResource(URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()).toString());
        }
        catch (Exception exception) {
            TracesEditorPlugin.INSTANCE.log(exception);
        }
        EList rootList = ((Resource)this.mappingsEditingDomain.getResourceSet().getResources().get(0)).getContents();
        if (rootList.size() > 0) {
            EObject root = (EObject)rootList.get(0);
            EList domainFilesURIs = (EList)root.eGet(root.eClass().getEStructuralFeature("domainModels"));
            EList rangeFilesURIs = (EList)root.eGet(root.eClass().getEStructuralFeature("targetModels"));
            try {
                for (URI uri : domainFilesURIs) {
                    this.domainEditingDomain.loadResource(uri.toString());
                }
                for (URI uri : rangeFilesURIs) {
                    this.rangeEditingDomain.loadResource(uri.toString());
                }
            }
            catch (Exception exception) {
                TracesEditorPlugin.INSTANCE.log(exception);
            }
        } else {
            MessageDialog.openError(null, (String)"Unable to load metamodel", (String)"There was an error when trying to load traceability model.\n(Traceability metamodel not loaded in EMF).");
        }
    }

    private String composePaths(String project, String domainFile) {
        String[] domainPathSegments = domainFile.split("/");
        String resultPath = project;
        int i = 0;
        while (i < domainPathSegments.length) {
            resultPath = domainPathSegments[i].equals("..") ? resultPath.substring(0, resultPath.lastIndexOf("/")) : String.valueOf(resultPath) + "/" + domainPathSegments[i];
            ++i;
        }
        return resultPath;
    }

    public void createPages() {
        this.createModel();
        SashForm compositePage = new SashForm(this.getContainer(), 512);
        SashForm topSashForm = new SashForm((Composite)compositePage, 256);
        ViewerPane domainViewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                TracesEditor.this.setCurrentViewerPane(this);
            }
        };
        domainViewerPane.createControl((Composite)topSashForm);
        this.domainViewer = (TreeViewer)domainViewerPane.getViewer();
        this.domainViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.domainAdapterFactory));
        this.domainViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.domainAdapterFactory));
        this.domainViewer.setInput((Object)this.domainEditingDomain.getResourceSet());
        domainViewerPane.setTitle((Object)" Domain");
        this.domainViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TracesEditor.this.handleDomainSelection(event.getSelection());
            }
        });
        new AdapterFactoryTreeEditor(this.domainViewer.getTree(), (AdapterFactory)this.domainAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.domainViewer);
        ViewerPane mappingsViewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                TracesEditor.this.setCurrentViewerPane(this);
            }
        };
        mappingsViewerPane.createControl((Composite)topSashForm);
        this.mappingsViewer = (TreeViewer)mappingsViewerPane.getViewer();
        this.mappingsViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.mappingsAdapterFactory));
        this.mappingsViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.mappingsAdapterFactory));
        this.mappingsViewer.setInput((Object)this.mappingsEditingDomain.getResourceSet());
        mappingsViewerPane.setTitle((Object)" Mappings");
        this.mappingsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TracesEditor.this.handleMappingsSelection(event.getSelection());
            }
        });
        new AdapterFactoryTreeEditor(this.mappingsViewer.getTree(), (AdapterFactory)this.mappingsAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.mappingsViewer);
        ViewerPane rangeViewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                TracesEditor.this.setCurrentViewerPane(this);
            }
        };
        rangeViewerPane.createControl((Composite)topSashForm);
        this.rangeViewer = (TreeViewer)rangeViewerPane.getViewer();
        this.rangeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.rangeAdapterFactory));
        this.rangeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.rangeAdapterFactory));
        this.rangeViewer.setInput((Object)this.rangeEditingDomain.getResourceSet());
        rangeViewerPane.setTitle((Object)" Range");
        this.rangeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TracesEditor.this.handleRangeSelection(event.getSelection());
            }
        });
        new AdapterFactoryTreeEditor(this.rangeViewer.getTree(), (AdapterFactory)this.rangeAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.rangeViewer);
        int pageIndex = this.addPage((Control)compositePage);
        this.setPageText(pageIndex, TracesEditor.getString("_UI_SelectionPage_label"));
        this.domainViewer.expandToLevel(6);
        this.mappingsViewer.expandToLevel(6);
        this.rangeViewer.expandToLevel(6);
        this.setActivePage(0);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    TracesEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        Control control = this.getControl(pageIndex);
        if (control != null) {
            control.setVisible(true);
            control.setFocus();
        }
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    TracesEditor.this.contentOutlineViewer = this.getTreeViewer();
                    TracesEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    TracesEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)TracesEditor.this.mappingsAdapterFactory));
                    TracesEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)TracesEditor.this.mappingsAdapterFactory));
                    TracesEditor.this.contentOutlineViewer.setInput((Object)TracesEditor.this.mappingsEditingDomain.getResourceSet());
                    TracesEditor.this.createContextMenuFor((StructuredViewer)TracesEditor.this.contentOutlineViewer);
                    if (!TracesEditor.this.mappingsEditingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<ResourceSet> selection = new ArrayList<ResourceSet>();
                        selection.add(TracesEditor.this.mappingsEditingDomain.getResourceSet());
                        TracesEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                        TracesEditor.this.contentOutlineViewer.expandToLevel(6);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    TracesEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    TracesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TracesEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    TracesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new TracesEditorPropertySource((AdapterFactory)this.mappingsAdapterFactory, (EditingDomain)this.mappingsEditingDomain, (EditingDomain)this.domainEditingDomain, (EditingDomain)this.rangeEditingDomain));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.mappingsViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public void handleMappingsSelection(ISelection selection) {
        if (this.currentViewerPane != null && !selection.isEmpty() && this.mappingsViewer.getControl().isFocusControl() && selection instanceof IStructuredSelection) {
            ArrayList<EObject> rangeSelectionList = new ArrayList<EObject>();
            ArrayList<EObject> domainSelectionList = new ArrayList<EObject>();
            for (Object selectedElement : (IStructuredSelection)selection) {
                ListIterator it;
                if (!(selectedElement instanceof EObject)) continue;
                EObject eoselElem = (EObject)selectedElement;
                if (eoselElem.eClass().getEStructuralFeature("manipulationRule") != null) {
                    String cfr_ignored_0 = (String)eoselElem.eGet(eoselElem.eClass().getEStructuralFeature("manipulationRule"));
                }
                if (eoselElem.eClass().getEStructuralFeature("domain") != null) {
                    List selDomain = (List)eoselElem.eGet(eoselElem.eClass().getEStructuralFeature("domain"));
                    it = selDomain.listIterator();
                    while (it.hasNext()) {
                        domainSelectionList.add(this.domainEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((EObject)it.next())), true));
                    }
                }
                if (eoselElem.eClass().getEStructuralFeature("range") == null) continue;
                List selRange = (List)eoselElem.eGet(eoselElem.eClass().getEStructuralFeature("range"));
                it = selRange.listIterator();
                while (it.hasNext()) {
                    rangeSelectionList.add(this.rangeEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((EObject)it.next())), true));
                }
            }
            this.rangeViewer.setSelection((ISelection)new StructuredSelection(rangeSelectionList));
            this.domainViewer.setSelection((ISelection)new StructuredSelection(domainSelectionList));
        }
    }

    public void handleDomainSelection(ISelection selection) {
        if (this.currentViewerPane != null && !selection.isEmpty() && this.domainViewer.getControl().isFocusControl() && selection instanceof IStructuredSelection) {
            ArrayList<EObject> mappingsSelectionList = new ArrayList<EObject>();
            ArrayList<EObject> rangeSelectionList = new ArrayList<EObject>();
            for (Object selectedElement : (IStructuredSelection)selection) {
                if (!(selectedElement instanceof EObject)) continue;
                EObject eoselElem = (EObject)selectedElement;
                TreeIterator it_mps = ((Resource)this.mappingsEditingDomain.getResourceSet().getResources().get(0)).getAllContents();
                while (it_mps.hasNext()) {
                    List eltsMappDom;
                    EObject obj = (EObject)it_mps.next();
                    if (obj.eClass().getEStructuralFeature("domain") == null || !(eltsMappDom = (List)obj.eGet(obj.eClass().getEStructuralFeature("domain"))).contains(this.mappingsEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)eoselElem), true))) continue;
                    mappingsSelectionList.add(obj);
                    List eltsMappRange = (List)obj.eGet(obj.eClass().getEStructuralFeature("range"));
                    ListIterator it = eltsMappRange.listIterator();
                    while (it.hasNext()) {
                        rangeSelectionList.add(this.rangeEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((EObject)it.next())), true));
                    }
                }
            }
            this.rangeViewer.setSelection((ISelection)new StructuredSelection(rangeSelectionList));
            this.mappingsViewer.setSelection((ISelection)new StructuredSelection(mappingsSelectionList));
        }
    }

    public void handleRangeSelection(ISelection selection) {
        if (this.currentViewerPane != null && !selection.isEmpty() && this.rangeViewer.getControl().isFocusControl() && selection instanceof IStructuredSelection) {
            ArrayList<EObject> mappingsSelectionList = new ArrayList<EObject>();
            ArrayList<EObject> domainSelectionList = new ArrayList<EObject>();
            for (Object selectedElement : (IStructuredSelection)selection) {
                if (!(selectedElement instanceof EObject)) continue;
                EObject eoselElem = (EObject)selectedElement;
                TreeIterator it_mps = ((Resource)this.mappingsEditingDomain.getResourceSet().getResources().get(0)).getAllContents();
                while (it_mps.hasNext()) {
                    List eltsMappRange;
                    EObject obj = (EObject)it_mps.next();
                    if (obj.eClass().getEStructuralFeature("range") == null || !(eltsMappRange = (List)obj.eGet(obj.eClass().getEStructuralFeature("range"))).contains(this.mappingsEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)eoselElem), true))) continue;
                    mappingsSelectionList.add(obj);
                    List eltsMappDom = (List)obj.eGet(obj.eClass().getEStructuralFeature("domain"));
                    ListIterator it = eltsMappDom.listIterator();
                    while (it.hasNext()) {
                        domainSelectionList.add(this.domainEditingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((EObject)it.next())), true));
                    }
                }
            }
            this.domainViewer.setSelection((ISelection)new StructuredSelection(domainSelectionList));
            this.mappingsViewer.setSelection((ISelection)new StructuredSelection(mappingsSelectionList));
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.mappingsEditingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    Resource savedResource = (Resource)TracesEditor.this.mappingsEditingDomain.getResourceSet().getResources().get(0);
                    TracesEditor.this.savedResources.add(savedResource);
                    savedResource.save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    TracesEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.mappingsEditingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            TracesEditorPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString()), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.mappingsEditingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInput(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.mappingsEditingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.mappingsEditingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            TracesEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(TracesEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.mappingsAdapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(TracesEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(TracesEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return TracesEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return TracesEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.mappingsAdapterFactory;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.mappingsAdapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

