/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.Chevron;
import org.eclipse.help.ui.internal.views.ComboPart;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.HistoryScopeSet;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.help.ui.internal.views.ScopePreferenceDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetDialog;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.help.ui.internal.views.SearchResultsPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SearchPart
extends AbstractFormPart
implements IHelpPart,
IHelpUIConstants {
    private ReusableHelpPart parent;
    protected static List previousSearchQueryData = new ArrayList(20);
    private static final String HREF_TOGGLE = "__toggle__";
    private static final String HREF_SEARCH_HELP = "/org.eclipse.platform.doc.user/tasks/tsearch.htm";
    private static boolean SEARCH_HELP_AVAILABLE = false;
    private String id;
    private Composite container;
    private Composite filteringGroup;
    private FormText searchWordText;
    private Chevron searchWordChevron;
    private ComboPart searchWordCombo;
    private Section scopeSection;
    private Button goButton;
    private Button shellDefaultButton;
    private Hyperlink scopeSetLink;
    private Hyperlink advancedLink;
    private Observer engineObserver;
    private ScopeSetManager scopeSetManager;
    private static final int COMBO_HISTORY_SIZE = 10;
    private JobListener jobListener;
    private boolean searchPending;

    static {
        InputStream is = HelpSystem.getHelpContent((String)HREF_SEARCH_HELP);
        if (is != null) {
            try {
                is.close();
                SEARCH_HELP_AVAILABLE = true;
            }
            catch (IOException iOException) {}
        }
    }

    public SearchPart(final Composite parent, FormToolkit toolkit) {
        this.container = toolkit.createComposite(parent);
        this.scopeSetManager = new ScopeSetManager();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.searchWordText = toolkit.createFormText(this.container, false);
        this.searchWordChevron = new Chevron((Composite)this.searchWordText, 0);
        toolkit.adapt((Control)this.searchWordChevron, true, true);
        this.searchWordChevron.setHoverDecorationColor(toolkit.getHyperlinkGroup().getActiveForeground());
        this.searchWordChevron.setDecorationColor(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.searchWordText.setControl(HREF_TOGGLE, (Control)this.searchWordChevron);
        this.searchWordText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.parent.showURL(SearchPart.HREF_SEARCH_HELP, true);
            }
        });
        this.searchWordChevron.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                parent.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SearchPart.access$4(2.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ SearchPart access$0(2 var0) {
                return var0.SearchPart.this;
            }
        });
        this.searchWordText.setImage("etool16/help.gif", HelpUIResources.getImage("etool16/help.gif"));
        this.updateSearchWordText();
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        this.searchWordText.setLayoutData((Object)td);
        this.searchWordCombo = new ComboPart(this.container, toolkit, toolkit.getBorderStyle());
        this.updateSearchCombo(null);
        td = new TableWrapData(256);
        td.maxWidth = 100;
        td.valign = 32;
        this.searchWordCombo.getControl().setLayoutData((Object)td);
        this.searchWordCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchPart.this.searchWordCombo.getSelectionIndex() < 0) {
                    return;
                }
                SearchPart.this.searchFromHistory(SearchPart.this.searchWordCombo.getSelectionIndex());
            }
        });
        this.goButton = toolkit.createButton(this.container, Messages.SearchPart_go, 8);
        this.goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPart.this.handleButtonPressed();
            }
        });
        this.goButton.setEnabled(false);
        this.searchWordCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPart.this.goButton.setEnabled(SearchPart.this.searchWordCombo.getText().length() > 0);
            }
        });
        this.searchWordCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && SearchPart.this.goButton.isEnabled()) {
                    SearchPart.this.doSearch(SearchPart.this.searchWordCombo.getText());
                }
            }
        });
        this.searchWordCombo.getControl().addListener(15, new Listener(){

            public void handleEvent(Event event) {
                SearchPart.this.shellDefaultButton = null;
                Shell shell = SearchPart.this.searchWordCombo.getControl().getShell();
                Button button = shell.getDefaultButton();
                if (button != null) {
                    SearchPart.this.shellDefaultButton = button;
                    shell.setDefaultButton(SearchPart.this.goButton);
                }
            }
        });
        this.searchWordCombo.getControl().addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (SearchPart.this.shellDefaultButton != null) {
                    Shell shell = SearchPart.this.searchWordCombo.getControl().getShell();
                    shell.setDefaultButton(SearchPart.this.shellDefaultButton);
                    SearchPart.this.shellDefaultButton = null;
                }
            }
        });
        this.scopeSection = toolkit.createSection(this.container, 8226);
        this.scopeSection.setText(Messages.limit_to);
        td = new TableWrapData();
        td.colspan = 2;
        td.align = 128;
        this.scopeSection.setLayoutData((Object)td);
        this.filteringGroup = toolkit.createComposite((Composite)this.scopeSection);
        this.scopeSection.setClient((Control)this.filteringGroup);
        TableWrapLayout flayout = new TableWrapLayout();
        flayout.numColumns = 2;
        this.filteringGroup.setLayout((Layout)flayout);
        this.createScopeSet(this.scopeSection, toolkit);
        toolkit.paintBordersFor(this.filteringGroup);
        toolkit.paintBordersFor(this.container);
        this.jobListener = new JobListener();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    private void createAdvancedLink(Composite parent, FormToolkit toolkit) {
        this.advancedLink = toolkit.createHyperlink(parent, Messages.FederatedSearchPart_advanced, 0);
        this.advancedLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.doAdvanced();
            }
        });
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        this.advancedLink.setLayoutData((Object)td);
    }

    private void createScopeSet(Section section, FormToolkit toolkit) {
        this.scopeSetLink = toolkit.createHyperlink((Composite)section, null, 0);
        this.scopeSetLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.doChangeScopeSet();
            }
        });
        this.scopeSetLink.setToolTipText(Messages.FederatedSearchPart_changeScopeSet);
        section.setTextClient((Control)this.scopeSetLink);
        ScopeSet active = this.scopeSetManager.getActiveSet();
        this.setActiveScopeSet(active);
    }

    private void toggleSearchWordText() {
        this.updateSearchWordText();
        this.parent.reflow();
    }

    private void updateSearchWordText() {
        StringBuffer buff = new StringBuffer();
        buff.append("<form>");
        buff.append("<p>");
        buff.append(Messages.expression);
        if (this.searchWordChevron.isExpanded()) {
            this.searchWordChevron.setToolTipText(Messages.SearchPart_collapse);
            buff.append("<control href=\"");
            buff.append(HREF_TOGGLE);
            buff.append("\"/>");
            buff.append("</p><p>");
            buff.append(Messages.expression_label);
            if (SEARCH_HELP_AVAILABLE) {
                buff.append("</p><p>");
                buff.append("<img href=\"");
                buff.append("etool16/help.gif");
                buff.append("\"/> ");
                buff.append("<a href=\"");
                buff.append(HREF_SEARCH_HELP);
                buff.append("\">");
                buff.append(Messages.SearchPart_learnMore);
                buff.append("</a>");
            }
        } else {
            this.searchWordChevron.setToolTipText(Messages.SearchPart_expand);
            buff.append("<control href=\"");
            buff.append(HREF_TOGGLE);
            buff.append("\"/>");
        }
        buff.append("</p>");
        buff.append("</form>");
        this.searchWordText.setText(buff.toString(), true, false);
    }

    private void setActiveScopeSet(ScopeSet set) {
        this.scopeSetLink.setText(set.getName());
        this.scopeSetManager.setActiveSet(set);
        this.updateMasters(set);
        this.scopeSection.layout();
        if (this.parent != null) {
            this.parent.reflow();
        }
    }

    private void updateMasters(ScopeSet set) {
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        int i = 0;
        while (i < children.length) {
            Button master;
            Object data;
            Control child = children[i];
            if (child instanceof Button && (data = (master = (Button)child).getData()) != null && data instanceof EngineDescriptor) {
                EngineDescriptor ed = (EngineDescriptor)data;
                master.setSelection(set.getEngineEnabled(ed));
            }
            ++i;
        }
    }

    private void loadEngines(final Composite container, final FormToolkit toolkit) {
        EngineDescriptorManager descManager = this.parent.getEngineManager();
        EngineDescriptor[] descriptors = descManager.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            EngineDescriptor desc = descriptors[i];
            this.loadEngine(desc, container, toolkit);
            ++i;
        }
        this.engineObserver = new Observer(){

            public void update(Observable o, Object arg) {
                EngineDescriptorManager.DescriptorEvent event = (EngineDescriptorManager.DescriptorEvent)arg;
                int kind = event.getKind();
                EngineDescriptor desc = event.getDescriptor();
                if (kind == 1) {
                    SearchPart.this.advancedLink.dispose();
                    SearchPart.this.loadEngine(desc, container, toolkit);
                    SearchPart.this.createAdvancedLink(container, toolkit);
                    SearchPart.this.parent.reflow();
                } else if (kind == 2) {
                    SearchPart.this.removeEngine(desc);
                } else {
                    SearchPart.this.updateEngine(desc);
                }
            }
        };
        descManager.addObserver(this.engineObserver);
        this.updateMasters(this.scopeSetManager.getActiveSet());
    }

    private EngineDescriptor loadEngine(final EngineDescriptor edesc, Composite container, FormToolkit toolkit) {
        Label ilabel = toolkit.createLabel(container, null);
        ilabel.setImage(edesc.getIconImage());
        ilabel.setData((Object)edesc);
        final Button master = toolkit.createButton(container, edesc.getLabel(), 32);
        master.setData((Object)edesc);
        master.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPart.this.scopeSetManager.getActiveSet().setEngineEnabled(edesc, master.getSelection());
            }
        });
        String desc = edesc.getDescription();
        if (desc != null) {
            Label spacer = toolkit.createLabel(container, null);
            spacer.setData((Object)edesc);
            Label dlabel = toolkit.createLabel(container, desc, 64);
            dlabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            dlabel.setLayoutData((Object)new TableWrapData(256));
            dlabel.setMenu(container.getMenu());
            dlabel.setData((Object)edesc);
        }
        return edesc;
    }

    private void removeEngine(EngineDescriptor desc) {
        boolean reflowNeeded = false;
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            EngineDescriptor ed = (EngineDescriptor)child.getData();
            if (ed == desc) {
                child.setMenu(null);
                child.dispose();
                reflowNeeded = true;
            }
            ++i;
        }
        if (reflowNeeded) {
            this.parent.reflow();
        }
    }

    private void updateEngine(EngineDescriptor desc) {
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        boolean reflowNeeded = false;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            EngineDescriptor ed = (EngineDescriptor)child.getData();
            if (ed == desc) {
                Button b = (Button)children[i + 1];
                b.setText(desc.getLabel());
                Label d = (Label)children[i + 3];
                d.setText(desc.getDescription());
                d.getParent().layout();
                reflowNeeded = true;
                break;
            }
            ++i;
        }
        if (reflowNeeded) {
            this.parent.reflow();
        }
    }

    public void startSearch(String text) {
        this.searchWordCombo.setText(text);
        this.doSearch(text);
    }

    private void storeSearchHistory(String expression) {
        HistoryScopeSet sset = this.scopeSetManager.findSearchSet(expression);
        if (sset == null) {
            sset = new HistoryScopeSet(expression);
            this.scopeSetManager.add(sset);
        }
        ScopeSet activeSet = this.scopeSetManager.getActiveSet();
        sset.copyFrom(activeSet);
        sset.save();
        this.updateSearchCombo(sset);
        this.searchWordCombo.setText(expression);
    }

    private void updateSearchCombo(HistoryScopeSet current) {
        HistoryScopeSet sset;
        ScopeSet[] sets = this.scopeSetManager.getScopeSets(true);
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<HistoryScopeSet> toDelete = new ArrayList<HistoryScopeSet>();
        int i = sets.length - 1;
        while (i >= 0) {
            sset = (HistoryScopeSet)sets[i];
            if (current == null || sset != current) {
                if (sets.length - i > 10) {
                    toDelete.add(sset);
                }
                items.add(sset.getExpression());
            }
            --i;
        }
        i = 0;
        while (i < toDelete.size()) {
            sset = (HistoryScopeSet)toDelete.get(i);
            this.scopeSetManager.remove(sset);
            ++i;
        }
        if (items.size() > 0) {
            this.searchWordCombo.setItems(items.toArray(new String[items.size()]));
        }
    }

    private void searchFromHistory(int index) {
        String expression = this.searchWordCombo.getSelection();
        HistoryScopeSet set = this.scopeSetManager.findSearchSet(expression);
        if (set == null) {
            return;
        }
        this.setActiveScopeSet(set);
        this.doSearch(expression, true);
    }

    private void handleButtonPressed() {
        if (this.searchWordCombo.getControl().isEnabled()) {
            this.doSearch(this.searchWordCombo.getText());
        } else {
            this.goButton.setEnabled(false);
            this.stop();
        }
    }

    private void doSearch(String text) {
        this.doSearch(text, false);
    }

    private void doSearch(String text, boolean fromHistory) {
        String setExpression;
        ScopeSet set = this.scopeSetManager.getActiveSet();
        if (!fromHistory && set instanceof HistoryScopeSet && (setExpression = ((HistoryScopeSet)set).getExpression()).equals(text)) {
            fromHistory = true;
        }
        if (!fromHistory) {
            this.storeSearchHistory(text);
            boolean switchedSet = this.scopeSetManager.restoreLastExplicitSet();
            set = this.scopeSetManager.getActiveSet();
            if (switchedSet) {
                this.setActiveScopeSet(set);
            }
        }
        ArrayList<FederatedSearchEntry> entries = new ArrayList<FederatedSearchEntry>();
        final SearchResultsPart results = (SearchResultsPart)this.parent.findPart("fsearch-result");
        ArrayList<EngineDescriptor> eds = new ArrayList<EngineDescriptor>();
        EngineDescriptor[] engineDescriptors = this.parent.getEngineManager().getDescriptors();
        int i = 0;
        while (i < engineDescriptors.length) {
            final EngineDescriptor ed = engineDescriptors[i];
            if (set.getEngineEnabled(ed) && ed.getEngine() != null) {
                ISearchScope scope = ed.createSearchScope(set.getPreferenceStore());
                FederatedSearchEntry entry = new FederatedSearchEntry(ed.getId(), ed.getLabel(), scope, ed.getEngine(), new ISearchEngineResultCollector(){

                    public void accept(ISearchEngineResult searchResult) {
                        results.add(ed, searchResult);
                    }

                    public void accept(ISearchEngineResult[] searchResults) {
                        results.add(ed, searchResults);
                    }

                    public void error(IStatus status) {
                        results.error(ed, status);
                    }
                });
                entries.add(entry);
                eds.add(ed);
            }
            ++i;
        }
        if (entries.size() == 0) {
            return;
        }
        FederatedSearchEntry[] array = entries.toArray(new FederatedSearchEntry[entries.size()]);
        if (this.scopeSection.isExpanded()) {
            this.scopeSection.setExpanded(false);
            this.parent.reflow();
        }
        results.clearResults();
        results.startNewSearch(text, eds);
        BaseHelpSystem.getSearchManager().search(text, array);
    }

    private void doAdvanced() {
        ScopeSet set = this.scopeSetManager.getActiveSet();
        ScopePreferenceManager manager = new ScopePreferenceManager(this.parent.getEngineManager(), set);
        ScopePreferenceDialog dialog = new ScopePreferenceDialog(this.container.getShell(), manager, this.parent.getEngineManager(), set.isEditable());
        dialog.setPreferenceStore(set.getPreferenceStore());
        dialog.create();
        dialog.getShell().setText(NLS.bind((String)Messages.ScopePreferenceDialog_wtitle, (Object)set.getName()));
        dialog.open();
        this.updateMasters(set);
    }

    private void doChangeScopeSet() {
        ScopeSet set;
        ScopeSetDialog dialog = new ScopeSetDialog(this.container.getShell(), this.scopeSetManager, this.parent.getEngineManager());
        dialog.setInput(this.scopeSetManager);
        dialog.create();
        dialog.getShell().setText(Messages.ScopeSetDialog_wtitle);
        if (dialog.open() == 0 && (set = dialog.getActiveSet()) != null) {
            this.setActiveScopeSet(set);
        }
    }

    public void dispose() {
        ScopeSet activeSet = this.scopeSetManager.getActiveSet();
        if (activeSet != null) {
            activeSet.save();
        }
        if (this.engineObserver != null) {
            this.parent.getEngineManager().deleteObserver(this.engineObserver);
            this.engineObserver = null;
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
        this.stop();
        super.dispose();
    }

    public Control getControl() {
        return this.container;
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        this.loadEngines(this.filteringGroup, parent.getForm().getToolkit());
        this.createAdvancedLink(this.filteringGroup, parent.getForm().getToolkit());
        parent.hookFormText(this.searchWordText);
        if (memento != null) {
            this.restorePart(memento);
        }
    }

    private void restorePart(IMemento memento) {
        String expression;
        ScopeSet sset;
        String setName = memento.getString("activeSet");
        if (setName != null && (sset = this.scopeSetManager.findSet(setName)) != null) {
            this.scopeSetManager.setActiveSet(sset);
        }
        if ((expression = memento.getString("expression")) != null && expression.length() > 0) {
            this.searchWordCombo.setText(expression);
            this.searchPending = true;
            this.markStale();
        }
    }

    public void refresh() {
        super.refresh();
        if (this.searchPending) {
            this.searchPending = false;
            this.doSearch(this.searchWordCombo.getText());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillFormContextMenu(this.searchWordText, manager);
    }

    public boolean hasFocusControl(Control control) {
        return control == this.searchWordText || control == this.searchWordCombo.getControl() || this.scopeSection.getClient() == control;
    }

    public void setFocus() {
        this.searchWordCombo.getControl().setFocus();
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    public void stop() {
        SearchResultsPart results = (SearchResultsPart)this.parent.findPart("fsearch-result");
        results.canceling();
        Job.getJobManager().cancel((Object)"org.eclipse.help.base.searchEngine");
    }

    public void toggleRoleFilter() {
    }

    public void refilter() {
    }

    public void saveState(IMemento memento) {
        ScopeSet sset = this.scopeSetManager.getActiveSet();
        if (sset != null) {
            memento.putString("activeSet", sset.getName());
        }
        memento.putString("expression", this.searchWordCombo.getText());
    }

    static /* synthetic */ void access$4(SearchPart searchPart) {
        searchPart.toggleSearchWordText();
    }

    private class JobListener
    implements IJobChangeListener,
    Runnable {
        private boolean searchInProgress = false;

        private JobListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            Job[] searchJobs;
            if (event.getJob().belongsTo((Object)"org.eclipse.help.base.searchEngine") && (searchJobs = Job.getJobManager().find((Object)"org.eclipse.help.base.searchEngine")).length == 0) {
                this.searchInProgress = false;
                if (SearchPart.this.container.isDisposed()) {
                    return;
                }
                SearchPart.this.container.getDisplay().asyncExec((Runnable)this);
                SearchResultsPart results = (SearchResultsPart)SearchPart.this.parent.findPart("fsearch-result");
                results.completed();
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
            if (!this.searchInProgress && event.getJob().belongsTo((Object)"org.eclipse.help.base.searchEngine")) {
                this.searchInProgress = true;
                SearchPart.this.container.getDisplay().asyncExec((Runnable)this);
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }

        public void run() {
            SearchPart.this.searchWordCombo.getControl().setEnabled(!this.searchInProgress);
            if (!this.searchInProgress) {
                SearchPart.this.goButton.setEnabled(true);
            }
            if (this.searchInProgress) {
                SearchPart.this.goButton.setText(Messages.SearchPart_stop);
            } else {
                SearchPart.this.goButton.setText(Messages.SearchPart_go);
            }
            SearchPart.this.parent.getForm().getForm().setBusy(this.searchInProgress);
            SearchPart.this.goButton.getParent().layout();
        }
    }
}

