/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.xmi;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.xmi.AdapterFactoryRegister;
import uk.ac.kent.cs.kmf.xmi.IWriterAdapter;
import uk.ac.kent.cs.kmf.xmi.IXMIElement;
import uk.ac.kent.cs.kmf.xmi.IXMIFile;
import uk.ac.kent.cs.kmf.xmi.IXMIWriter;
import uk.ac.kent.cs.kmf.xmi.XMIFile;

public class XMIWriter
implements IXMIWriter {
    protected IXMIFile xmiFile;
    protected String xmiFileName;
    protected PrintWriter out;
    protected ILog _log;
    protected IWriterAdapter writerAdapter = AdapterFactoryRegister.getAdapterFactory().createWriterAdapter();

    public void write(IXMIFile xmiFile, String xmiFileName, ILog log) throws Exception {
        this.xmiFile = xmiFile;
        this.xmiFileName = xmiFileName;
        this.out = new PrintWriter((Writer)new FileWriter(xmiFileName), true);
        this._log = null;
        this.write();
    }

    protected void write() throws Exception {
        this.out.print("<?xml version=\"1.0\"");
        String encoding = this.xmiFile.getEncoding();
        if (encoding != null && !encoding.equals("")) {
            this.out.print(" encoding=\"" + encoding + "\"");
        }
        this.out.print("?>");
        this.out.println();
        String[] atts = new String[]{"version", this.xmiFile.getXMIVersion(), "timestamp", this.xmiFile.getTimestamp(), "verified", "" + this.xmiFile.getVerified()};
        this.writerAdapter.printStartElement(this.out, 0, "XMI", atts, false);
        this.out.println();
        this.writeHeader(this.out, 0);
        this.writeContent(this.out, 0);
        this.writerAdapter.printEndElement(this.out, 0, "XMI");
        this.out.println();
    }

    protected void writeHeader(PrintWriter out, int indent) throws Exception {
        if (this.xmiFile.hasHeader()) {
            Object model;
            Iterator it;
            List list;
            this.writerAdapter.printStartElement(out, indent + 1, "XMI.header", new String[0], false);
            out.println();
            if (this.xmiFile.hasDocumentation()) {
                this.writerAdapter.printStartElement(out, indent + 2, "XMI.documentation", new String[0], false);
                out.println();
                if (this.xmiFile.getOwner() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.owner", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getOwner());
                    this.writerAdapter.printEndElement(out, 0, "XMI.owner");
                    out.println();
                }
                if (this.xmiFile.getContact() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.contact", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getContact());
                    this.writerAdapter.printEndElement(out, 0, "XMI.contact");
                    out.println();
                }
                if (this.xmiFile.getLongDescription() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.longDescription", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getLongDescription());
                    this.writerAdapter.printEndElement(out, 0, "XMI.longDescription");
                    out.println();
                }
                if (this.xmiFile.getShortDescription() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.shortDescription", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getShortDescription());
                    this.writerAdapter.printEndElement(out, 0, "XMI.shortDescription");
                    out.println();
                }
                if (this.xmiFile.getExporter() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.exporter", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getExporter());
                    this.writerAdapter.printEndElement(out, 0, "XMI.exporter");
                    out.println();
                }
                if (this.xmiFile.getExporterVersion() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.exporterVersion", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getExporterVersion());
                    this.writerAdapter.printEndElement(out, 0, "XMI.exporterVersion");
                    out.println();
                }
                if (this.xmiFile.getNotice() != null) {
                    this.writerAdapter.printStartElement(out, indent + 3, "XMI.notice", new String[0], false);
                    this.writerAdapter.printText(out, 0, this.xmiFile.getNotice());
                    this.writerAdapter.printEndElement(out, 0, "XMI.notice");
                    out.println();
                }
                this.writerAdapter.printEndElement(out, indent + 2, "XMI.documentation");
                out.println();
            }
            if (this.xmiFile.hasModels()) {
                list = this.xmiFile.getModels();
                it = list.iterator();
                while (it.hasNext()) {
                    model = (XMIFile.Model)it.next();
                    this.writerAdapter.printStartElement(out, indent + 2, "XMI.model", new String[0], false);
                    this.writerAdapter.printEndElement(out, indent + 2, "XMI.model");
                    out.println();
                }
            }
            if (this.xmiFile.hasMetamodels()) {
                list = this.xmiFile.getMetamodels();
                it = list.iterator();
                while (it.hasNext()) {
                    model = (XMIFile.Metamodel)it.next();
                    this.writerAdapter.printStartElement(out, indent + 2, "XMI.metamodel", new String[0], false);
                    this.writerAdapter.printEndElement(out, indent + 2, "XMI.metamodel");
                    out.println();
                }
            }
            if (this.xmiFile.hasMetametamodels()) {
                list = this.xmiFile.getMetametamodels();
                it = list.iterator();
                while (it.hasNext()) {
                    model = (XMIFile.Metametamodel)it.next();
                    this.writerAdapter.printStartElement(out, indent + 2, "XMI.metametamodel", new String[0], false);
                    this.writerAdapter.printEndElement(out, indent + 2, "XMI.metametamodel");
                    out.println();
                }
            }
            if (this.xmiFile.hasImports()) {
                list = this.xmiFile.getImports();
                it = list.iterator();
                while (it.hasNext()) {
                    model = (XMIFile.Import)it.next();
                    this.writerAdapter.printStartElement(out, indent + 2, "XMI.metametamodel", new String[0], false);
                    this.writerAdapter.printEndElement(out, indent + 2, "XMI.metametamodel");
                    out.println();
                }
            }
            this.writerAdapter.printEndElement(out, indent + 1, "XMI.header");
            out.println();
        }
    }

    protected void writeContent(PrintWriter out, int indent) throws Exception {
        this.writerAdapter.printStartElement(out, indent + 1, "XMI.content", new String[0], false);
        out.println();
        Collection objs = this.xmiFile.getTopObjects();
        Iterator i = objs.iterator();
        while (i.hasNext()) {
            IXMIElement obj = (IXMIElement)i.next();
            this.writerAdapter.printXMIElement(out, indent + 1, obj);
        }
        this.writerAdapter.printEndElement(out, indent + 1, "XMI.content");
        out.println();
    }
}

