/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.xmi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.xmi.AdapterFactoryRegister;
import uk.ac.kent.cs.kmf.xmi.FeatureInfo;
import uk.ac.kent.cs.kmf.xmi.IReaderAdapter;
import uk.ac.kent.cs.kmf.xmi.Namespace;
import uk.ac.kent.cs.kmf.xmi.ObjectInfo;
import uk.ac.kent.cs.kmf.xmi.XMIFile;

public class XMIHandler
implements ContentHandler,
ErrorHandler {
    protected XMIFile xmiFile;
    protected ILog _log;
    protected Locator locator;
    protected boolean inContent;
    protected Stack text;
    protected IReaderAdapter readerAdapter;
    protected Stack tags;
    protected Stack types;
    protected Stack objects;
    protected Map idToObj;
    protected List forwardFeaturesToSet;
    protected Map uriToPrefix;
    protected ObjectInfo objectInfo;
    protected FeatureInfo featureInfo;

    public XMIHandler(XMIFile xmiFile, ILog log) {
        this.xmiFile = xmiFile;
        this._log = log;
        this.readerAdapter = AdapterFactoryRegister.getAdapterFactory().createReaderAdapter();
        this.text = new Stack();
        this.objects = new Stack();
        this.tags = new Stack();
        this.types = new Stack();
        this.idToObj = new HashMap();
        this.forwardFeaturesToSet = new Vector();
        this.uriToPrefix = new HashMap();
        this.objectInfo = new ObjectInfo(xmiFile.getXMIVersion());
        this.featureInfo = new FeatureInfo();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.inContent = false;
    }

    public void endDocument() throws SAXException {
        int i = 0;
        while (i < this.forwardFeaturesToSet.size() - 2) {
            Object obj = this.forwardFeaturesToSet.get(i);
            Object propertyName = this.forwardFeaturesToSet.get(i + 1);
            String idref = (String)this.forwardFeaturesToSet.get(i + 2);
            Object propertyValue = this.idToObj.get(idref);
            this.readerAdapter.resolveValue(obj, propertyName, propertyValue);
            i += 3;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.uriToPrefix.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Iterator i = this.uriToPrefix.keySet().iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            String thisPrefix = (String)this.uriToPrefix.get(uri);
            if (!prefix.equals(thisPrefix)) continue;
            this.uriToPrefix.remove(uri);
            break;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.text.push(new Vector());
        if (!this.inContent) {
            this.startHeaderElement(namespaceURI, localName, qName, atts);
        } else {
            this.startContentElement(namespaceURI, localName, qName, atts);
        }
        this.tags.push(qName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.inContent) {
            this.endHeaderElement(namespaceURI, localName, qName);
        } else {
            this.endContentElement(namespaceURI, localName, qName);
        }
        this.tags.pop();
        this.text.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (s.replaceAll(" ", "").replaceAll("\t", "").replaceAll("\n", "").length() != 0) {
            ((Vector)this.text.peek()).add(s);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
        String message = "Warning: " + exception.getSystemId() + " (" + exception.getLineNumber() + "): " + exception.getMessage();
        if (this._log != null) {
            this._log.reportWarning(message);
        } else {
            System.out.println(message);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        String message = "Error: " + exception.getSystemId() + " (" + exception.getLineNumber() + "): " + exception.getMessage();
        if (this._log != null) {
            this._log.reportError(message);
        } else {
            System.out.println(message);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        String message = "Error: " + exception.getSystemId() + " (" + exception.getLineNumber() + "): " + exception.getMessage();
        if (this._log != null) {
            this._log.reportError(message);
        } else {
            System.out.println(message);
        }
    }

    public void startHeaderElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String name = localName;
        if (name.equals("XMI")) {
            this.xmiFile.setTimestamp(atts.getValue("timestamp"));
            this.xmiFile.setXMIVersion(atts.getValue("xmi.version"));
            this.xmiFile.setVerified(Boolean.valueOf(atts.getValue("xmi.verified")));
        } else if (name.equals("XMI.extensions")) {
            this.xmiFile.setExtensions(new XMIFile.Extensions(atts.getValue("XMI.extender")));
        } else if (name.equals("XMI.extension")) {
            this.xmiFile.setExtension(new XMIFile.Extension(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref"), atts.getValue("xmi.extender"), atts.getValue("xmi.extenderID")));
        } else if (!(name.equals("XMI.owner") || name.equals("XMI.contact") || name.equals("XMI.longDescription") || name.equals("XMI.shortDescription") || name.equals("XMI.exporter") || name.equals("XMI.exporterVersion") || name.equals("XMI.ExporterID") || name.equals("XMI.notice"))) {
            if (name.equals("XMI.model")) {
                this.xmiFile.addModel(new XMIFile.Model(atts.getValue("xmi.name"), atts.getValue("xmi.version"), atts.getValue("xmi.idref"), atts.getValue("href")));
            } else if (name.equals("XMI.metamodel")) {
                this.xmiFile.addMetamodel(new XMIFile.Metamodel(atts.getValue("xmi.name"), atts.getValue("xmi.version"), atts.getValue("xmi.idref"), atts.getValue("href")));
            } else if (name.equals("XMI.metametamodel")) {
                this.xmiFile.addMetametamodel(new XMIFile.Metametamodel(atts.getValue("xmi.name"), atts.getValue("xmi.version"), atts.getValue("xmi.idref"), atts.getValue("href")));
            } else if (name.equals("XMI.metametamodel")) {
                this.xmiFile.addMetametamodel(new XMIFile.Metametamodel(atts.getValue("xmi.name"), atts.getValue("xmi.version"), atts.getValue("xmi.idref"), atts.getValue("href")));
            } else if (name.equals("XMI.import")) {
                this.xmiFile.addImport(new XMIFile.Import(atts.getValue("xmi.name"), atts.getValue("xmi.version"), atts.getValue("xmi.idref"), atts.getValue("href")));
            } else if (name.equals("XMI.difference")) {
                this.xmiFile.setDifference(new XMIFile.Difference(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref")));
            } else if (name.equals("XMI.delete")) {
                this.xmiFile.setDelete(new XMIFile.Delete(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref")));
            } else if (name.equals("XMI.add")) {
                this.xmiFile.setAdd(new XMIFile.Add(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref"), atts.getValue("xmi.position")));
            } else if (name.equals("XMI.add")) {
                this.xmiFile.setReplace(new XMIFile.Replace(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref"), atts.getValue("xmi.position")));
            } else if (name.equals("XMI.reference")) {
                this.xmiFile.setReference(new XMIFile.Reference(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid")));
            } else if (name.equals("XMI.add")) {
                this.xmiFile.setAdd(new XMIFile.Add(atts.getValue("xmi.id"), atts.getValue("xmi.label"), atts.getValue("xmi.uuid"), atts.getValue("href"), atts.getValue("xmi.idref"), atts.getValue("xmi.position")));
            } else if (name.equals("XMI.content")) {
                this.inContent = true;
                this.readerAdapter.setXMIFile(this.xmiFile);
            }
        }
    }

    public void endHeaderElement(String namespaceURI, String localName, String qName) {
        String name = localName;
        if (name.equals("XMI.owner")) {
            this.xmiFile.setOwner(this.text.toString());
        } else if (name.equals("XMI.contact")) {
            this.xmiFile.setOwner(this.text.toString());
        } else if (name.equals("XMI.longDescription")) {
            this.xmiFile.setLongDescription(this.text.toString());
        } else if (name.equals("XMI.shortDescription")) {
            this.xmiFile.setShortDescription(this.text.toString());
        } else if (name.equals("XMI.exporter")) {
            this.xmiFile.setExporter(this.text.toString());
        } else if (name.equals("XMI.exporterVersion")) {
            this.xmiFile.setExporterVersion(this.text.toString());
        } else if (name.equals("XMI.ExporterID")) {
            this.xmiFile.setExporterID(this.text.toString());
        } else if (name.equals("XMI.notice")) {
            this.xmiFile.setNotice(this.text.toString());
        }
    }

    protected boolean isObject(Attributes atts, Stack tags) {
        if (((String)tags.peek()).equals("XMI.content")) {
            return true;
        }
        return atts.getValue("xmi.id") != null || atts.getValue("xmi.label") != null || atts.getValue("xmi.uuid") != null;
    }

    protected boolean isObjectReference(Attributes atts) {
        return atts.getValue("xmi.idref") != null;
    }

    protected boolean isPropertyName(Attributes atts) {
        return atts.getValue("xmi.value") != null;
    }

    protected boolean isPropertyValue(Attributes atts, Stack tags) {
        return !this.isObject(atts, tags) && !this.isObjectReference(atts) && !this.isPropertyName(atts);
    }

    protected boolean isProperty(Attributes atts, Stack tags) {
        return this.isPropertyName(atts) || this.isPropertyValue(atts, tags);
    }

    protected boolean topStackIsObject(Stack types) {
        return !types.isEmpty() && ((String)types.peek()).equals("Object");
    }

    protected boolean topStackIsObjectReference(Stack types) {
        return !types.isEmpty() && ((String)types.peek()).equals("ObjectReference");
    }

    protected boolean topStackIsPropertyName(Stack types) {
        return !types.isEmpty() && ((String)types.peek()).equals("PropertyName");
    }

    protected boolean topStackIsPropertyValue(Stack types) {
        return !types.isEmpty() && ((String)types.peek()).equals("PropertyValue");
    }

    protected boolean topStackIsProperty(Stack types) {
        return this.topStackIsPropertyName(types) || this.topStackIsPropertyValue(types);
    }

    private Object createFeature(FeatureInfo featureInfo, String idref) {
        Object obj = this.readerAdapter.createProperty(featureInfo);
        return obj;
    }

    protected Object createObject(ObjectInfo objectInfo) {
        objectInfo.setXMIVersion(this.xmiFile.getXMIVersion());
        Object obj = this.readerAdapter.createObject(objectInfo);
        if (obj != null) {
            String key;
            if (this.tags.isEmpty() || !this.tags.isEmpty() && this.tags.peek().equals("XMI.content")) {
                this.xmiFile.addTopObject(obj);
            }
            if ((key = objectInfo.getId()) != null) {
                this.idToObj.put(key, obj);
            }
        }
        return obj;
    }

    protected String[] getIdrefs(String idrefs) {
        Vector<String> list = new Vector<String>();
        StringTokenizer stringtokenizer = new StringTokenizer(idrefs);
        while (stringtokenizer.hasMoreTokens()) {
            list.add(stringtokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public void handleStartObject(String namespaceURI, String localName, String qName, Attributes atts) {
        this.objectInfo.clear();
        this.objectInfo.setId(atts.getValue("xmi.id"));
        this.objectInfo.setUUID(atts.getValue("xmi.uuid"));
        this.objectInfo.setLabel(atts.getValue("xmi.label"));
        this.objectInfo.setIdref(atts.getValue("xmi.idref"));
        this.objectInfo.setHref(atts.getValue("xmi.href"));
        this.objectInfo.setXMIName(localName);
        this.objectInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
        this.objectInfo.setModels(this.xmiFile.getModels());
        Object obj = this.createObject(this.objectInfo);
        if (obj != null) {
            this.objects.push(obj);
            this.types.push("Object");
            int i = 0;
            while (i < atts.getLength()) {
                if (!(atts.getLocalName(i).equals("xmi.id") || atts.getLocalName(i).equals("xmi.uuid") || atts.getLocalName(i).equals("xmi.label") || atts.getLocalName(i).equals("xmi.uuid") || atts.getLocalName(i).equals("xmi.idref") || atts.getLocalName(i).equals("xmi.href"))) {
                    this.featureInfo.clear();
                    this.featureInfo.setObject(obj);
                    this.featureInfo.setClassName(localName);
                    this.featureInfo.setXMIName(atts.getLocalName(i));
                    this.featureInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
                    this.featureInfo.setModels(this.xmiFile.getModels());
                    String attribType = atts.getType(i);
                    if (attribType.equals("CDATA")) {
                        this.featureInfo.setValue(atts.getValue(i));
                        this.createFeature(this.featureInfo, null);
                    } else if (attribType.equals("IDREF")) {
                        this.createFeature(this.featureInfo, atts.getValue(i));
                    } else if (attribType.equals("IDREFS")) {
                        ObjectInfo objectinfo = new ObjectInfo(this.xmiFile.getXMIVersion());
                        this.objectInfo.setIdref(atts.getValue(i));
                        Object obj1 = this.createObject(this.objectInfo);
                        String[] idrefs = this.getIdrefs(atts.getValue(i));
                        int j = 0;
                        while (j < idrefs.length) {
                            ObjectInfo objectInfo = new ObjectInfo(this.xmiFile.getXMIVersion());
                            objectInfo.setIdref(idrefs[j]);
                            Object obj2 = this.createObject(objectInfo);
                            this.featureInfo.setValue(obj2);
                            this.createFeature(this.featureInfo, idrefs[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else {
            this.objects.push(obj);
            this.types.push("Object");
        }
    }

    public void handleStartObjectReference(String namespaceURI, String localName, String qName, Attributes atts) {
        this.featureInfo.clear();
        if (this.objects.size() != 0) {
            this.featureInfo.setObject(this.objects.peek());
        } else {
            this.featureInfo.setObject(null);
        }
        this.featureInfo.setXMIName((String)this.tags.peek());
        this.featureInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
        this.featureInfo.setModels(this.xmiFile.getModels());
        String idref = atts.getValue("xmi.idref");
        Object obj = this.idToObj.get(idref);
        if (obj != null) {
            this.featureInfo.setValue(obj);
            this.createFeature(this.featureInfo, idref);
        } else {
            this.forwardFeaturesToSet.add(this.featureInfo.getObject());
            this.forwardFeaturesToSet.add((String)this.tags.peek());
            this.forwardFeaturesToSet.add(idref);
        }
        this.types.push("ObjectReference");
    }

    public void handleStartProperty(String namespaceURI, String localName, String qName, Attributes atts) {
        if (this.isPropertyName(atts)) {
            this.types.push("PropertyName");
            String val = atts.getValue("xmi.value");
            if (val != null) {
                ((Vector)this.text.peek()).add(val);
            }
        } else if (this.topStackIsObject(this.types) || this.topStackIsPropertyValue(this.types)) {
            this.types.push("PropertyName");
        } else if (this.topStackIsPropertyName(this.types)) {
            this.objectInfo.clear();
            this.objectInfo.setXMIName(localName);
            this.objectInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
            this.objectInfo.setModels(this.xmiFile.getModels());
            Object obj = this.createObject(this.objectInfo);
            this.objects.push(obj);
            this.types.push("PropertyValue");
        } else {
            this.types.push("PropertyXValue");
        }
    }

    public void startContentElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (this.isObject(atts, this.tags)) {
            this.handleStartObject(namespaceURI, localName, qName, atts);
        } else if (this.isObjectReference(atts)) {
            this.handleStartObjectReference(namespaceURI, localName, qName, atts);
        } else {
            this.handleStartProperty(namespaceURI, localName, qName, atts);
        }
    }

    public void endContentElement(String namespaceURI, String localName, String qName) {
        if (this.topStackIsObject(this.types)) {
            int index;
            this.featureInfo.clear();
            String top = (String)this.tags.peek();
            this.tags.pop();
            this.featureInfo.setXMIName((String)this.tags.peek());
            this.tags.push(top);
            this.featureInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
            this.featureInfo.setModels(this.xmiFile.getModels());
            Object value = null;
            if (!this.objects.empty()) {
                value = this.objects.peek();
                this.featureInfo.setValue(value);
                this.objects.pop();
            }
            Object obj = null;
            if (!this.objects.empty()) {
                obj = this.objects.peek();
                this.featureInfo.setObject(obj);
            }
            String className = "";
            if (obj != null && (index = (className = obj.getClass().getName()).indexOf("$")) != -1) {
                className = className.substring(0, index);
            }
            this.featureInfo.setClassName(className);
            if (obj != null) {
                this.createFeature(this.featureInfo, null);
            }
        } else if (!this.topStackIsObjectReference(this.types) && this.topStackIsProperty(this.types)) {
            if (this.topStackIsPropertyName(this.types)) {
                if (((Vector)this.text.peek()).size() != 0) {
                    int index;
                    this.featureInfo.clear();
                    this.featureInfo.setXMIName((String)this.tags.peek());
                    this.featureInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
                    this.featureInfo.setModels(this.xmiFile.getModels());
                    Object obj = null;
                    if (!this.objects.empty()) {
                        obj = this.objects.peek();
                        this.featureInfo.setObject(obj);
                    }
                    String className = "";
                    if (obj != null && (index = (className = obj.getClass().getName()).indexOf("$")) != -1) {
                        className = className.substring(0, index);
                    }
                    this.featureInfo.setClassName(className);
                    Vector values = (Vector)this.text.peek();
                    String strVal = new String();
                    int i = 0;
                    while (i < values.size()) {
                        strVal = String.valueOf(strVal) + values.elementAt(i).toString();
                        ++i;
                    }
                    this.featureInfo.setValue(strVal);
                    this.createFeature(this.featureInfo, null);
                }
            } else {
                int index;
                this.featureInfo.clear();
                String top = (String)this.tags.peek();
                this.tags.pop();
                this.featureInfo.setXMIName((String)this.tags.peek());
                this.tags.push(top);
                this.featureInfo.setNamespace(new Namespace((String)this.uriToPrefix.get(namespaceURI), namespaceURI));
                this.featureInfo.setModels(this.xmiFile.getModels());
                Object value = null;
                if (!this.objects.empty()) {
                    value = this.objects.peek();
                    this.featureInfo.setValue(value);
                    this.objects.pop();
                }
                Object obj = null;
                if (!this.objects.empty()) {
                    obj = this.objects.peek();
                    this.featureInfo.setObject(obj);
                }
                String className = "";
                if (obj != null && (index = (className = obj.getClass().getName()).indexOf("$")) != -1) {
                    className = className.substring(0, index);
                }
                this.featureInfo.setClassName(className);
                if (obj != null) {
                    this.createFeature(this.featureInfo, null);
                }
            }
        }
        if (!this.types.empty()) {
            this.types.pop();
        }
    }
}

