/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.views.markers.MarkerViewUtil;
import org.osgi.framework.Bundle;

public class SelectMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private ResourceBundle fBundle;
    private String fPrefix;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, IVerticalRuler ruler, ITextEditor editor) {
        this(bundle, prefix, editor, (IVerticalRulerInfo)ruler);
    }

    public void update() {
        this.setEnabled(this.hasMarkers());
    }

    public void run() {
        IMarker marker = this.chooseMarker(this.getMarkers());
        if (marker == null) {
            return;
        }
        IWorkbenchPage page = this.fTextEditor.getSite().getPage();
        MarkerViewUtil.showMarker((IWorkbenchPage)page, (IMarker)marker, (boolean)false);
        this.gotoMarker(marker);
    }

    private void gotoMarker(IMarker marker) {
        int length;
        IEditorInput editorInput;
        IGotoMarker gotoMarkerAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((gotoMarkerAdapter = (IGotoMarker)this.fTextEditor.getAdapter((Class)clazz)) != null) {
            gotoMarkerAdapter.gotoMarker(marker);
            return;
        }
        int start = MarkerUtilities.getCharStart(marker);
        int end = MarkerUtilities.getCharEnd(marker);
        boolean selectLine = start < 0 || end < 0;
        IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)(editorInput = this.fTextEditor.getEditorInput()));
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                start = pos.getOffset();
                end = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return;
            }
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (selectLine) {
            try {
                int line;
                if (start >= 0) {
                    line = document.getLineOfOffset(start);
                } else {
                    line = MarkerUtilities.getLineNumber(marker);
                    --line;
                }
                end = start + document.getLineLength(line) - 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        if (end - 1 < (length = document.getLength()) && start < length) {
            this.fTextEditor.selectAndReveal(start, end - start);
        }
    }

    protected IMarker chooseMarker(List markers) {
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension access = this.getAnnotationAccessExtension();
        IMarker marker = null;
        int maxLayer = 0;
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            IMarker m = (IMarker)iter.next();
            MarkerAnnotation a = model.getMarkerAnnotation(m);
            if (a == null) continue;
            if (access == null) {
                marker = m;
                break;
            }
            int l = access.getLayer((Annotation)a);
            if (l == maxLayer) {
                if (marker != null) continue;
                marker = m;
                continue;
            }
            if (l <= maxLayer) continue;
            maxLayer = l;
            marker = m;
        }
        return marker;
    }

    protected IAnnotationAccessExtension getAnnotationAccessExtension() {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = this.fTextEditor.getAdapter((Class)clazz)) instanceof IAnnotationAccessExtension) {
            return (IAnnotationAccessExtension)adapter;
        }
        return null;
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private boolean includesLine(Position position, IDocument document, int line) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
        Shell shell = this.fTextEditor.getSite().getShell();
        String title = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String msg = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List getMarkers() {
        IMarker[] allMarkers;
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return Collections.EMPTY_LIST;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return Collections.EMPTY_LIST;
        }
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            allMarkers = resource.findMarkers(null, true, 0);
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.SelectMarkerRulerAction_getMarker);
            return Collections.EMPTY_LIST;
        }
        if (allMarkers.length == 0) {
            return Collections.EMPTY_LIST;
        }
        int activeLine = this.fRuler.getLineOfLastMouseButtonActivity();
        ArrayList<IMarker> markers = null;
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)it.next();
            if (!(annotation instanceof MarkerAnnotation) || !this.includesLine(position = model.getPosition(annotation), document, activeLine)) continue;
            if (markers == null) {
                markers = new ArrayList<IMarker>(10);
            }
            markers.add(((MarkerAnnotation)annotation).getMarker());
        }
        if (markers == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(markers);
    }

    protected boolean hasMarkers() {
        IMarker[] allMarkers;
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return false;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return false;
        }
        try {
            allMarkers = resource.findMarkers(null, true, 0);
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.SelectMarkerRulerAction_getMarker);
            return false;
        }
        if (allMarkers.length == 0) {
            return false;
        }
        int activeLine = this.fRuler.getLineOfLastMouseButtonActivity();
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)it.next();
            if (!(annotation instanceof MarkerAnnotation) || !this.includesLine(position = model.getPosition(annotation), document, activeLine)) continue;
            return true;
        }
        return false;
    }
}

