/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.qvt.launcher.internal;

import de.ikv.emf.qvt.EMFQvtProcessorImpl;
import de.ikv.medini.qvt.Trace;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.Domain;
import es.upv.dsic.issi.qvt.launcher.model.qvtinvocation.QvtTransformationInvocation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import traces.TraceabilityLink;
import traces.TraceabilityModel;
import traces.TracesFactory;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.OutputStreamLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtTransformationJob
extends WorkspaceJob {
    QvtTransformationInvocation invocation;
    ResourceSet resourceSet = new ResourceSetImpl();

    public QvtTransformationJob(QvtTransformationInvocation invocation) {
        super("Running " + invocation.getName() + " transformation");
        this.invocation = invocation;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Running...", -1);
        Resource targetResource = null;
        OutputStreamLog log = new OutputStreamLog((OutputStream)System.err);
        EMFQvtProcessorImpl emfQvtProcessorImpl = new EMFQvtProcessorImpl((ILog)log);
        InputStreamReader qvtScriptReader = new InputStreamReader(ResourcesPlugin.getWorkspace().getRoot().getFile(this.invocation.getPath()).getContents());
        ArrayList<Resource> models = new ArrayList<Resource>();
        for (Domain domain : this.invocation.getDomains()) {
            Resource resource = null;
            if (ResourcesPlugin.getWorkspace().getRoot().getFile(domain.getModelPath()).exists()) {
                try {
                    resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)domain.getModelPath().toString(), (boolean)false), true);
                    resource.load(Collections.EMPTY_MAP);
                    if (!resource.getContents().isEmpty()) {
                        emfQvtProcessorImpl.addMetaModel((Object)((EObject)resource.getContents().get(0)).eClass().getEPackage());
                    }
                    resource = this.resourceSet.createResource(URI.createPlatformResourceURI((String)domain.getModelPath().toString(), (boolean)false));
                }
                catch (IOException e) {
                    return new Status(4, "es.upv.dsic.issi.qvt.launcher", e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof PackageNotFoundException) {
                        return new Status(4, "es.upv.dsic.issi.qvt.launcher", e.getCause().getLocalizedMessage(), e.getCause());
                    }
                    return new Status(4, "es.upv.dsic.issi.qvt.launcher", e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                Object[] keys;
                resource = this.resourceSet.createResource(URI.createPlatformResourceURI((String)domain.getModelPath().toString(), (boolean)false));
                resource.getContents().clear();
                Object[] objectArray = keys = EPackage.Registry.INSTANCE.keySet().toArray();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    EPackage pkg = EPackage.Registry.INSTANCE.getEPackage(key.toString());
                    if (pkg.getNsPrefix().equals(domain.getNsPrefix())) {
                        emfQvtProcessorImpl.addMetaModel((Object)pkg);
                    }
                    ++n2;
                }
            }
            models.add(resource);
        }
        targetResource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)this.invocation.getDirection().getModelPath().toString(), (boolean)false), true);
        targetResource.getContents().clear();
        emfQvtProcessorImpl.setModels(models);
        emfQvtProcessorImpl.setDebug(Boolean.valueOf(true));
        emfQvtProcessorImpl.setProperty("traces", "true");
        try {
            Collection traces = emfQvtProcessorImpl.evaluateQVT((Reader)qvtScriptReader, this.invocation.getName(), true, this.invocation.getDirection().getName(), models.toArray(), new ArrayList(), (ILog)log);
            TraceabilityModel traceabilityModel = this.createTraceabilityModel(traces);
            Resource tracesResource = this.resourceSet.createResource(URI.createPlatformResourceURI((String)this.invocation.getDirection().getModelPath().removeFileExtension().addFileExtension("traces").toString(), (boolean)false));
            tracesResource.getContents().add((Object)traceabilityModel);
            targetResource.save(Collections.EMPTY_MAP);
            tracesResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            return new Status(4, "es.upv.dsic.issi.qvt.launcher", e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            return new Status(4, "es.upv.dsic.issi.qvt.launcher", e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private TraceabilityModel createTraceabilityModel(Collection<Trace> traces) {
        TraceabilityModel traceabilityModel = TracesFactory.eINSTANCE.createTraceabilityModel();
        traceabilityModel.setName("Transformation");
        for (Domain domain : this.invocation.getDomains()) {
            if (domain != this.invocation.getDirection()) {
                traceabilityModel.getDomainModels().add((Object)URI.createPlatformResourceURI((String)domain.getModelPath().toString(), (boolean)false));
                continue;
            }
            traceabilityModel.getTargetModels().add((Object)URI.createPlatformResourceURI((String)domain.getModelPath().toString(), (boolean)false));
        }
        for (Trace t : traces) {
            TraceabilityLink traceabilityLink = TracesFactory.eINSTANCE.createTraceabilityLink();
            traceabilityModel.getLinks().add((Object)traceabilityLink);
            traceabilityLink.setManipulationRule(t.getRelation().getName());
            for (Object obj1 : t.getBindings()) {
                for (Object obj2 : ((HashMap)obj1).values()) {
                    if (!(obj2 instanceof OclAnyModelElement)) continue;
                    OclAnyModelElement elt = (OclAnyModelElement)obj2;
                    if (!((EObject)elt.asJavaObject()).eClass().eResource().equals(((EObject)this.resourceSet.getResource(URI.createPlatformResourceURI((String)this.invocation.getDirection().getModelPath().toString(), (boolean)false), true).getContents().get(0)).eClass().eResource())) {
                        traceabilityLink.getDomain().add((Object)((EObject)elt.asJavaObject()));
                        continue;
                    }
                    traceabilityLink.getRange().add((Object)((EObject)elt.asJavaObject()));
                }
            }
        }
        return traceabilityModel;
    }
}

