/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.patterns;

import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import uk.ac.kent.cs.kmf.patterns.ConstrainedElement;
import uk.ac.kent.cs.kmf.patterns.Factory;
import uk.ac.kent.cs.kmf.patterns.GenericXMIReaderAdapter;
import uk.ac.kent.cs.kmf.patterns.Repository;
import uk.ac.kent.cs.kmf.patterns.VisitActions;
import uk.ac.kent.cs.kmf.patterns.Visitable;
import uk.ac.kent.cs.kmf.patterns.Visitor;
import uk.ac.kent.cs.kmf.patterns.XMIVisitActionsImpl;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.xmi.AdapterFactory;
import uk.ac.kent.cs.kmf.xmi.AdapterFactoryRegister;
import uk.ac.kent.cs.kmf.xmi.IAdapterFactory;
import uk.ac.kent.cs.kmf.xmi.IReaderAdapter;
import uk.ac.kent.cs.kmf.xmi.IWriterAdapter;
import uk.ac.kent.cs.kmf.xmi.IXMIFile;
import uk.ac.kent.cs.kmf.xmi.ReaderAdapter;
import uk.ac.kent.cs.kmf.xmi.WriterAdapter;
import uk.ac.kent.cs.kmf.xmi.XMIFile;
import uk.ac.kent.cs.kmf.xmi.XMIObject;
import uk.ac.kent.cs.kmf.xmi.XMIReader;
import uk.ac.kent.cs.kmf.xmi.XMIWriter;

public abstract class RepositoryImpl
implements Repository {
    protected ILog _log;
    protected Map _factories = new Hashtable();
    Map _subRepository = new HashMap();
    Repository parent = null;
    protected Map _population = new Hashtable();
    Factory _factory = null;
    protected static int elemId = 0;

    public RepositoryImpl(ILog log) {
        this.setLog(log);
    }

    public Map getSubRepository() {
        return this._subRepository;
    }

    public void registerSubRepository(String name, Repository v) {
        List<String> names = Arrays.asList(name.split("[.]"));
        this.registerSubRepository(names, v);
    }

    public void registerSubRepository(List names, Repository v) {
        if ((names = this.removeUpToThis(names)).size() > 1) {
            final String name = (String)names.get(0);
            Repository rep = this.getSubRepository(name);
            if (rep == null) {
                rep = new RepositoryImpl(this.getLog()){

                    public void saveXMI(String fileName) {
                    }

                    public String toString() {
                        return name;
                    }
                };
            }
            this._subRepository.put(name, rep);
            rep.registerSubRepository(names.subList(1, names.size()), v);
        } else {
            String name = (String)names.get(0);
            this._subRepository.put(name, v);
            v.setParent(this);
        }
    }

    public Repository getSubRepository(String name) {
        return (Repository)this._subRepository.get(name);
    }

    public Repository getParent() {
        return this.parent;
    }

    public void setParent(Repository r) {
        this.parent = r;
    }

    public Repository getRoot() {
        Repository r = this;
        while (r.getParent() != null) {
            r = this.getParent();
        }
        return r;
    }

    public String getFullName(String sep) {
        if (this.getParent() != null) {
            if (this.getParent().getFullName(sep) != null) {
                return String.valueOf(this.getParent().getFullName(sep)) + sep + this.toString();
            }
            return this.toString();
        }
        return this.toString();
    }

    public Set elementTypes() {
        return this._population.keySet();
    }

    public void registerElementType(List names) {
        if ((names = this.removeUpToThis(names)).size() > 1) {
            this.getSubRepository((String)names.get(0)).registerElementType(names.subList(1, names.size()));
        } else {
            String ref_name = (String)names.get(0);
            this._log.reportMessage("Registering population for '" + ref_name + "' in " + this);
            if (this._population.containsKey(ref_name)) {
                this._log.reportWarning("Population for '" + ref_name + "' was replaced in " + this);
            }
            this._population.put(ref_name, new Vector());
        }
    }

    public void registerElementType(String ref_name) {
        List<String> names = Arrays.asList(ref_name.split("[.]"));
        this.registerElementType(names);
    }

    public Boolean isRegistered(String name) {
        List objs = (List)this._population.get(name);
        if (objs != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object buildElement(String fullClassName) {
        List<String> names = Arrays.asList(fullClassName.split("\\."));
        return this.buildElement(names);
    }

    public Object buildElement(String fullClassName, List types, List objects) {
        List<String> names = Arrays.asList(fullClassName.split("\\."));
        return this.buildElement(names, types, objects);
    }

    public Object buildElement(List names) {
        names = this.removeUpToThis(names);
        Object elem = null;
        Object poss = null;
        if (names.size() > 1) {
            Repository subRep = this.getSubRepository((String)names.get(0));
            if (subRep != null) {
                return subRep.buildElement(names.subList(1, names.size()));
            }
            return null;
        }
        String clsName = (String)names.get(0);
        if (!this.isRegistered(clsName).booleanValue()) {
            List l = this.buildUnqualifiedElement(clsName);
            if (l.size() > 0) {
                elem = l.get(0);
            } else {
                this._log.reportError("Cannot build element '" + clsName + "' in repository " + this);
            }
            if (l.size() > 1) {
                this._log.reportWarning("Multiple choices for building element '" + clsName + "' in repository " + this);
                this._log.reportWarning("  have chosen to build " + elem);
            }
            return elem;
        }
        elem = this.getFactory().create(clsName);
        if (elem != null) {
            this.addElement(clsName, elem);
        } else {
            this._log.reportError("Cannot build element '" + clsName + "' in repository " + this);
        }
        return elem;
    }

    List removeUpToThis(List names) {
        String thisName = this.toString();
        int i = names.indexOf(thisName);
        if (i != -1) {
            return names.subList(i + 1, names.size());
        }
        return names;
    }

    public Object buildElement(List names, List types, List objects) {
        names = this.removeUpToThis(names);
        Object elem = null;
        Object poss = null;
        if (names.size() > 1) {
            Repository subRep = this.getSubRepository((String)names.get(0));
            if (subRep != null) {
                return subRep.buildElement(names.subList(1, names.size()), types, objects);
            }
            return null;
        }
        String clsName = (String)names.get(0);
        if (!this.isRegistered(clsName).booleanValue()) {
            List l = this.buildUnqualifiedElement(clsName, types, objects);
            if (l.size() > 0) {
                elem = l.get(0);
            } else {
                this._log.reportError("Cannot build element '" + clsName + "' in repository " + this);
            }
            if (l.size() > 1) {
                this._log.reportWarning("Multiple choices for building element '" + clsName + "' in repository " + this);
                this._log.reportWarning("  have chosen to build " + elem);
            }
            return elem;
        }
        elem = this.getFactory().create(clsName, types, objects);
        if (elem != null) {
            this.addElement(clsName, elem);
        } else {
            this._log.reportError("Cannot build element '" + clsName + "' in repository " + this);
        }
        return elem;
    }

    public List buildUnqualifiedElement(String name) {
        return this.buildUnqualifiedElement(name, new Vector(), new Vector());
    }

    public List buildUnqualifiedElement(String name, List types, List objects) {
        Vector<Object> poss = new Vector<Object>();
        if (!this.isRegistered(name).booleanValue()) {
            Iterator i = this.getSubRepository().values().iterator();
            while (i.hasNext()) {
                Repository r = (Repository)i.next();
                List o = r.buildUnqualifiedElement(name, types, objects);
                poss.addAll(o);
            }
            return poss;
        }
        Object o = this.buildElement(name, types, objects);
        poss.add(o);
        return poss;
    }

    public Factory getFactory() {
        return this._factory;
    }

    public void setFactory(Factory factory) {
        this._factory = factory;
    }

    public void addElement(List names, Object elem) {
        if ((names = this.removeUpToThis(names)).size() > 1) {
            this.getSubRepository((String)names.get(0)).addElement(names.subList(1, names.size()), elem);
        } else {
            String ref_name = (String)names.get(0);
            List pop = (List)this._population.get(ref_name);
            if (pop == null) {
                this.registerElementType(ref_name);
                pop = (List)this._population.get(ref_name);
            }
            pop.add(elem);
        }
    }

    public void addElement(String fullClassName, Object elem) {
        List<String> names = Arrays.asList(fullClassName.split("\\."));
        this.addElement(names, elem);
    }

    public void removeElement(String fullClassName, Object elem) {
        List<String> names = Arrays.asList(fullClassName.split("\\."));
        this.removeElement(names, elem);
    }

    public void removeElement(List names, Object elem) {
        if ((names = this.removeUpToThis(names)).size() > 1) {
            this.getSubRepository((String)names.get(0)).removeElement(names.subList(1, names.size()), elem);
        } else {
            String ref_name = (String)names.get(0);
            List pop = (List)this._population.get(ref_name);
            if (pop == null) {
                this._log.reportError("Missing population for '" + ref_name + "'");
            } else {
                this.getFactory().destroy(ref_name, elem);
                pop.remove(elem);
            }
        }
    }

    public List getElements(String fullClassName) {
        List<String> names = Arrays.asList(fullClassName.split("[.]"));
        List objs = this.getElements(names);
        if (objs == null) {
            this._log.reportError("Missing population for '" + fullClassName + "' in " + this);
        }
        return objs;
    }

    public List getElements(List names) {
        names = this.removeUpToThis(names);
        List objs = null;
        if (names.size() > 1) {
            Repository sub = this.getSubRepository((String)names.get(0));
            if (sub != null) {
                objs = sub.getElements(names.subList(1, names.size()));
            } else {
                this._log.reportError("Missing subRepository named " + names.get(0) + " in " + this);
            }
        } else {
            String clsName = (String)names.get(0);
            objs = (List)this._population.get(clsName);
        }
        return objs;
    }

    protected boolean isInstanceOf(String elemName, String fullClassName) {
        int pos1 = elemName.lastIndexOf(46);
        String iElemName = elemName;
        if (pos1 != -1 && elemName.charAt(pos1 + 1) != 'I') {
            iElemName = String.valueOf(elemName.substring(0, pos1 + 1)) + "I" + elemName.substring(pos1 + 1, elemName.length());
        }
        int pos2 = fullClassName.lastIndexOf(46);
        String iFullClassName = fullClassName;
        if (pos2 != -1 && fullClassName.charAt(pos2 + 1) != 'I') {
            iFullClassName = String.valueOf(fullClassName.substring(0, pos2 + 1)) + "I" + fullClassName.substring(pos2 + 1, fullClassName.length());
        }
        boolean res = false;
        try {
            res = Class.forName(iFullClassName).isAssignableFrom(Class.forName(iElemName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public List getInstances(String fullClassName) {
        try {
            return this.getAssignableTo(Class.forName(fullClassName));
        }
        catch (Exception e) {
            this._log.reportError("No class or interface implementation for " + fullClassName);
            return null;
        }
    }

    public List getInstances(List names) {
        return null;
    }

    public List getAssignableTo(String name) {
        String fullName = String.valueOf(this.getFullName(".")) + "." + name;
        return this.getInstances(fullName);
    }

    public List getAssignableTo(Class refCls) {
        Vector objects = new Vector();
        Set elemNames = this._population.keySet();
        Iterator nameIt = elemNames.iterator();
        while (nameIt.hasNext()) {
            Class<?> elType;
            String elemName = (String)nameIt.next();
            List elements = this.getElements(elemName);
            if (elements.size() <= 0 || !refCls.isAssignableFrom(elType = elements.get(0).getClass())) continue;
            objects.addAll(elements);
        }
        Iterator i = this.getSubRepository().values().iterator();
        while (i.hasNext()) {
            Repository r = (Repository)i.next();
            objects.addAll(r.getAssignableTo(refCls));
        }
        return objects;
    }

    public Factory getFactory(String fullClassName) {
        Factory factory = null;
        try {
            factory = (Factory)this._factories.get(fullClassName);
        }
        catch (Exception e) {
            this._log.reportError("Missing factory for '" + fullClassName + "' class");
        }
        return factory;
    }

    public void addFactory(String fullClassName, Factory factory) {
        if (this._factories.containsKey(fullClassName)) {
            this._log.reportWarning("Lifecycle for '" + fullClassName + "' was replaced");
        }
        this._factories.put(fullClassName, factory);
    }

    public void parseInvariants() {
        this._log.reportMessage("");
        this._log.reportMessage("Parsing invariants from repository ...");
        Set elemNames = this._population.keySet();
        Iterator elemIt = elemNames.iterator();
        while (elemIt.hasNext()) {
            String elemName = (String)elemIt.next();
            List elements = (List)this._population.get(elemName);
            Iterator elementIt = elements.iterator();
            while (elementIt.hasNext()) {
                ConstrainedElement element = (ConstrainedElement)elementIt.next();
                element.parseInvariants(this._log);
            }
        }
    }

    public void evaluateInvariants() {
        this._log.reportMessage("");
        this._log.reportMessage("Evaluating invariants from repository ...");
        Set elemNames = this._population.keySet();
        Iterator elemIt = elemNames.iterator();
        while (elemIt.hasNext()) {
            String elemName = (String)elemIt.next();
            List elements = (List)this._population.get(elemName);
            Iterator elementIt = elements.iterator();
            while (elementIt.hasNext()) {
                ConstrainedElement element = (ConstrainedElement)elementIt.next();
                element.evaluateInvariants(this._log);
            }
        }
    }

    public void saveXMI(String fileName, Visitor xmiVisitor) {
        if (!fileName.toLowerCase().endsWith(".xmi")) {
            fileName = String.valueOf(fileName) + ".xmi";
        }
        XMIFile xmiFile = new XMIFile(fileName);
        IdentityHashMap mapRefToXMI = new IdentityHashMap();
        Collection topObjs = xmiFile.getTopObjects();
        XMIVisitActionsImpl xmiActions = new XMIVisitActionsImpl();
        topObjs.addAll(this.repToXMI(xmiVisitor, mapRefToXMI, xmiActions));
        this.xmiToFile(xmiFile, fileName);
    }

    Collection repToXMI(Visitor xmiVisitor, Map mapRefToXMI, VisitActions xmiActions) {
        Vector<XMIObject> objs = new Vector<XMIObject>();
        HashMap<String, VisitActions> m = new HashMap<String, VisitActions>();
        m.put("actions", xmiActions);
        Iterator typeIt = this._population.keySet().iterator();
        while (typeIt.hasNext()) {
            String type_name = (String)typeIt.next();
            List elements = (List)this._population.get(type_name);
            Iterator elementIt = elements.iterator();
            while (elementIt.hasNext()) {
                Visitable element = (Visitable)elementIt.next();
                XMIObject xmiElement = (XMIObject)element.accept(xmiVisitor, m);
                objs.add(xmiElement);
            }
        }
        Iterator i = this._subRepository.values().iterator();
        while (i.hasNext()) {
            RepositoryImpl rep = (RepositoryImpl)i.next();
            objs.addAll(rep.repToXMI(xmiVisitor, mapRefToXMI, xmiActions));
        }
        return objs;
    }

    void xmiToFile(XMIFile xmiFile, String fileName) {
        try {
            AdapterFactory XMIadapter = new AdapterFactory((IReaderAdapter)new GenericXMIReaderAdapter(this), (IWriterAdapter)new WriterAdapter());
            AdapterFactoryRegister.registerAdapterFactory((IAdapterFactory)XMIadapter);
            XMIWriter writer = new XMIWriter();
            writer.write((IXMIFile)xmiFile, fileName, this._log);
        }
        catch (Exception e) {
            this._log.reportMessage("" + e);
        }
    }

    public XMIFile loadXMI(String fileName, ReaderAdapter radapter) {
        XMIFile xmiFile = null;
        try {
            AdapterFactory XMIadapter = new AdapterFactory((IReaderAdapter)radapter, (IWriterAdapter)new WriterAdapter());
            AdapterFactoryRegister.registerAdapterFactory((IAdapterFactory)XMIadapter);
            xmiFile = new XMIReader().read(fileName, this._log);
            Collection obj = xmiFile.getTopObjects();
        }
        catch (FileNotFoundException e) {
            this.getLog().reportError("File not found - " + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmiFile;
    }

    public ILog getLog() {
        return this._log;
    }

    public void setLog(ILog log) {
        this._log = log;
    }

    public static void resetId() {
        elemId = 0;
    }

    public String newId() {
        return "" + ++elemId;
    }
}

