/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IUndoManagerListener;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class UndoManager
implements IUndoManager {
    private Stack fUndoChanges;
    private Stack fRedoChanges;
    private Stack fUndoNames;
    private Stack fRedoNames;
    private ListenerList fListeners;
    private static final int MAX_UNDO_REDOS = 5;

    public UndoManager() {
        this.flush();
    }

    public void addListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(1);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.size() == 0) {
            this.fListeners = null;
        }
    }

    public void aboutToPerformChange(final Change change) {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.aboutToPerformChange(UndoManager.this, change);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    public void changePerformed(final Change change) {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.changePerformed(UndoManager.this, change);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    public void changePerformed(Change change, boolean successful) {
        this.changePerformed(change);
    }

    public void aboutToPerformRefactoring() {
    }

    public void refactoringPerformed(boolean success) {
    }

    public void shutdown() {
    }

    public void flush() {
        this.flushUndo();
        this.flushRedo();
    }

    private void flushUndo() {
        if (this.fUndoChanges != null) {
            this.sendDispose(this.fUndoChanges);
        }
        this.fUndoChanges = new Stack();
        this.fUndoNames = new Stack();
        this.fireUndoStackChanged();
    }

    private void flushRedo() {
        if (this.fRedoChanges != null) {
            this.sendDispose(this.fRedoChanges);
        }
        this.fRedoChanges = new Stack();
        this.fRedoNames = new Stack();
        this.fireRedoStackChanged();
    }

    public void addUndo(String refactoringName, Change change) {
        Assert.isNotNull((Object)refactoringName, (String)"refactoring");
        Assert.isNotNull((Object)change, (String)"change");
        this.fUndoNames.push(refactoringName);
        this.fUndoChanges.push(change);
        if (this.fUndoChanges.size() > 5) {
            Change removedChange = (Change)this.fUndoChanges.remove(0);
            this.fUndoNames.remove(0);
            removedChange.dispose();
        }
        this.flushRedo();
        this.fireUndoStackChanged();
    }

    public void performUndo(IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        Change redo;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fUndoChanges.empty()) {
            return;
        }
        Change change = (Change)this.fUndoChanges.pop();
        if (query == null) {
            query = new NullQuery();
        }
        try {
            redo = this.executeChange(result, change, query, pm);
        }
        catch (InterruptedException interruptedException) {
            this.fUndoChanges.push(change);
            return;
        }
        if (!result.hasFatalError()) {
            if (redo != null && !this.fUndoNames.isEmpty()) {
                this.fRedoNames.push(this.fUndoNames.pop());
                this.fRedoChanges.push(redo);
                this.fireUndoStackChanged();
                this.fireRedoStackChanged();
            } else {
                this.flush();
            }
        } else {
            this.flush();
        }
    }

    public void performRedo(IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        Change undo;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fRedoChanges.empty()) {
            return;
        }
        Change change = (Change)this.fRedoChanges.pop();
        if (query == null) {
            query = new NullQuery();
        }
        try {
            undo = this.executeChange(result, change, query, pm);
        }
        catch (InterruptedException interruptedException) {
            this.fRedoChanges.push(change);
            return;
        }
        if (!result.hasFatalError()) {
            if (undo != null && !this.fRedoNames.isEmpty()) {
                this.fUndoNames.push(this.fRedoNames.pop());
                this.fUndoChanges.push(undo);
                this.fireRedoStackChanged();
                this.fireUndoStackChanged();
            }
        } else {
            this.flush();
        }
    }

    private Change executeChange(final RefactoringStatus status, final Change change, final IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException, InterruptedException {
        final Change[] undo = new Change[1];
        final boolean[] interrupted = new boolean[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                boolean undoInitialized = false;
                try {
                    monitor.beginTask("", 11);
                    status.merge(change.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 2)));
                    if (status.hasFatalError()) {
                        query.stopped(status);
                        change.dispose();
                        return;
                    }
                    try {
                        if (!status.isOK() && !query.proceed(status)) {
                            interrupted[0] = true;
                            return;
                        }
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                        boolean successful = false;
                        try {
                            UndoManager.this.aboutToPerformChange(change);
                            undo[0] = change.perform((IProgressMonitor)new SubProgressMonitor(monitor, 8));
                            successful = true;
                            ResourcesPlugin.getWorkspace().checkpoint(false);
                        }
                        finally {
                            UndoManager.this.changePerformed(change, successful);
                        }
                        change.dispose();
                        if (undo[0] == null) return;
                        undo[0].initializeValidationData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        undoInitialized = true;
                        return;
                    }
                    catch (CoreException e) {
                        UndoManager.this.flush();
                        if (undo[0] != null && undoInitialized) {
                            Change ch = undo[0];
                            undo[0] = null;
                            ch.dispose();
                            throw e;
                        } else {
                            undo[0] = null;
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        UndoManager.this.flush();
                        if (undo[0] != null && undoInitialized) {
                            Change ch = undo[0];
                            undo[0] = null;
                            ch.dispose();
                            throw e;
                        } else {
                            undo[0] = null;
                        }
                        throw e;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, pm);
        if (interrupted[0]) {
            throw new InterruptedException();
        }
        return undo[0];
    }

    public boolean anythingToRedo() {
        return !this.fRedoChanges.empty();
    }

    public boolean anythingToUndo() {
        return !this.fUndoChanges.empty();
    }

    public String peekUndoName() {
        if (this.fUndoNames.size() > 0) {
            return (String)this.fUndoNames.peek();
        }
        return null;
    }

    public String peekRedoName() {
        if (this.fRedoNames.size() > 0) {
            return (String)this.fRedoNames.peek();
        }
        return null;
    }

    private void fireUndoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IUndoManagerListener)listeners[i]).undoStackChanged(this);
            ++i;
        }
    }

    private void fireRedoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IUndoManagerListener)listeners[i]).redoStackChanged(this);
            ++i;
        }
    }

    private void sendDispose(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            final Change change = (Change)iter.next();
            ISafeRunnable r = new ISafeRunnable(){

                public void run() {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            };
            SafeRunner.run((ISafeRunnable)r);
        }
    }

    public boolean testHasNumberOfUndos(int number) {
        return this.fUndoChanges.size() == number;
    }

    public boolean testHasNumberOfRedos(int number) {
        return this.fRedoChanges.size() == number;
    }

    private static class NullQuery
    implements IValidationCheckResultQuery {
        private NullQuery() {
        }

        public boolean proceed(RefactoringStatus status) {
            return true;
        }

        public void stopped(RefactoringStatus status) {
        }
    }
}

