/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class TextChanges {
    private TextChanges() {
    }

    public static IDocument getDocument(IFile file) throws CoreException {
        IPath path;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = manager.getTextFileBuffer(path = file.getFullPath(), LocationKind.IFILE);
        if (buffer == null) {
            return null;
        }
        return buffer.getDocument();
    }

    public static RefactoringStatus isValid(IDocument document, int length) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (length != document.getLength()) {
            result.addFatalError(RefactoringCoreMessages.TextChanges_error_document_content_changed);
        }
        return result;
    }
}

