/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IStateValidationSupport;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractFileBuffer
implements IFileBuffer,
IStateValidationSupport {
    protected IFileStore fFileStore;

    public abstract void create(IPath var1, IProgressMonitor var2) throws CoreException;

    public abstract void connect();

    public abstract void disconnect() throws CoreException;

    protected abstract boolean isDisconnected();

    protected void dispose() {
    }

    public void validationStateAboutToBeChanged() {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        if (fileBufferManager instanceof TextFileBufferManager) {
            TextFileBufferManager manager = (TextFileBufferManager)fileBufferManager;
            manager.fireStateChanging(this);
        }
    }

    public void validationStateChangeFailed() {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        if (fileBufferManager instanceof TextFileBufferManager) {
            TextFileBufferManager manager = (TextFileBufferManager)fileBufferManager;
            manager.fireStateChangeFailed(this);
        }
    }

    public long getModificationStamp() {
        IFileInfo info = this.fFileStore.fetchInfo();
        return info.exists() ? info.getLastModified() : -1L;
    }

    public IFileStore getFileStore() {
        return this.fFileStore;
    }
}

