/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Extension {
    private String extensionName = null;
    private String implementationURL = null;
    private String implementationVendor = null;
    private String implementationVendorId = null;
    private String implementationVersion = null;
    private String specificationVendor = null;
    private String specificationVersion = null;

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public String getImplementationURL() {
        return this.implementationURL;
    }

    public void setImplementationURL(String implementationURL) {
        this.implementationURL = implementationURL;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public void setImplementationVendor(String implementationVendor) {
        this.implementationVendor = implementationVendor;
    }

    public String getImplementationVendorId() {
        return this.implementationVendorId;
    }

    public void setImplementationVendorId(String implementationVendorId) {
        this.implementationVendorId = implementationVendorId;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public void setImplementationVersion(String implementationVersion) {
        this.implementationVersion = implementationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public void setSpecificationVendor(String specificationVendor) {
        this.specificationVendor = specificationVendor;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this.specificationVersion = specificationVersion;
    }

    public boolean isCompatibleWith(Extension required) {
        if (this.extensionName == null) {
            return false;
        }
        if (!this.extensionName.equals(required.getExtensionName())) {
            return false;
        }
        if (!this.isNewer(this.specificationVersion, required.getSpecificationVersion())) {
            return false;
        }
        if (this.implementationVendorId == null) {
            return false;
        }
        if (!this.implementationVendorId.equals(required.getImplementationVendorId())) {
            return false;
        }
        return this.isNewer(this.implementationVersion, required.getImplementationVersion());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Extension[");
        sb.append(this.extensionName);
        if (this.implementationURL != null) {
            sb.append(", implementationURL=");
            sb.append(this.implementationURL);
        }
        if (this.implementationVendor != null) {
            sb.append(", implementationVendor=");
            sb.append(this.implementationVendor);
        }
        if (this.implementationVendorId != null) {
            sb.append(", implementationVendorId=");
            sb.append(this.implementationVendorId);
        }
        if (this.implementationVersion != null) {
            sb.append(", implementationVersion=");
            sb.append(this.implementationVersion);
        }
        if (this.specificationVendor != null) {
            sb.append(", specificationVendor=");
            sb.append(this.specificationVendor);
        }
        if (this.specificationVersion != null) {
            sb.append(", specificationVersion=");
            sb.append(this.specificationVersion);
        }
        sb.append("]");
        return sb.toString();
    }

    public static List getAvailable(Manifest manifest) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        if (manifest == null) {
            return results;
        }
        Extension extension = null;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && (extension = Extension.getAvailable(attributes)) != null) {
            results.add(extension);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            attributes = entries.get(key);
            extension = Extension.getAvailable(attributes);
            if (extension == null) continue;
            results.add(extension);
        }
        return results;
    }

    public static List getRequired(Manifest manifest) {
        ArrayList results = new ArrayList();
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            Iterator required = Extension.getRequired(attributes).iterator();
            while (required.hasNext()) {
                results.add(required.next());
            }
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            attributes = entries.get(key);
            Iterator required = Extension.getRequired(attributes).iterator();
            while (required.hasNext()) {
                results.add(required.next());
            }
        }
        return results;
    }

    private static Extension getAvailable(Attributes attributes) {
        String name = attributes.getValue("Extension-Name");
        if (name == null) {
            return null;
        }
        Extension extension = new Extension();
        extension.setExtensionName(name);
        extension.setImplementationVendor(attributes.getValue("Implementation-Vendor"));
        extension.setImplementationVendorId(attributes.getValue("Implementation-Vendor-Id"));
        extension.setImplementationVersion(attributes.getValue("Implementation-Version"));
        extension.setSpecificationVendor(attributes.getValue("Specification-Vendor"));
        extension.setSpecificationVersion(attributes.getValue("Specification-Version"));
        return extension;
    }

    private static List getRequired(Attributes attributes) {
        int space;
        ArrayList<Extension> results = new ArrayList<Extension>();
        String names = attributes.getValue("Extension-List");
        if (names == null) {
            return results;
        }
        names = names + " ";
        while ((space = names.indexOf(32)) >= 0) {
            String name = names.substring(0, space).trim();
            names = names.substring(space + 1);
            String value = attributes.getValue(name + "-Extension-Name");
            if (value == null) continue;
            Extension extension = new Extension();
            extension.setExtensionName(value);
            extension.setImplementationURL(attributes.getValue(name + "-Implementation-URL"));
            extension.setImplementationVendorId(attributes.getValue(name + "-Implementation-Vendor-Id"));
            extension.setImplementationVersion(attributes.getValue(name + "-Implementation-Version"));
            extension.setSpecificationVersion(attributes.getValue(name + "-Specification-Version"));
            results.add(extension);
        }
        return results;
    }

    private boolean isNewer(String first, String second) throws NumberFormatException {
        if (first == null || second == null) {
            return false;
        }
        if (first.equals(second)) {
            return true;
        }
        StringTokenizer fTok = new StringTokenizer(first, ".", true);
        StringTokenizer sTok = new StringTokenizer(second, ".", true);
        int fVersion = 0;
        int sVersion = 0;
        while (fTok.hasMoreTokens() || sTok.hasMoreTokens()) {
            fVersion = fTok.hasMoreTokens() ? Integer.parseInt(fTok.nextToken()) : 0;
            if (fVersion < (sVersion = sTok.hasMoreTokens() ? Integer.parseInt(sTok.nextToken()) : 0)) {
                return false;
            }
            if (fVersion > sVersion) {
                return true;
            }
            if (fTok.hasMoreTokens()) {
                fTok.nextToken();
            }
            if (!sTok.hasMoreTokens()) continue;
            sTok.nextToken();
        }
        return true;
    }
}

