/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ActiveEditorAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;

public class NewEditorAction
extends ActiveEditorAction {
    public NewEditorAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.NewEditorAction_text, window);
        this.setId("newEditorAction");
        this.setToolTipText(WorkbenchMessages.NewEditorAction_tooltip);
        this.setActionDefinitionId("org.eclipse.ui.window.newEditor");
    }

    public void run() {
        IWorkbenchPage page = this.getActivePage();
        IEditorPart editor = this.getActiveEditor();
        if (page == null || editor == null) {
            return;
        }
        String editorId = editor.getSite().getId();
        if (editorId == null) {
            return;
        }
        try {
            if (editor instanceof IPersistableEditor) {
                XMLMemento editorState = XMLMemento.createWriteRoot("editorState");
                ((IPersistableEditor)((Object)editor)).saveState(editorState);
                ((WorkbenchPage)page).openEditor(editor.getEditorInput(), editorId, true, 0, editorState);
            } else {
                page.openEditor(editor.getEditorInput(), editorId, true, 0);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError(page.getWorkbenchWindow().getShell(), WorkbenchMessages.Error, e.getMessage(), e);
        }
    }
}

