/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteTocParser;

public class RemoteTocProvider
extends AbstractTocProvider {
    private static final String PATH_TOC = "/toc";
    private static final String PARAM_LANG = "lang";

    public RemoteTocProvider() {
        RemoteHelp.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RemoteTocProvider.this.contentChanged();
            }
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITocContribution[] getTocContributions(String locale) {
        if (!RemoteHelp.isEnabled()) return new ITocContribution[0];
        InputStream in = null;
        URL url = RemoteHelp.getURL("/toc?lang=" + locale);
        in = url.openStream();
        RemoteTocParser parser = new RemoteTocParser();
        ITocContribution[] iTocContributionArray = parser.parse(in);
        if (in == null) return iTocContributionArray;
        try {
            in.close();
            return iTocContributionArray;
        }
        catch (IOException iOException) {}
        return iTocContributionArray;
        catch (IOException e) {
            String msg = "I/O error while trying to contact the remote help server";
            HelpBasePlugin.logError(msg, e);
            RemoteHelp.setError(e);
            if (in == null) return new ITocContribution[0];
            try {
                in.close();
                return new ITocContribution[0];
            }
            catch (IOException iOException) {}
            return new ITocContribution[0];
        }
        catch (Throwable t) {
            String msg = "Internal error while reading TOC contents from remote server";
            HelpBasePlugin.logError(msg, t);
            RemoteHelp.setError(t);
            if (in == null) return new ITocContribution[0];
            {
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                in.close();
                return new ITocContribution[0];
            }
            catch (IOException iOException) {}
            return new ITocContribution[0];
        }
    }
}

