/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.help.AbstractContextProvider;
import org.eclipse.help.IContext;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.dynamic.DocumentReader;

public class RemoteContextProvider
extends AbstractContextProvider {
    private static final String PATH_CONTEXT = "/context";
    private static final String PARAM_ID = "id";
    private static final String PARAM_LANG = "lang";
    private DocumentReader reader;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IContext getContext(String id, String locale) {
        InputStream in;
        block17: {
            if (!RemoteHelp.isEnabled()) return null;
            in = null;
            URL url = RemoteHelp.getURL("/context?id=" + id + '&' + PARAM_LANG + '=' + locale);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) break block17;
            in = connection.getInputStream();
            if (this.reader == null) {
                this.reader = new DocumentReader();
            }
            Context context = (Context)this.reader.read(in);
            if (in == null) return context;
            try {
                in.close();
                return context;
            }
            catch (IOException iOException) {}
            return context;
            catch (IOException e) {
                String msg = "I/O error while trying to contact the remote help server";
                HelpBasePlugin.logError(msg, e);
                if (in == null) return null;
                try {
                    in.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (Throwable t) {
                String msg = "Internal error while reading context-sensitive help data from remote server";
                HelpBasePlugin.logError(msg, t);
                if (in == null) return null;
                {
                    catch (Throwable throwable) {
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    in.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public String[] getPlugins() {
        return null;
    }
}

