/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.actions.CollapseAllAction;
import org.eclipse.ui.internal.navigator.actions.LinkEditorAction;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperService;
import org.eclipse.ui.internal.navigator.filters.FilterActionGroup;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class CommonNavigatorActionGroup
extends ActionGroup {
    private LinkEditorAction toggleLinkingAction;
    private CollapseAllAction collapseAllAction;
    private FilterActionGroup filterGroup;
    private final CommonViewer commonViewer;
    private CommonNavigator commonNavigator;
    private final LinkHelperService linkHelperService;

    public CommonNavigatorActionGroup(CommonNavigator aNavigator, CommonViewer aViewer, LinkHelperService linkHelperService) {
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.linkHelperService = linkHelperService;
        this.makeActions();
    }

    protected final ImageDescriptor getImageDescriptor(String relativePath) {
        return NavigatorPlugin.getImageDescriptor("icons/full/" + relativePath);
    }

    private void makeActions() {
        boolean hideCollapseAllAction;
        INavigatorViewerDescriptor viewerDescriptor = this.commonViewer.getNavigatorContentService().getViewerDescriptor();
        boolean hideLinkWithEditorAction = viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideLinkWithEditorAction");
        if (!hideLinkWithEditorAction) {
            this.toggleLinkingAction = new LinkEditorAction(this.commonNavigator, this.commonViewer, this.linkHelperService);
            ImageDescriptor syncIcon = this.getImageDescriptor("elcl16/synced.gif");
            this.toggleLinkingAction.setImageDescriptor(syncIcon);
            this.toggleLinkingAction.setHoverImageDescriptor(syncIcon);
        }
        if (!(hideCollapseAllAction = viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideCollapseAllAction"))) {
            this.collapseAllAction = new CollapseAllAction(this.commonViewer);
            ImageDescriptor collapseAllIcon = this.getImageDescriptor("elcl16/collapseall.gif");
            this.collapseAllAction.setImageDescriptor(collapseAllIcon);
            this.collapseAllAction.setHoverImageDescriptor(collapseAllIcon);
        }
        this.filterGroup = new FilterActionGroup(this.commonViewer);
    }

    public void fillActionBars(IActionBars theActionBars) {
        IMenuManager menu = theActionBars.getMenuManager();
        this.filterGroup.fillActionBars(theActionBars);
        if (this.collapseAllAction != null) {
            theActionBars.getToolBarManager().add((IAction)this.collapseAllAction);
        }
        if (this.toggleLinkingAction != null) {
            menu.insertAfter("additions-end", (IAction)this.toggleLinkingAction);
            theActionBars.getToolBarManager().add((IAction)this.toggleLinkingAction);
        }
        theActionBars.updateActionBars();
    }

    public void dispose() {
        super.dispose();
        if (this.toggleLinkingAction != null) {
            this.toggleLinkingAction.dispose();
        }
    }
}

